/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class NoTxConnectorAllocator
extends AbstractConnectorAllocator {
    public NoTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
    }

    @Override
    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = this.createResourceHandle(mc, this.spec, this, this.info);
            ConnectionListenerImpl l = new ConnectionListenerImpl(resource);
            mc.addConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)l);
            return resource;
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            resource.fillInResourceObjects(con, null);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            mc.destroy();
        }
        catch (Exception ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    class ConnectionListenerImpl
    extends ConnectionEventListener {
        private final ResourceHandle resource;

        ConnectionListenerImpl(ResourceHandle resource) {
            this.resource = resource;
        }

        public void connectionClosed(ConnectionEvent evt) {
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, false);
        }

        @Override
        public void badConnectionClosed(ConnectionEvent evt) {
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
            NoTxConnectorAllocator.this.poolMgr.badResourceClosed(this.resource);
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            ManagedConnection mc = (ManagedConnection)evt.getSource();
            mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
            NoTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            this.resource.setConnectionErrorOccurred();
        }

        public void localTransactionStarted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
            throw new IllegalStateException("local transaction not supported");
        }
    }
}

