/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.inject.Inject;
import jakarta.inject.Scope;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.Rank;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.WeldDeployer;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.CDIAroundConstructCallback;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=10)
public class CDIServiceImpl
implements CDIService {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.glassfish.cdi.LogMessages";
    @LoggerInfo(subsystem="AS-WELD", description="WELD", publish=true)
    public static final String WELD_LOGGER_SUBSYSTEM_NAME = "jakarta.enterprise.resource.weld";
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.resource.weld", "org.glassfish.cdi.LogMessages");
    private static final Set<String> validScopes = new HashSet<String>();
    private static final HashSet<String> excludedScopes;
    @Inject
    private WeldDeployer weldDeployer;
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;

    public boolean isCurrentModuleCDIEnabled() {
        BundleDescriptor bundle = null;
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            return false;
        }
        JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(componentInvocation.getComponentId());
        if (componentEnv != null) {
            if (componentEnv instanceof BundleDescriptor) {
                bundle = (BundleDescriptor)componentEnv;
            } else if (componentEnv instanceof com.sun.enterprise.deployment.EjbDescriptor) {
                bundle = ((com.sun.enterprise.deployment.EjbDescriptor)componentEnv).getEjbBundleDescriptor();
            }
        }
        return bundle != null ? this.isCDIEnabled(bundle) : false;
    }

    public boolean isCDIEnabled(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        return this.weldDeployer.isCdiEnabled(topLevelBundleDesc);
    }

    public boolean isCDIScoped(Class<?> clazz) {
        return WeldUtils.hasValidAnnotation(clazz, validScopes, excludedScopes);
    }

    public void setELResolver(ServletContext servletContext) throws NamingException {
        InitialContext context = new InitialContext();
        BeanManager beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        if (beanManager != null) {
            servletContext.setAttribute("org.glassfish.jsp.beanManagerELResolver", (Object)beanManager.getELResolver());
        }
    }

    public <T> CDIService.CDIInjectionContext<T> createCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejbDesc, T instance, Map<Class, Object> ejbInfo) {
        return this._createCDIInjectionContext(ejbDesc, instance, ejbInfo);
    }

    public <T> CDIService.CDIInjectionContext<T> createCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejbDesc, Map<Class, Object> ejbInfo) {
        return this._createCDIInjectionContext(ejbDesc, null, ejbInfo);
    }

    private <T> CDIService.CDIInjectionContext<T> _createCDIInjectionContext(com.sun.enterprise.deployment.EjbDescriptor ejb, T instance, Map<Class, Object> ejbInfo) {
        Object beanInstance;
        BaseContainer baseContainer = null;
        EJBContextImpl ejbContext = null;
        CDIInjectionContextImpl cdiContext = null;
        WeldCreationalContext creationalContext = null;
        if (ejbInfo != null) {
            baseContainer = (BaseContainer)ejbInfo.get(BaseContainer.class);
            ejbContext = (EJBContextImpl)ejbInfo.get(EJBContextImpl.class);
        }
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive beanDeploymentArchive = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl weldManager = bootstrap.getManager(beanDeploymentArchive);
        EjbDescriptor ejbDesc = weldManager.getEjbDescriptor(ejb.getName());
        if (ejbInfo != null) {
            cdiContext = (CDIInjectionContextImpl)ejbInfo.get(CDIService.CDIInjectionContext.class);
        }
        if (cdiContext != null) {
            creationalContext = cdiContext.getCreationalContext();
        }
        if (creationalContext == null) {
            Bean bean = weldManager.getBean(ejbDesc);
            creationalContext = weldManager.createCreationalContext((Contextual)bean);
            cdiContext.setCreationalContext(creationalContext);
        }
        InjectionTarget<T> injectionTarget = null;
        injectionTarget = ejbDesc.isMessageDriven() ? this.createMdbInjectionTarget((WeldManager)weldManager, ejbDesc) : weldManager.createInjectionTarget(ejbDesc);
        if (cdiContext != null) {
            cdiContext.setInjectionTarget(injectionTarget);
        }
        org.jboss.weld.contexts.WeldCreationalContext weldCreationalContext = (org.jboss.weld.contexts.WeldCreationalContext)creationalContext;
        weldCreationalContext.setConstructorInterceptionSuppressed(true);
        CDIAroundConstructCallback aroundConstructCallback = new CDIAroundConstructCallback(baseContainer, ejbContext);
        weldCreationalContext.registerAroundConstructCallback(aroundConstructCallback);
        if (cdiContext != null) {
            cdiContext.setCDIAroundConstructCallback(aroundConstructCallback);
        }
        if ((beanInstance = instance) == null) {
            beanInstance = injectionTarget.produce((CreationalContext)creationalContext);
        }
        if (cdiContext != null) {
            cdiContext.setInstance(beanInstance);
        }
        return cdiContext;
    }

    private <T> InjectionTarget<T> createMdbInjectionTarget(WeldManager weldManager, EjbDescriptor<T> ejbDesc) {
        AnnotatedType type = weldManager.createAnnotatedType(ejbDesc.getBeanClass());
        WeldInjectionTarget target = weldManager.createInjectionTargetBuilder(type).setDecorationEnabled(false).setInterceptionEnabled(false).setTargetClassLifecycleCallbacksEnabled(false).setBean(weldManager.getBean(ejbDesc)).build();
        return weldManager.fireProcessInjectionTarget(type, (InjectionTarget)target);
    }

    private BeanDeploymentArchive getBDAForBeanClass(BundleDescriptor bundleDesc, String beanClassName) {
        BeanDeploymentArchive topLevelBeanDeploymentArchive;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AS-CDI-00043", new Object[]{bundleDesc.getModuleName(), beanClassName});
        }
        if ((topLevelBeanDeploymentArchive = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundleDesc)).getBeanClasses().contains(beanClassName)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "AS-CDI-00044", new Object[]{topLevelBeanDeploymentArchive.getId(), beanClassName});
            }
            return topLevelBeanDeploymentArchive;
        }
        for (BeanDeploymentArchive bda : topLevelBeanDeploymentArchive.getBeanDeploymentArchives()) {
            if (!bda.getBeanClasses().contains(beanClassName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "AS-CDI-00045", new Object[]{bda.getId(), beanClassName});
            }
            return bda;
        }
        return topLevelBeanDeploymentArchive;
    }

    public <T> void injectEJBInstance(CDIService.CDIInjectionContext<T> injectionCtx) {
        CDIInjectionContextImpl injectionCtxImpl = (CDIInjectionContextImpl)injectionCtx;
        injectionCtxImpl.injectionTarget.inject(injectionCtxImpl.instance, injectionCtxImpl.creationalContext);
    }

    public <T> CDIService.CDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle) {
        return this.createManagedObject(managedClass, bundle, true);
    }

    public void injectManagedObject(Object managedObject, BundleDescriptor bundle) {
        BeanManager beanManager = this.getBeanManagerFromBundle(bundle);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(beanManager.createAnnotatedType(managedObject.getClass()));
        injectionTargetFactory.createInjectionTarget(null).inject(managedObject, beanManager.createCreationalContext(null));
    }

    private Interceptor findEjbInterceptor(Class<?> interceptorClass, Set<EjbInterceptor> ejbInterceptors) {
        for (EjbInterceptor oneInterceptor : ejbInterceptors) {
            Interceptor interceptor = oneInterceptor.getInterceptor();
            if (interceptor == null || !interceptor.getBeanClass().equals(interceptorClass)) continue;
            return oneInterceptor.getInterceptor();
        }
        return null;
    }

    public <T> T createInterceptorInstance(Class<T> interceptorClass, com.sun.enterprise.deployment.EjbDescriptor ejb, CDIService.CDIInjectionContext ejbContext, Set<EjbInterceptor> ejbInterceptors) {
        Interceptor interceptor;
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)ejb.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive bda = this.getBDAForBeanClass(topLevelBundleDesc, ejb.getEjbClassName());
        WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(ejb.getEjbBundleDescriptor().getApplication());
        BeanManagerImpl beanManager = bootstrap.getManager(bda);
        EjbDescriptor ejbDesc = beanManager.getEjbDescriptor(ejb.getName());
        CreationalContext creationalContext = ejbContext.getCreationalContext();
        if (creationalContext == null) {
            Bean bean = beanManager.getBean(ejbDesc);
            creationalContext = beanManager.createCreationalContext((Contextual)bean);
            ejbContext.setCreationalContext(creationalContext);
        }
        if ((interceptor = this.findEjbInterceptor(interceptorClass, ejbInterceptors)) != null) {
            Object instance = null;
            if (beanManager instanceof BeanManagerImpl) {
                BeanManagerImpl beanManagerImpl = beanManager;
                instance = beanManagerImpl.getReference((Bean)interceptor, interceptorClass, creationalContext, false);
            } else {
                instance = beanManager.getReference((Bean)interceptor, interceptorClass, creationalContext);
            }
            return (T)instance;
        }
        Set availableBeans = beanManager.getBeans(interceptorClass, new Annotation[0]);
        if (availableBeans != null && !availableBeans.isEmpty()) {
            Bean interceptorBean = beanManager.resolve(availableBeans);
            Object instance = beanManager.getReference(interceptorBean, interceptorClass, creationalContext);
            return (T)instance;
        }
        creationalContext = beanManager.createCreationalContext(null);
        WeldInjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(beanManager.createAnnotatedType(interceptorClass)).createInterceptorInjectionTarget();
        Object interceptorInstance = injectionTarget.produce(creationalContext);
        injectionTarget.inject(interceptorInstance, creationalContext);
        ejbContext.addDependentContext(new CDIInjectionContextImpl<Object>((InjectionTarget)injectionTarget, creationalContext, interceptorInstance));
        return (T)interceptorInstance;
    }

    public <T> CDIService.CDIInjectionContext<T> createManagedObject(Class<T> managedClass, BundleDescriptor bundle, boolean invokePostConstruct) {
        InjectionTarget injectionTarget;
        BeanDeploymentArchiveImpl beanDeploymentArchive = this.getBeanDeploymentArchiveFromBundle(bundle);
        WeldManager beanManager = this.getWeldManagerFromBundle(bundle, beanDeploymentArchive);
        NoPostConstructPreDestroyAnnotatedType annotatedType = beanManager.createAnnotatedType(managedClass);
        if (!invokePostConstruct) {
            annotatedType = new NoPostConstructPreDestroyAnnotatedType(annotatedType);
        }
        if ((injectionTarget = beanDeploymentArchive.getInjectionTarget(annotatedType)) == null) {
            injectionTarget = beanManager.fireProcessInjectionTarget(annotatedType);
        }
        WeldCreationalContext creationalContext = beanManager.createCreationalContext(null);
        Object managedObject = injectionTarget.produce((CreationalContext)creationalContext);
        injectionTarget.inject(managedObject, (CreationalContext)creationalContext);
        if (invokePostConstruct) {
            injectionTarget.postConstruct(managedObject);
        }
        return new CDIInjectionContextImpl<Object>(injectionTarget, (CreationalContext)creationalContext, managedObject);
    }

    private BeanDeploymentArchiveImpl getBeanDeploymentArchiveFromBundle(BundleDescriptor bundle) {
        return (BeanDeploymentArchiveImpl)this.weldDeployer.getBeanDeploymentArchiveForBundle((BundleDescriptor)bundle.getModuleDescriptor().getDescriptor());
    }

    private BeanManager getBeanManagerFromBundle(BundleDescriptor bundle) {
        BundleDescriptor topLevelBundleDesc = (BundleDescriptor)bundle.getModuleDescriptor().getDescriptor();
        BeanDeploymentArchive beanDeploymentArchive = this.weldDeployer.getBeanDeploymentArchiveForBundle(topLevelBundleDesc);
        return this.getWeldManagerFromBundle(bundle, beanDeploymentArchive);
    }

    private WeldManager getWeldManagerFromBundle(BundleDescriptor bundle, BeanDeploymentArchive beanDeploymentArchive) {
        return this.weldDeployer.getBootstrapForApp(bundle.getApplication()).getManager(beanDeploymentArchive);
    }

    public CDIService.CDIInjectionContext createEmptyCDIInjectionContext() {
        return new CDIInjectionContextImpl();
    }

    static {
        validScopes.add(Scope.class.getName());
        validScopes.add(NormalScope.class.getName());
        validScopes.add(RequestScoped.class.getName());
        validScopes.add(SessionScoped.class.getName());
        validScopes.add(ApplicationScoped.class.getName());
        validScopes.add(ConversationScoped.class.getName());
        excludedScopes = new HashSet();
        excludedScopes.add(Dependent.class.getName());
    }

    private static class CDIInjectionContextImpl<T>
    implements CDIService.CDIInjectionContext<T> {
        InjectionTarget injectionTarget;
        CreationalContext creationalContext;
        T instance;
        private final List<CDIService.CDIInjectionContext> dependentContexts = new ArrayList<CDIService.CDIInjectionContext>();
        private CDIAroundConstructCallback cdiAroundConstructCallback;

        public CDIInjectionContextImpl() {
        }

        public CDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, T i) {
            this.injectionTarget = it;
            this.creationalContext = cc;
            this.instance = i;
        }

        public T getInstance() {
            return this.instance;
        }

        public void setInstance(T instance) {
            this.instance = instance;
        }

        public void cleanup(boolean callPreDestroy) {
            for (CDIService.CDIInjectionContext context : this.dependentContexts) {
                context.cleanup(true);
            }
            if (callPreDestroy && this.injectionTarget != null) {
                this.injectionTarget.preDestroy(this.instance);
            }
            if (this.injectionTarget != null) {
                this.injectionTarget.dispose(this.instance);
            }
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
        }

        public InjectionTarget<T> getInjectionTarget() {
            return this.injectionTarget;
        }

        public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public CreationalContext<T> getCreationalContext() {
            return this.creationalContext;
        }

        public void setCreationalContext(CreationalContext<T> creationalContext) {
            this.creationalContext = creationalContext;
        }

        public void addDependentContext(CDIService.CDIInjectionContext dependentContext) {
            this.dependentContexts.add(dependentContext);
        }

        public Collection<CDIService.CDIInjectionContext> getDependentContexts() {
            return this.dependentContexts;
        }

        public T createEjbAfterAroundConstruct() {
            if (this.cdiAroundConstructCallback != null) {
                this.setInstance(this.cdiAroundConstructCallback.createEjb());
            }
            return this.instance;
        }

        public void setCDIAroundConstructCallback(CDIAroundConstructCallback cdiAroundConstructCallback) {
            this.cdiAroundConstructCallback = cdiAroundConstructCallback;
        }
    }

    private static class NoPostConstructPreDestroyAnnotatedType<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> delegate;

        private NoPostConstructPreDestroyAnnotatedType(AnnotatedType<X> delegate) {
            this.delegate = delegate;
        }

        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.delegate.getAnnotation(annotationType);
        }

        public Set<Annotation> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }

        public Class<X> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.delegate.getConstructors();
        }

        public Set<AnnotatedMethod<? super X>> getMethods() {
            HashSet<AnnotatedMethod<X>> retVal = new HashSet<AnnotatedMethod<X>>();
            for (AnnotatedMethod m : this.delegate.getMethods()) {
                if (m.isAnnotationPresent(PostConstruct.class) || m.isAnnotationPresent(PreDestroy.class)) continue;
                retVal.add(m);
            }
            return retVal;
        }

        public Set<AnnotatedField<? super X>> getFields() {
            return this.delegate.getFields();
        }
    }
}

