/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.rest;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.Sse;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProvider;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class RestExtension
implements Extension {
    private static final LazyValue<Set<Class<?>>> REST_BOUND_INJECTABLES = Values.lazy(() -> RestExtension.sumNonJerseyBoundInjectables());

    private void processAnnotatedType(@Observes ProcessAnnotatedType<?> processAnnotatedType, BeanManager beanManager) {
        Class baseClass = (Class)processAnnotatedType.getAnnotatedType().getBaseType();
        if (Application.class.isAssignableFrom(baseClass) && Configuration.class.isAssignableFrom(baseClass) && !baseClass.isAnnotationPresent(Alternative.class)) {
            processAnnotatedType.veto();
        }
    }

    private void beforeDiscoveryObserver(@Observes BeforeBeanDiscovery bbf, BeanManager beanManager) {
        CdiComponentProvider.addHK2DepenendencyCheck(RestExtension::isHK2Dependency);
    }

    private static final boolean isHK2Dependency(Class<?> clazz) {
        return ((Set)REST_BOUND_INJECTABLES.get()).contains(clazz);
    }

    private static Set<Class<?>> sumNonJerseyBoundInjectables() {
        HashSet injectables = new HashSet();
        injectables.add(Application.class);
        injectables.add(Configuration.class);
        injectables.add(ContainerRequestContext.class);
        injectables.add(HttpHeaders.class);
        injectables.add(ParamConverterProvider.class);
        injectables.add(Providers.class);
        injectables.add(Request.class);
        injectables.add(ResourceContext.class);
        injectables.add(ResourceInfo.class);
        injectables.add(SecurityContext.class);
        injectables.add(Sse.class);
        injectables.add(UriInfo.class);
        return injectables;
    }
}

