/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class MessageSecurityConfigEventListenerImpl
implements ConfigListener {
    private static final Logger LOG = LogDomains.getLogger(MessageSecurityConfigEventListenerImpl.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    @Inject
    @Named(value="default-instance-name")
    private SecurityService service;

    public <T extends ConfigBeanProxy> NotProcessed handleUpdate(T instance) {
        LOG.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleUpdate called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
            return null;
        }
        return new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
    }

    public <T extends ConfigBeanProxy> NotProcessed handleDelete(T instance) {
        LOG.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleDelete called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
            return null;
        }
        return new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
    }

    public <T extends ConfigBeanProxy> NotProcessed handleCreate(T instance) {
        LOG.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleCreate called");
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
            return null;
        }
        return new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        Changed notificationTarget = new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                switch (type) {
                    case ADD: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "A new " + changedType.getName() + " was added: " + changedInstance);
                        }
                        return MessageSecurityConfigEventListenerImpl.this.handleCreate(changedInstance);
                    }
                    case CHANGE: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("A " + changedType.getName() + " was changed: " + changedInstance);
                        }
                        return MessageSecurityConfigEventListenerImpl.this.handleUpdate(changedInstance);
                    }
                    case REMOVE: {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("A " + changedType.getName() + " was removed: " + changedInstance);
                        }
                        return MessageSecurityConfigEventListenerImpl.this.handleDelete(changedInstance);
                    }
                }
                return null;
            }
        };
        ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)notificationTarget, (Logger)LOG);
        return null;
    }
}

