/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.managedbean;

import com.sun.enterprise.container.common.impl.managedbean.ManagedBeanNamingProxy;
import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.container.common.spi.InterceptorInvoker;
import com.sun.enterprise.container.common.spi.JavaEEInterceptorBuilder;
import com.sun.enterprise.container.common.spi.JavaEEInterceptorBuilderFactory;
import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.container.common.spi.util.InterceptorInfo;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="ManagedBeanManagerImpl")
@RunLevel(value=20, mode=0)
public class ManagedBeanManagerImpl
implements ManagedBeanManager,
PostConstruct,
EventListener {
    private static final Logger LOG = LogDomains.getLogger(ManagedBeanManagerImpl.class, (String)"jakarta.enterprise.system.core", (boolean)false);
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InjectionManager injectionManager;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;
    private final Map<BundleDescriptor, Map<Object, CDIService.CDIInjectionContext>> cdiManagedBeanInstanceMap = new HashMap<BundleDescriptor, Map<Object, CDIService.CDIInjectionContext>>();
    private final Map<String, NamingObjectProxy> appClientManagedBeans = new HashMap<String, NamingObjectProxy>();

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.processType = this.processEnv.getProcessType();
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_LOADED)) {
            ApplicationInfo info = (ApplicationInfo)Deployment.APPLICATION_LOADED.getHook(event);
            this.loadManagedBeans(info);
            this.registerAppLevelDependencies(info);
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            this.doCleanup((Application)((ApplicationInfo)Deployment.APPLICATION_UNLOADED.getHook(event)).getMetaData(Application.class));
        } else if (event.is(Deployment.DEPLOYMENT_FAILURE)) {
            this.doCleanup((Application)((DeploymentContext)Deployment.DEPLOYMENT_FAILURE.getHook(event)).getModuleMetaData(Application.class));
        }
    }

    private void doCleanup(Application app) {
        if (app != null) {
            this.unloadManagedBeans(app);
            this.unregisterAppLevelDependencies(app);
        }
    }

    private void registerAppLevelDependencies(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)app);
        }
        catch (Exception e) {
            throw new RuntimeException("Error binding app-level env dependencies " + app.getAppName(), e);
        }
    }

    private void unregisterAppLevelDependencies(Application app) {
        if (app != null) {
            try {
                this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)app);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Exception unbinding app objects", e);
            }
        }
    }

    private void loadManagedBeans(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        this.loadManagedBeans(app);
    }

    @Override
    public void loadManagedBeans(Application app) {
        CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            boolean isCDIBundle = cdiService != null && cdiService.isCDIEnabled(bundle);
            for (ManagedBeanDescriptor managedBeanDescriptor : bundle.getManagedBeans()) {
                try {
                    Set interceptorClasses = managedBeanDescriptor.getAllInterceptorClasses();
                    Class<?> targetClass = bundle.getClassLoader().loadClass(managedBeanDescriptor.getBeanClassName());
                    InterceptorInfo interceptorInfo = new InterceptorInfo();
                    interceptorInfo.setTargetClass(targetClass);
                    interceptorInfo.setInterceptorClassNames(interceptorClasses);
                    interceptorInfo.setAroundConstructInterceptors(managedBeanDescriptor.getAroundConstructCallbackInterceptors(targetClass, this.getConstructor(targetClass, isCDIBundle)));
                    interceptorInfo.setPostConstructInterceptors(managedBeanDescriptor.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT));
                    interceptorInfo.setPreDestroyInterceptors(managedBeanDescriptor.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY));
                    if (managedBeanDescriptor.hasAroundInvokeMethod()) {
                        interceptorInfo.setHasTargetClassAroundInvoke(true);
                    }
                    HashMap<Method, List<InterceptorDescriptor>> interceptorChains = new HashMap<Method, List<InterceptorDescriptor>>();
                    for (Method targetMethod : targetClass.getMethods()) {
                        interceptorChains.put(targetMethod, managedBeanDescriptor.getAroundInvokeInterceptors(targetMethod));
                    }
                    interceptorInfo.setAroundInvokeInterceptorChains(interceptorChains);
                    interceptorInfo.setSupportRuntimeDelegate(true);
                    JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.serviceLocator.getService(JavaEEInterceptorBuilderFactory.class, new Annotation[0]);
                    JavaEEInterceptorBuilder builder = interceptorBuilderFactory.createBuilder(interceptorInfo);
                    managedBeanDescriptor.setInterceptorBuilder((Object)builder);
                    this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)managedBeanDescriptor);
                    SimpleJndiName jndiName = managedBeanDescriptor.getGlobalJndiName();
                    ManagedBeanNamingProxy namingProxy = new ManagedBeanNamingProxy(managedBeanDescriptor, this.serviceLocator);
                    if (this.processType.isServer()) {
                        this.namingManager.publishObject(jndiName, (Object)namingProxy, true);
                        continue;
                    }
                    this.appClientManagedBeans.put(jndiName.toString(), namingProxy);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error binding ManagedBean " + managedBeanDescriptor.getBeanClassName() + " with name = " + managedBeanDescriptor.getName(), e);
                }
            }
            this.cdiManagedBeanInstanceMap.put(bundle, Collections.synchronizedMap(new HashMap()));
        }
    }

    private Constructor<?> getConstructor(Class<?> clz, boolean isCDIBundle) throws Exception {
        if (isCDIBundle) {
            for (Constructor<?> ctor : clz.getDeclaredConstructors()) {
                if (ctor.getAnnotation(Inject.class) == null) continue;
                return ctor;
            }
        }
        return clz.getConstructor(new Class[0]);
    }

    @Override
    public Object getManagedBean(String globalJndiName) throws Exception {
        NamingObjectProxy proxy = this.appClientManagedBeans.get(globalJndiName);
        if (proxy == null) {
            return null;
        }
        return proxy.create((Context)new InitialContext());
    }

    @Override
    public void registerRuntimeInterceptor(Object interceptorInstance, BundleDescriptor bundle) {
        for (ManagedBeanDescriptor managedBeanDescriptor : bundle.getManagedBeans()) {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)managedBeanDescriptor.getInterceptorBuilder();
            interceptorBuilder.addRuntimeInterceptor(interceptorInstance);
        }
    }

    @Override
    public void unloadManagedBeans(Application app) {
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            Map<Object, CDIService.CDIInjectionContext> cdiInstances = this.cdiManagedBeanInstanceMap.remove(bundle);
            if (cdiInstances != null) {
                for (CDIService.CDIInjectionContext<Object> cDIInjectionContext : cdiInstances.values()) {
                    try {
                        cDIInjectionContext.cleanup(true);
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Exception during CDI cleanup for " + cDIInjectionContext, e);
                    }
                }
            }
            for (ManagedBeanDescriptor managedBeanDescriptor : bundle.getManagedBeans()) {
                for (Object instance : managedBeanDescriptor.getBeanInstances()) {
                    InterceptorInvoker invoker = (InterceptorInvoker)managedBeanDescriptor.getSupportingInfoForBeanInstance(instance);
                    try {
                        invoker.invokePreDestroy();
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Managed bean " + managedBeanDescriptor.getBeanClassName() + " PreDestroy", e);
                    }
                }
                ComponentEnvManager compEnvManager = (ComponentEnvManager)this.serviceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
                try {
                    compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)managedBeanDescriptor);
                }
                catch (NamingException ne) {
                    LOG.log(Level.FINE, "Managed bean " + managedBeanDescriptor.getBeanClassName() + " unbind", ne);
                }
                GlassfishNamingManager namingManager = (GlassfishNamingManager)this.serviceLocator.getService(GlassfishNamingManager.class, new Annotation[0]);
                SimpleJndiName jndiName = managedBeanDescriptor.getGlobalJndiName();
                if (this.processType.isServer()) {
                    try {
                        namingManager.unpublishObject(jndiName);
                    }
                    catch (NamingException ne) {
                        LOG.log(Level.FINE, "Error unpubishing managed bean " + managedBeanDescriptor.getBeanClassName() + " with jndi name " + jndiName, ne);
                    }
                } else {
                    this.appClientManagedBeans.remove(jndiName);
                }
                managedBeanDescriptor.clearAllBeanInstanceInfo();
            }
        }
    }

    private boolean bundleEligible(BundleDescriptor bundle) {
        if (this.processType.isServer()) {
            return bundle instanceof WebBundleDescriptor || bundle instanceof EjbBundleDescriptor;
        }
        if (this.processType == ProcessEnvironment.ProcessType.ACC) {
            return bundle instanceof ApplicationClientDescriptor;
        }
        return false;
    }

    @Override
    public <T> T createManagedBean(Class<T> managedBeanClass) throws Exception {
        ManagedBeanDescriptor managedBeanDesc = null;
        try {
            BundleDescriptor bundle = this.getBundle();
            managedBeanDesc = bundle.getManagedBeanByBeanClass(managedBeanClass.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createManagedBean(managedBeanDesc, managedBeanClass);
    }

    @Override
    public <T> T createManagedBean(Class<T> managedBeanClass, boolean invokePostConstruct) throws Exception {
        ManagedBeanDescriptor managedBeanDescriptor = null;
        try {
            managedBeanDescriptor = this.getBundle().getManagedBeanByBeanClass(managedBeanClass.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createManagedBean(managedBeanDescriptor, managedBeanClass, invokePostConstruct);
    }

    @Override
    public <T> T createManagedBean(ManagedBeanDescriptor managedBeanDescriptor, Class<T> managedBeanClass) throws Exception {
        CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
        BundleDescriptor bundleDescriptor = null;
        bundleDescriptor = managedBeanDescriptor == null ? this.getBundle() : managedBeanDescriptor.getBundleDescriptor();
        if (bundleDescriptor == null) {
            throw new IllegalStateException("Class " + managedBeanClass + " is not a valid EE ManagedBean class");
        }
        Object callerObject = null;
        if (cdiService != null && cdiService.isCDIEnabled(bundleDescriptor)) {
            CDIService.CDIInjectionContext<T> cdiContext = cdiService.createManagedObject(managedBeanClass, bundleDescriptor);
            callerObject = cdiContext.getInstance();
            Map<Object, CDIService.CDIInjectionContext> bundleNonManagedObjs = this.cdiManagedBeanInstanceMap.get(bundleDescriptor);
            bundleNonManagedObjs.put(callerObject, cdiContext);
        } else {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)managedBeanDescriptor.getInterceptorBuilder();
            InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(null);
            callerObject = interceptorInvoker.getProxy();
            for (Object interceptorInstance : interceptorInvoker.getInterceptorInstances()) {
                this.inject(interceptorInstance, managedBeanDescriptor);
            }
            interceptorInvoker.invokeAroundConstruct();
            Object managedBean = interceptorInvoker.getTargetInstance();
            this.inject(managedBean, managedBeanDescriptor);
            interceptorInvoker.invokePostConstruct();
            managedBeanDescriptor.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        }
        return (T)callerObject;
    }

    @Override
    public <T> T createManagedBean(ManagedBeanDescriptor managedBeanDescriptor, Class<T> managedBeanClass, boolean invokePostConstruct) throws Exception {
        CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
        BundleDescriptor bundleDescriptor = null;
        bundleDescriptor = managedBeanDescriptor == null ? this.getBundle() : managedBeanDescriptor.getBundleDescriptor();
        if (bundleDescriptor == null) {
            throw new IllegalStateException("Class " + managedBeanClass + " is not a valid EE ManagedBean class");
        }
        Object callerObject = null;
        if (cdiService != null && cdiService.isCDIEnabled(bundleDescriptor)) {
            CDIService.CDIInjectionContext<T> cdiContext = cdiService.createManagedObject(managedBeanClass, bundleDescriptor, invokePostConstruct);
            callerObject = cdiContext.getInstance();
            Map<Object, CDIService.CDIInjectionContext> bundleNonManagedObjs = this.cdiManagedBeanInstanceMap.get(bundleDescriptor);
            bundleNonManagedObjs.put(callerObject, cdiContext);
        } else {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)managedBeanDescriptor.getInterceptorBuilder();
            T managedBean = managedBeanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(managedBean);
            callerObject = interceptorInvoker.getProxy();
            Object[] interceptorInstances = interceptorInvoker.getInterceptorInstances();
            this.inject(managedBean, managedBeanDescriptor);
            for (Object interceptorInstance : interceptorInstances) {
                this.inject(interceptorInstance, managedBeanDescriptor);
            }
            interceptorInvoker.invokePostConstruct();
            managedBeanDescriptor.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        }
        return (T)callerObject;
    }

    @Override
    public boolean isManagedBean(Object object) {
        JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.serviceLocator.getService(JavaEEInterceptorBuilderFactory.class, new Annotation[0]);
        if (interceptorBuilderFactory == null) {
            return false;
        }
        return interceptorBuilderFactory.isClientProxy(object);
    }

    private void inject(Object instance, ManagedBeanDescriptor managedBeanDesc) throws Exception {
        BundleDescriptor bundle = managedBeanDesc.getBundle();
        if (bundle instanceof EjbBundleDescriptor || bundle instanceof ApplicationClientDescriptor) {
            this.injectionManager.injectInstance(instance, managedBeanDesc.getGlobalJndiName(), false);
        } else {
            this.injectionManager.injectInstance(instance, (JndiNameEnvironment)bundle, false);
        }
    }

    @Override
    public void destroyManagedBean(Object managedBean) {
        this.destroyManagedBean(managedBean, true);
    }

    @Override
    public void destroyManagedBean(Object managedBean, boolean validate) {
        BundleDescriptor bundle = this.getBundle();
        CDIService cdiService = (CDIService)this.serviceLocator.getService(CDIService.class, new Annotation[0]);
        if (cdiService != null && cdiService.isCDIEnabled(bundle)) {
            Map<Object, CDIService.CDIInjectionContext> bundleNonManagedObjs = this.cdiManagedBeanInstanceMap.get(bundle);
            if (bundleNonManagedObjs == null) {
                if (validate) {
                    throw new IllegalStateException("Unknown CDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
                }
                LOG.log(Level.FINE, "Unknown CDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
            } else {
                CDIService.CDIInjectionContext context = bundleNonManagedObjs.remove(managedBean);
                if (context == null) {
                    if (validate) {
                        throw new IllegalStateException("Unknown CDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
                    }
                    LOG.log(Level.FINE, "Unknown CDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
                    return;
                }
                context.cleanup(true);
            }
        } else {
            Object managedBeanInstance = null;
            try {
                final Field proxyField = managedBean.getClass().getDeclaredField("__ejb31_delegate");
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (!proxyField.isAccessible()) {
                            proxyField.setAccessible(true);
                        }
                        return null;
                    }
                });
                Proxy proxy = (Proxy)proxyField.get(managedBean);
                InterceptorInvoker invoker = (InterceptorInvoker)((Object)Proxy.getInvocationHandler(proxy));
                managedBeanInstance = invoker.getTargetInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid managed bean " + managedBean, e);
            }
            ManagedBeanDescriptor managedBeanDescriptor = bundle.getManagedBeanByBeanClass(managedBeanInstance.getClass().getName());
            if (managedBeanDescriptor == null) {
                throw new IllegalStateException("Could not retrieve managed bean descriptor for " + managedBean + " of class " + managedBean.getClass());
            }
            InterceptorInvoker invoker = (InterceptorInvoker)managedBeanDescriptor.getSupportingInfoForBeanInstance(managedBeanInstance);
            try {
                invoker.invokePreDestroy();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Managed bean " + managedBeanDescriptor.getBeanClassName() + " PreDestroy", e);
            }
            managedBeanDescriptor.clearBeanInstanceInfo(managedBeanInstance);
        }
    }

    private BundleDescriptor getBundle() {
        JndiNameEnvironment jndiNameEnvironment = ((ComponentEnvManager)this.serviceLocator.getService(ComponentEnvManager.class, new Annotation[0])).getCurrentJndiNameEnvironment();
        BundleDescriptor bundle = null;
        if (jndiNameEnvironment instanceof BundleDescriptor) {
            bundle = (BundleDescriptor)jndiNameEnvironment;
        } else if (jndiNameEnvironment instanceof EjbDescriptor) {
            bundle = (BundleDescriptor)((EjbDescriptor)jndiNameEnvironment).getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        }
        if (bundle == null) {
            throw new IllegalStateException("Invalid context for managed bean creation");
        }
        return bundle;
    }
}

