/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class JdbcDataSource
implements DataSource {
    private final ResourceInfo resourceInfo;
    private PrintWriter logWriter;
    private int loginTimeout;

    public JdbcDataSource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        JdbcDataSource.validateResource(resourceInfo);
        this.resourceInfo = resourceInfo;
    }

    private static void validateResource(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        SimpleJndiName tmpJndiName;
        SimpleJndiName jndiName = resourceInfo.getName();
        String suffix = ConnectorsUtil.getValidSuffix((SimpleJndiName)jndiName);
        ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
        if (suffix != null && resourcesUtil.getResource(tmpJndiName = jndiName.removeSuffix(suffix), resourceInfo.getApplicationName(), resourceInfo.getModuleName(), JdbcResource.class) != null) {
            return;
        }
        if (resourcesUtil.getResource(resourceInfo, JdbcResource.class) == null) {
            throw new ConnectorRuntimeException("Invalid resource: " + resourceInfo);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ConnectorRuntime.getRuntime().getConnection(this.resourceInfo, username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger(this.getClass().getName());
    }
}

