/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.factory.ManagedExecutorDefinitionData;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ManagedExecutorDefinitionConverter
extends ConcurrencyDefinitionConvertor<ManagedExecutorDefinitionData, ManagedExecutorDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ManagedExecutorDefinitionConverter.class.getName());

    ManagedExecutorDefinitionConverter() {
        super(ManagedExecutorDefinitionDescriptor.class, JavaEEResourceType.MSEDD);
    }

    @Override
    ManagedExecutorDefinitionDescriptor createDescriptor(ManagedExecutorDefinitionData data) {
        return new ManagedExecutorDefinitionDescriptor(data, MetadataSource.ANNOTATION);
    }

    @Override
    ManagedExecutorDefinitionData getData(ManagedExecutorDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ManagedExecutorDefinitionData> convert(ManagedExecutorDefinition[] annotation) {
        LOG.log(System.Logger.Level.TRACE, "convert(annotation={0})", new Object[]{annotation});
        if (annotation == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(annotation).map(this::convert).collect(Collectors.toSet());
    }

    ManagedExecutorDefinitionData convert(ManagedExecutorDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(annotation={0})", annotation);
        ManagedExecutorDefinitionData data = new ManagedExecutorDefinitionData();
        data.setName(TranslatedConfigView.expandValue((String)annotation.name()));
        data.setContext(TranslatedConfigView.expandValue((String)annotation.context()));
        if (annotation.hungTaskThreshold() < 0L) {
            data.setHungAfterSeconds(0L);
        } else {
            data.setHungAfterSeconds(annotation.hungTaskThreshold());
        }
        if (annotation.maxAsync() < 0) {
            data.setMaximumPoolSize(Integer.MAX_VALUE);
        } else {
            data.setMaximumPoolSize(annotation.maxAsync());
        }
        return data;
    }

    @Override
    void merge(ManagedExecutorDefinitionData annotationData, ManagedExecutorDefinitionData descriptorData) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotationData={0}, descriptorData={1})", annotationData, descriptorData);
        if (!annotationData.getName().equals(descriptorData.getName())) {
            throw new IllegalArgumentException("Cannot merge managed executors with different names: " + annotationData.getName() + " x " + descriptorData.getName());
        }
        if (descriptorData.getHungAfterSeconds() <= 0L && annotationData.getHungAfterSeconds() != 0L) {
            descriptorData.setHungAfterSeconds(annotationData.getHungAfterSeconds());
        }
        if (descriptorData.getMaximumPoolSize() <= 0 && annotationData.getMaximumPoolSize() > 0 && annotationData.getMaximumPoolSize() < Integer.MAX_VALUE) {
            descriptorData.setMaximumPoolSize(annotationData.getMaximumPoolSize());
        }
        if (descriptorData.getContext() == null && annotationData.getContext() != null && !annotationData.getContext().isBlank()) {
            descriptorData.setContext(TranslatedConfigView.expandValue((String)annotationData.getContext()));
        }
    }
}

