/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.exousia.constraints.SecurityConstraint;
import org.glassfish.exousia.constraints.WebResourceCollection;
import org.glassfish.exousia.mapping.SecurityRoleRef;

public class GlassFishToExousiaConverter {
    public static List<SecurityConstraint> getConstraintsFromBundle(WebBundleDescriptor webBundleDescriptor) {
        return webBundleDescriptor.getSecurityConstraints().stream().map(GlassFishToExousiaConverter::toExousia).collect(Collectors.toList());
    }

    private static SecurityConstraint toExousia(com.sun.enterprise.deployment.web.SecurityConstraint gfConstraint) {
        List resources = gfConstraint.getWebResourceCollections().stream().map(GlassFishToExousiaConverter::toWebResourceCollection).collect(Collectors.toList());
        ServletSecurity.TransportGuarantee transportGuarantee = "confidential".equalsIgnoreCase(GlassFishToExousiaConverter.transportGuarantee(gfConstraint)) ? ServletSecurity.TransportGuarantee.CONFIDENTIAL : ServletSecurity.TransportGuarantee.NONE;
        return new SecurityConstraint(resources, GlassFishToExousiaConverter.securityRoles(gfConstraint), transportGuarantee);
    }

    private static WebResourceCollection toWebResourceCollection(com.sun.enterprise.deployment.web.WebResourceCollection gfCollection) {
        WebResourceCollection resourceCollection = new WebResourceCollection(gfCollection.getUrlPatterns(), gfCollection.getHttpMethods(), gfCollection.getHttpMethodOmissions());
        return resourceCollection;
    }

    static Set<String> securityRoles(com.sun.enterprise.deployment.web.SecurityConstraint gfSecurityConstraint) {
        if (gfSecurityConstraint.getAuthorizationConstraint() == null) {
            return null;
        }
        return Collections.list(gfSecurityConstraint.getAuthorizationConstraint().getSecurityRoles()).stream().map(role -> role.getName()).collect(Collectors.toSet());
    }

    static String transportGuarantee(com.sun.enterprise.deployment.web.SecurityConstraint gfSecurityConstraint) {
        if (gfSecurityConstraint.getUserDataConstraint() == null) {
            return null;
        }
        return gfSecurityConstraint.getUserDataConstraint().getTransportGuarantee();
    }

    public static Map<String, List<SecurityRoleRef>> getSecurityRoleRefsFromBundle(WebBundleDescriptor webBundleDescriptor) {
        HashMap<String, List<SecurityRoleRef>> exousiaRoleRefsPerServlet = new HashMap<String, List<SecurityRoleRef>>();
        for (WebComponentDescriptor webComponent : webBundleDescriptor.getWebComponentDescriptors()) {
            ArrayList<SecurityRoleRef> exousiaSecurityRoleRefs = new ArrayList<SecurityRoleRef>();
            for (SecurityRoleReference glassFishSecurityRoleRef : webComponent.getSecurityRoleReferenceSet()) {
                SecurityRoleRef roleRef = new SecurityRoleRef(glassFishSecurityRoleRef.getRoleName(), glassFishSecurityRoleRef.getSecurityRoleLink().getName());
                exousiaSecurityRoleRefs.add(roleRef);
            }
            exousiaRoleRefsPerServlet.put(webComponent.getCanonicalName(), exousiaSecurityRoleRefs);
        }
        return exousiaRoleRefsPerServlet;
    }
}

