/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class ProcessManager {
    private static final System.Logger LOG = System.getLogger(ProcessManager.class.getName());
    private String[] cmdline;
    private String[] env;
    private final StringBuffer sb_out;
    private final StringBuffer sb_err;
    private int timeout;
    private boolean echo = true;
    private String[] stdinLines;
    private final List<Thread> threads = new ArrayList<Thread>(2);
    private boolean waitForReaderThreads = true;

    public ProcessManager(String ... cmds) {
        this.cmdline = cmds;
        this.sb_out = new StringBuffer();
        this.sb_err = new StringBuffer();
    }

    public ProcessManager(List<String> Cmdline) {
        this.cmdline = new String[Cmdline.size()];
        this.cmdline = Cmdline.toArray(this.cmdline);
        this.sb_out = new StringBuffer();
        this.sb_err = new StringBuffer();
    }

    public void setTimeoutMsec(int num) {
        if (num > 0) {
            this.timeout = num;
        }
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setStdinLines(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.stdinLines = new String[list.size()];
            this.stdinLines = list.toArray(this.stdinLines);
        }
    }

    public void waitForReaderThreads(boolean b) {
        this.waitForReaderThreads = b;
    }

    public void setEcho(boolean newEcho) {
        this.echo = newEcho;
    }

    public int execute() throws ProcessManagerException {
        Process process;
        LOG.log(System.Logger.Level.DEBUG, "Executing command:\n  command={0}  \nenv={1}", Arrays.toString(this.cmdline), this.env);
        try {
            Runtime rt = Runtime.getRuntime();
            process = rt.exec(this.cmdline, this.env);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not execute command: " + this.cmdline, e);
        }
        try {
            this.readStream("stderr", process.getErrorStream(), this.sb_err);
            this.readStream("stdout", process.getInputStream(), this.sb_out);
            this.writeStdin(process);
            this.await(process);
            try {
                int e = process.exitValue();
                return e;
            }
            catch (IllegalThreadStateException tse) {
                try {
                    throw new ProcessManagerTimeoutException("Process is still running.", tse);
                }
                catch (ProcessManagerException pme) {
                    throw pme;
                }
                catch (Exception e) {
                    throw new ProcessManagerException(e);
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            this.doWaitForReaderThreads();
        }
    }

    public String getStdout() {
        return this.sb_out.toString();
    }

    public String getStderr() {
        return this.sb_err.toString();
    }

    public String toString() {
        return Arrays.toString(this.cmdline);
    }

    private void writeStdin(Process process) throws ProcessManagerException {
        if (this.stdinLines == null || this.stdinLines.length <= 0) {
            return;
        }
        if (process == null) {
            throw new ProcessManagerException("Parameter process was null.");
        }
        try (PrintWriter pipe = new PrintWriter(new BufferedWriter(new OutputStreamWriter(process.getOutputStream())));){
            for (String stdinLine : this.stdinLines) {
                LOG.log(System.Logger.Level.DEBUG, "InputLine -->" + stdinLine + "<--");
                pipe.println(stdinLine);
                pipe.flush();
            }
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
    }

    private void readStream(String name, InputStream stream, StringBuffer sb) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Thread thread = new Thread((Runnable)new ReaderThread(reader, sb, this.echo), name);
        this.threads.add(thread);
        thread.start();
    }

    private void await(Process process) throws InterruptedException, ProcessManagerException {
        if (this.timeout <= 0) {
            this.waitForever(process);
        } else {
            this.waitAwhile(process);
        }
    }

    private void waitForever(Process process) throws InterruptedException, ProcessManagerException {
        if (process == null) {
            throw new ProcessManagerException("Parameter process was null.");
        }
        process.waitFor();
    }

    private void waitAwhile(Process process) throws InterruptedException {
        Thread processWaiter = new Thread(new TimeoutThread(process));
        processWaiter.start();
        processWaiter.join(this.timeout);
    }

    private void doWaitForReaderThreads() {
        if (this.waitForReaderThreads) {
            for (Thread t : this.threads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static class ReaderThread
    implements Runnable {
        private final BufferedReader reader;
        private final StringBuffer sb;
        private final boolean echo;

        ReaderThread(BufferedReader Reader2, StringBuffer SB, boolean echo) {
            this.reader = Reader2;
            this.sb = SB;
            this.echo = echo;
        }

        @Override
        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    this.sb.append(line).append('\n');
                    if (this.echo) {
                        System.out.println(line);
                    }
                    line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOG.log(System.Logger.Level.TRACE, "ReaderThread exiting...");
        }
    }

    static class TimeoutThread
    implements Runnable {
        private final Process process;

        TimeoutThread(Process p) {
            this.process = p;
        }

        @Override
        public void run() {
            try {
                this.process.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOG.log(System.Logger.Level.TRACE, "TimeoutThread exiting...");
        }
    }
}

