/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.common.wls.SecurityRoleAssignment;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.ee.CachedPermission;
import com.sun.enterprise.security.ee.CachedPermissionImpl;
import com.sun.enterprise.security.ee.PermissionCache;
import com.sun.enterprise.security.ee.PermissionCacheFactory;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.web.integration.GlassFishToExousiaConverter;
import com.sun.enterprise.security.web.integration.LogUtils;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebUserDataPermission;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.exousia.AuthorizationService;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.common.UserPrincipal;

public class WebSecurityManager {
    private static final Logger logger = LogUtils.getLogger();
    public static final String CONSTRAINT_URI = "org.apache.catalina.CONSTRAINT_URI";
    private static final String RESOURCE = "hasResourcePermission";
    private static final String USERDATA = "hasUserDataPermission";
    private static final String EMPTY_STRING = "";
    private final String contextId;
    private String codebase;
    protected CodeSource codesource;
    private static final WebResourcePermission allResources = new WebResourcePermission("/*", (String)null);
    private static final WebUserDataPermission allConnections = new WebUserDataPermission("/*", null);
    private static Permission[] protoPerms = new Permission[]{allResources, allConnections};
    private CachedPermission allResourcesCachedPermission;
    private CachedPermission allConnectionsCachedPermission;
    private PermissionCache uncheckedPermissionCache;
    private static Set<Principal> defaultPrincipalSet = SecurityContext.getDefaultSecurityContext().getPrincipalSet();
    private final WebSecurityManagerFactory webSecurityManagerFactory;
    private final ServerContext serverContext;
    private final WebBundleDescriptor webBundleDescriptor;
    private boolean register = true;
    AuthorizationService authorizationService;

    WebSecurityManager(WebBundleDescriptor webBundleDescriptor, ServerContext serverContext, WebSecurityManagerFactory webSecurityManagerFactory, boolean register) throws PolicyContextException {
        this.register = register;
        this.webBundleDescriptor = webBundleDescriptor;
        this.contextId = WebSecurityManager.getContextID(webBundleDescriptor);
        this.serverContext = serverContext;
        this.webSecurityManagerFactory = webSecurityManagerFactory;
        String appName = webBundleDescriptor.getApplication().getRegistrationName();
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().setAppNameForContext(appName, this.contextId);
        this.initialise(appName);
        this.authorizationService = new AuthorizationService(WebSecurityManager.getContextID(webBundleDescriptor), () -> SecurityContext.getCurrent().getSubject(), null);
        this.authorizationService.setConstrainedUriRequestAttribute(CONSTRAINT_URI);
        this.authorizationService.setRequestSupplier(() -> (HttpServletRequest)webSecurityManagerFactory.pcHandlerImpl.getHandlerData().get("jakarta.servlet.http.HttpServletRequest"));
        this.authorizationService.addConstraintsToPolicy(GlassFishToExousiaConverter.getConstraintsFromBundle(webBundleDescriptor), webBundleDescriptor.getRoles().stream().map(e -> e.getName()).collect(Collectors.toSet()), webBundleDescriptor.isDenyUncoveredHttpMethods(), GlassFishToExousiaConverter.getSecurityRoleRefsFromBundle(webBundleDescriptor));
    }

    public static String getContextID(WebBundleDescriptor webBundleDescriptor) {
        return SecurityUtil.getContextID(webBundleDescriptor);
    }

    public boolean hasNoConstrainedResources() {
        boolean result = false;
        if (this.allResourcesCachedPermission != null && this.allConnectionsCachedPermission != null) {
            boolean x = this.allResourcesCachedPermission.checkPermission();
            boolean y = this.allConnectionsCachedPermission.checkPermission();
            boolean bl = result = x && y;
            if (result) {
                try {
                    AuthorizationService.setThreadContextId((String)this.contextId);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        return result;
    }

    public boolean permitAll(HttpServletRequest httpServletRequest) {
        this.setSecurityInfo(httpServletRequest);
        return this.authorizationService.checkWebResourcePermission(httpServletRequest, null);
    }

    public int hasUserDataPermission(HttpServletRequest httpServletRequest, String uri, String httpMethod) {
        this.setSecurityInfo(httpServletRequest);
        boolean isGranted = false;
        isGranted = uri == null ? this.authorizationService.checkWebUserDataPermission(httpServletRequest) : this.authorizationService.checkWebUserDataPermission(uri, httpMethod, httpServletRequest.isSecure());
        int result = 0;
        if (isGranted) {
            result = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasUserDataPermission isGranted: {0}", isGranted);
        }
        this.recordWebInvocation(httpServletRequest, USERDATA, isGranted);
        if (!isGranted && !httpServletRequest.isSecure()) {
            if (uri == null) {
                uri = WebSecurityManager.getUriMinusContextPath(httpServletRequest);
                httpMethod = httpServletRequest.getMethod();
            }
            if (isGranted = this.authorizationService.checkWebUserDataPermission(uri, httpMethod, true, defaultPrincipalSet)) {
                result = -1;
            }
        }
        return result;
    }

    public boolean hasResourcePermission(HttpServletRequest httpServletRequest) {
        this.setSecurityInfo(httpServletRequest);
        SecurityContext.setCurrent(this.getSecurityContext(httpServletRequest.getUserPrincipal()));
        boolean isGranted = this.authorizationService.checkWebResourcePermission(httpServletRequest);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasResource isGranted: {0}", isGranted);
            logger.log(Level.FINE, "[Web-Security] hasResource perm: {0}", WebSecurityManager.getUriMinusContextPath(httpServletRequest));
        }
        this.recordWebInvocation(httpServletRequest, RESOURCE, isGranted);
        return isGranted;
    }

    public boolean hasRoleRefPermission(String servletName, String role, Principal callerPrincipal) {
        boolean isGranted = this.authorizationService.checkWebRoleRefPermission(servletName, role, this.getSecurityContext(callerPrincipal).getPrincipalSet());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] hasRoleRef perm: {0}", servletName + " " + role);
            logger.log(Level.FINE, "[Web-Security] hasRoleRef isGranted: {0}", isGranted);
        }
        return isGranted;
    }

    public boolean linkPolicy(String linkedContextId, boolean lastInService) {
        return this.authorizationService.linkPolicy(linkedContextId, lastInService);
    }

    public static boolean linkPolicy(String contextId, String linkedContextId, boolean lastInService) {
        return AuthorizationService.linkPolicy((String)contextId, (String)linkedContextId, (boolean)lastInService);
    }

    public void commitPolicy() {
        this.authorizationService.commitPolicy();
    }

    public static void commitPolicy(String contextId) {
        AuthorizationService.commitPolicy((String)contextId);
    }

    public void refresh() {
        this.authorizationService.refresh();
    }

    public void deletePolicy() {
        this.authorizationService.deletePolicy();
    }

    public static void deletePolicy(String contextId) {
        AuthorizationService.deletePolicy((String)contextId);
    }

    public void release() throws PolicyContextException {
        this.authorizationService.removeStatementsFromPolicy(null);
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        this.webSecurityManagerFactory.getManager(this.contextId, true);
    }

    public void destroy() throws PolicyContextException {
        this.authorizationService.refresh();
        PermissionCacheFactory.removePermissionCache(this.uncheckedPermissionCache);
        this.uncheckedPermissionCache = null;
        SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory().removeAppNameForContext(this.contextId);
        this.webSecurityManagerFactory.getManager(this.contextId, true);
    }

    private void initialise(String appName) throws PolicyContextException {
        this.codebase = WebSecurityManager.removeSpaces(this.contextId);
        if ("__asadmin".equals(this.getVirtualServers(appName))) {
            this.handleAdminVirtualServer();
        }
        this.codesource = this.createCodeSource();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Context id (id under which  WEB component in application will be created) = {0}", this.contextId);
            logger.log(Level.FINE, "[Web-Security] Codebase (module id for web component) {0}", this.codebase);
        }
        this.initPermissionCache();
    }

    private CodeSource createCodeSource() {
        try {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[Web-Security] Creating a Codebase URI with = {0}", this.codebase);
                }
                this.codesource = new CodeSource(new URL(new URI("file:///" + this.codebase).toString()), (Certificate[])null);
                return this.codesource;
            }
            catch (URISyntaxException use) {
                logger.log(Level.FINE, "[Web-Security] Error Creating URI ", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            logger.log(Level.SEVERE, "AS-SECURITY-00001", mue);
            throw new RuntimeException(mue);
        }
    }

    private void initPermissionCache() {
        if (this.uncheckedPermissionCache == null) {
            if (this.register) {
                this.uncheckedPermissionCache = PermissionCacheFactory.createPermissionCache(this.contextId, this.codesource, protoPerms, null);
                this.allResourcesCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allResources);
                this.allConnectionsCachedPermission = new CachedPermissionImpl(this.uncheckedPermissionCache, (Permission)allConnections);
            }
        } else {
            this.uncheckedPermissionCache.reset();
        }
    }

    private void handleAdminVirtualServer() {
        SecurityRoleAssignment[] sunRoleAssignments;
        LoginConfiguration loginConfiguration = this.webBundleDescriptor.getLoginConfiguration();
        if (loginConfiguration == null) {
            return;
        }
        String realmName = loginConfiguration.getRealmName();
        SunWebApp sunDescriptor = this.webBundleDescriptor.getSunDescriptor();
        if (sunDescriptor == null) {
            return;
        }
        SecurityRoleMapping[] sunRoleMappings = sunDescriptor.getSecurityRoleMapping();
        if (sunRoleMappings != null) {
            for (SecurityRoleMapping roleMapping : sunRoleMappings) {
                for (PrincipalNameDescriptor principal : roleMapping.getPrincipalNames()) {
                    this.webSecurityManagerFactory.putAdminPrincipal(realmName, (UserPrincipal)new UserNameAndPassword(principal.getName()));
                }
                for (String group : roleMapping.getGroupNames()) {
                    this.webSecurityManagerFactory.putAdminGroup(group, realmName, new Group(group));
                }
            }
        }
        if ((sunRoleAssignments = sunDescriptor.getSecurityRoleAssignments()) != null) {
            for (SecurityRoleAssignment roleAssignment : sunRoleAssignments) {
                List principals = roleAssignment.getPrincipalNames();
                if (roleAssignment.isExternallyDefined()) {
                    this.webSecurityManagerFactory.putAdminGroup(roleAssignment.getRoleName(), realmName, new Group(roleAssignment.getRoleName()));
                    continue;
                }
                for (String principal : principals) {
                    this.webSecurityManagerFactory.putAdminPrincipal(realmName, (UserPrincipal)new UserNameAndPassword(principal));
                }
            }
        }
    }

    private void recordWebInvocation(HttpServletRequest httpsr, String type, boolean isGranted) {
        AuditManager auditManager = SecurityServicesUtil.getInstance().getAuditManager();
        if (auditManager != null && auditManager.isAuditOn() && auditManager instanceof AppServerAuditManager) {
            AppServerAuditManager appServerAuditManager = (AppServerAuditManager)auditManager;
            Principal prin = httpsr.getUserPrincipal();
            String user = prin != null ? prin.getName() : null;
            appServerAuditManager.webInvocation(user, httpsr, type, isGranted);
        }
    }

    private SecurityContext getSecurityContext(Principal principal) {
        SecurityContext securityContext = null;
        if (principal != null) {
            if (principal instanceof WebPrincipal) {
                WebPrincipal webPrincipal = (WebPrincipal)((Object)principal);
                securityContext = webPrincipal.getSecurityContext();
            } else {
                securityContext = new SecurityContext(principal.getName(), null);
            }
        }
        if (securityContext == null) {
            securityContext = SecurityContext.getDefaultSecurityContext();
        }
        return securityContext;
    }

    private void setSecurityInfo(HttpServletRequest httpRequest) {
        if (httpRequest != null) {
            this.webSecurityManagerFactory.pcHandlerImpl.getHandlerData().setHttpServletRequest(httpRequest);
        }
        AuthorizationService.setThreadContextId((String)this.contextId);
    }

    private String getVirtualServers(String applicationName) {
        Server server = this.serverContext.getDefaultServices().getService(Server.class, new Annotation[0]);
        for (ApplicationRef appplicationRef : server.getApplicationRef()) {
            if (!appplicationRef.getRef().equals(applicationName)) continue;
            return appplicationRef.getVirtualServers();
        }
        return null;
    }

    private static String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        int contextLength;
        String uri = request.getRequestURI();
        if (uri == null) {
            return EMPTY_STRING;
        }
        String contextPath = request.getContextPath();
        int n = contextLength = contextPath == null ? 0 : contextPath.length();
        if (contextLength > 0) {
            uri = uri.substring(contextLength);
        }
        if (uri.equals("/")) {
            return EMPTY_STRING;
        }
        return uri.replaceAll(":", "%3A");
    }
}

