/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.api.monitoring.MonitoringItem;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface MonitoringService
extends ConfigExtension,
PropertyBag {
    @Element
    @NotNull
    public ModuleMonitoringLevels getModuleMonitoringLevels();

    public void setModuleMonitoringLevels(ModuleMonitoringLevels var1) throws PropertyVetoException;

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMbeanEnabled();

    public void setMbeanEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getMonitoringEnabled();

    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDtraceEnabled();

    public void setDtraceEnabled(String var1) throws PropertyVetoException;

    @Element
    public List<ContainerMonitoring> getContainerMonitoring();

    @Element(value="*")
    public List<MonitoringItem> getMonitoringItems();

    default public ContainerMonitoring getContainerMonitoring(String name) {
        for (ContainerMonitoring monitoring : this.getContainerMonitoring()) {
            if (!monitoring.getName().equals(name)) continue;
            return monitoring;
        }
        return null;
    }

    default public String getMonitoringLevel(String moduleName) {
        String level = null;
        Util.populateGetMethods();
        String name = moduleName.replaceAll("-", "");
        for (String methodName : Util.getMethods) {
            if (!name.equalsIgnoreCase(methodName.substring(3))) continue;
            try {
                Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, null);
                level = (String)mthd.invoke((Object)this.getModuleMonitoringLevels(), (Object[])null);
            }
            catch (NoSuchMethodException nsme) {
                Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
            }
            catch (IllegalAccessException ile) {
                Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
            }
            catch (InvocationTargetException ite) {
                Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
            }
            break;
        }
        if (level != null) {
            return level;
        }
        for (ContainerMonitoring cm : this.getContainerMonitoring()) {
            if (!cm.getName().equals(moduleName)) continue;
            return cm.getLevel();
        }
        return null;
    }

    default public boolean setMonitoringLevel(String moduleName, String level) throws TransactionFailure, PropertyVetoException {
        boolean isLevelUpdated = false;
        Util.populateSetMethods();
        String name = moduleName.replaceAll("-", "");
        for (String methodName : Util.setMethods) {
            if (!name.equalsIgnoreCase(methodName.substring(3))) continue;
            try {
                Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, String.class);
                Transaction tx = Transaction.getTransaction((ConfigBeanProxy)this);
                if (tx == null) {
                    throw new TransactionFailure(Util.localStrings.getLocalString("noTransaction", "Internal Error - Cannot obtain transaction object"));
                }
                ModuleMonitoringLevels mml = (ModuleMonitoringLevels)tx.enroll((ConfigBeanProxy)this.getModuleMonitoringLevels());
                mthd.invoke((Object)mml, level);
                isLevelUpdated = true;
            }
            catch (NoSuchMethodException nsme) {
                Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
            }
            catch (IllegalAccessException ile) {
                Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
            }
            catch (InvocationTargetException ite) {
                Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
            }
            break;
        }
        if (!isLevelUpdated) {
            for (ContainerMonitoring cm : this.getContainerMonitoring()) {
                if (!cm.getName().equals(name)) continue;
                cm.setLevel(level);
                isLevelUpdated = true;
            }
        }
        return isLevelUpdated;
    }

    default public boolean isAnyModuleOn() {
        boolean rv = false;
        Util.populateGetMethods();
        ModuleMonitoringLevels mml = this.getModuleMonitoringLevels();
        for (String methodName : Util.getMethods) {
            try {
                Method mthd = ModuleMonitoringLevels.class.getMethod(methodName, null);
                String level = (String)mthd.invoke((Object)mml, (Object[])null);
                rv = rv || !"OFF".equals(level);
            }
            catch (NoSuchMethodException nsme) {
                Logger.getAnonymousLogger().log(Level.WARNING, nsme.getMessage(), nsme);
            }
            catch (IllegalAccessException ile) {
                Logger.getAnonymousLogger().log(Level.WARNING, ile.getMessage(), ile);
            }
            catch (InvocationTargetException ite) {
                Logger.getAnonymousLogger().log(Level.WARNING, ite.getMessage(), ite);
            }
        }
        for (ContainerMonitoring cm : this.getContainerMonitoring()) {
            rv = rv || !"OFF".equals(cm.getLevel());
        }
        return rv;
    }

    public static class Util {
        private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringService.class);
        private static final List<String> getMethods = new ArrayList<String>();
        private static final List<String> setMethods = new ArrayList<String>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void populateGetMethods() {
            List<String> list = getMethods;
            synchronized (list) {
                if (getMethods.isEmpty()) {
                    for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                        String str = method.getName();
                        if (!str.startsWith("get") || !method.getReturnType().equals(String.class)) continue;
                        getMethods.add(str);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void populateSetMethods() {
            List<String> list = setMethods;
            synchronized (list) {
                if (setMethods.isEmpty()) {
                    for (Method method : ModuleMonitoringLevels.class.getDeclaredMethods()) {
                        String str = method.getName();
                        if (!str.startsWith("set")) continue;
                        setMethods.add(str);
                    }
                }
            }
        }
    }
}

