/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class RWLockDataStructure
implements DataStructure {
    private static final Logger LOG = LogDomains.getLogger(RWLockDataStructure.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private int maxSize;
    private final ResourceHandler handler;
    private final ArrayList<ResourceHandle> resources;
    private final ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantLock.writeLock();

    public RWLockDataStructure(String parameters, int maxSize, ResourceHandler handler, String strategyClass) {
        this.resources = new ArrayList(maxSize);
        this.handler = handler;
        this.maxSize = maxSize;
        LOG.log(Level.FINEST, "pool.datastructure.rwlockds.init");
    }

    @Override
    public int addResource(ResourceAllocator allocator, int count) throws PoolingException {
        int numResAdded = 0;
        this.writeLock.lock();
        try {
            for (int i = 0; i < count && this.resources.size() < this.maxSize; ++i) {
                ResourceHandle handle = this.handler.createResource(allocator);
                this.resources.add(handle);
                ++numResAdded;
            }
        }
        catch (Exception e) {
            PoolingException pe = new PoolingException(e.getMessage());
            pe.initCause((Throwable)e);
            throw pe;
        }
        finally {
            this.writeLock.unlock();
        }
        return numResAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceHandle getResource() {
        this.readLock.lock();
        try {
            for (int i = 0; i < this.resources.size(); ++i) {
                ResourceHandle h = this.resources.get(i);
                if (h.isBusy()) continue;
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (!h.isBusy()) {
                        h.setBusy(true);
                        ResourceHandle resourceHandle = h;
                        return resourceHandle;
                    }
                    this.readLock.lock();
                    continue;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        finally {
            try {
                this.readLock.unlock();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public void removeResource(ResourceHandle resource) {
        boolean removed = false;
        this.writeLock.lock();
        try {
            removed = this.resources.remove(resource);
        }
        finally {
            this.writeLock.unlock();
        }
        if (removed) {
            this.handler.deleteResource(resource);
        }
    }

    @Override
    public void returnResource(ResourceHandle resource) {
        this.writeLock.lock();
        try {
            resource.setBusy(false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFreeListSize() {
        int free = 0;
        this.readLock.lock();
        try {
            for (ResourceHandle rh : this.resources) {
                if (rh.isBusy()) continue;
                ++free;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return free;
    }

    @Override
    public void removeAll() {
        this.writeLock.lock();
        try {
            Iterator<ResourceHandle> it = this.resources.iterator();
            while (it.hasNext()) {
                this.handler.deleteResource(it.next());
                it.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.resources.clear();
    }

    @Override
    public int getResourcesSize() {
        return this.resources.size();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public ArrayList<ResourceHandle> getAllResources() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

