/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.LocalTxConnectionEventListener;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.transaction.SystemException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ConnectorXAResource
implements XAResource {
    static Logger _logger = LogDomains.getLogger(ConnectorXAResource.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private Object userHandle = null;
    private ResourceSpec spec;
    private ClientSecurityInfo info;
    private ResourceHandle localHandle_;
    private JavaEETransaction associatedTransaction;

    public ConnectorXAResource(ResourceHandle handle, ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo info) {
        this.spec = resourceSpec;
        this.info = info;
        this.localHandle_ = handle;
    }

    public void setUserHandle(Object userHandle) {
        this.userHandle = userHandle;
    }

    private void handleResourceException(Exception ex) throws XAException {
        _logger.log(Level.SEVERE, "poolmgr.system_exception", ex);
        XAException xae = new XAException(ex.toString());
        xae.errorCode = -3;
        throw xae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)this.getResourceHandle().getResource();
            managedConnection.getLocalTransaction().commit();
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
        finally {
            this.resetAssociation();
            this.resetAssociatedTransaction();
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            if (!this.localHandle_.equals(handle)) {
                ManagedConnection managedConnection = (ManagedConnection)handle.getResource();
                managedConnection.associateConnection(this.userHandle);
                LocalTxConnectionEventListener listener = (LocalTxConnectionEventListener)handle.getListener();
                _logger.log(Level.FINE, "connection_sharing_start", this.userHandle);
                listener.associateHandle(this.userHandle, this.localHandle_);
            } else {
                this.associatedTransaction = this.getCurrentTransaction();
            }
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        _logger.log(Level.FINE, "connection_sharing_end");
        try {
            LocalTxConnectionEventListener listener;
            ResourceHandle handle;
            ResourceHandle handleInTransaction = this.getResourceHandle();
            if (!this.localHandle_.equals(handleInTransaction) && (handle = (listener = (LocalTxConnectionEventListener)handleInTransaction.getListener()).removeAssociation(this.userHandle)) != null) {
                ManagedConnection associatedConnection = (ManagedConnection)handle.getResource();
                associatedConnection.associateConnection(this.userHandle);
                _logger.log(Level.FINE, "connection_sharing_reset_association", this.userHandle);
            }
        }
        catch (Exception e) {
            this.handleResourceException(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Well, forget is called for xid :" + xid);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource other) throws XAException {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ConnectorXAResource) {
            ConnectorXAResource obj = (ConnectorXAResource)other;
            return this.spec.equals(obj.spec) && this.info.equals(obj.info);
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 123456;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            ManagedConnection managedConnection = (ManagedConnection)handle.getResource();
            managedConnection.getLocalTransaction().rollback();
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
        finally {
            this.resetAssociation();
            this.resetAssociatedTransaction();
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    private ResourceHandle getResourceHandle() throws PoolingException {
        try {
            ResourceHandle resourceHandle = null;
            JavaEETransaction javaEETransaction = this.getCurrentTransaction();
            if (javaEETransaction == null) {
                resourceHandle = this.localHandle_;
            } else {
                resourceHandle = (ResourceHandle)javaEETransaction.getNonXAResource();
                if (!this.localHandle_.isShareable() && resourceHandle != this.localHandle_) {
                    throw new ResourceAllocationException("Cannot use more than one local-tx resource in unshareable scope");
                }
            }
            if (resourceHandle.getResourceState().isUnenlisted()) {
                ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
                managedConnection.getLocalTransaction().begin();
            }
            return resourceHandle;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.system_exception", ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    private JavaEETransaction getCurrentTransaction() throws SystemException {
        return (JavaEETransaction)ConnectorRuntime.getRuntime().getTransactionManager().getTransaction();
    }

    private void resetAssociation() throws XAException {
        try {
            ResourceHandle handle = this.getResourceHandle();
            LocalTxConnectionEventListener listerner = (LocalTxConnectionEventListener)handle.getListener();
            Map associatedHandles = listerner.getAssociatedHandles();
            if (associatedHandles != null) {
                Set userHandles = associatedHandles.entrySet();
                for (Map.Entry userHandleEntry : userHandles) {
                    ResourceHandle associatedHandle = (ResourceHandle)userHandleEntry.getValue();
                    ManagedConnection associatedConnection = (ManagedConnection)associatedHandle.getResource();
                    associatedConnection.associateConnection(userHandleEntry.getKey());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "connection_sharing_reset_association", userHandleEntry.getKey());
                }
                associatedHandles.clear();
            }
        }
        catch (Exception ex) {
            this.handleResourceException(ex);
        }
    }

    public JavaEETransaction getAssociatedTransaction() {
        return this.associatedTransaction;
    }

    private void resetAssociatedTransaction() {
        this.associatedTransaction = null;
    }
}

