/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfiguredBy;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="jdbc-resource")
@I18n(value="jdbc.resource.manager")
@ConfiguredBy(value=Resources.class)
public class JDBCResourceManager
implements ResourceManager {
    private static final System.Logger LOG = System.getLogger(JDBCResourceManager.class.getName());
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JDBCResourceManager.class);
    private String jndiName;
    private String description;
    private String poolName;
    private String enabled = Boolean.TRUE.toString();
    private String enabledValueForTarget = Boolean.TRUE.toString();
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    public String getResourceType() {
        return "jdbc-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, Properties properties, String target) throws Exception {
        LOG.log(System.Logger.Level.DEBUG, "create(resources={0}, attributes={1}, properties={2}, target={3})", resources, attributes, properties, target);
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode configCode = resrc -> this.createResource((Resources)resrc, properties);
            ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.jdbc.resource.fail", "JDBC resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("create.jdbc.resource.success", "JDBC resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, JdbcResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        if (resources.getResourceByName(ResourcePool.class, SimpleJndiName.of((String)this.poolName)) == null) {
            String msg = localStrings.getLocalString("create.jdbc.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of jdbc connection pools.", new Object[]{this.poolName});
            return new ResourceStatus(1, msg);
        }
        return status;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get("description");
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = target == null ? (String)attributes.get("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target);
        this.enabledValueForTarget = (String)attributes.get("enabled");
    }

    private JdbcResource createResource(Resources resources, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource newResource = this.createConfigBean(resources, properties);
        resources.getResources().add(newResource);
        return newResource;
    }

    private JdbcResource createConfigBean(Resources resources, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcResource jdbcResource = (JdbcResource)resources.createChild(JdbcResource.class);
        jdbcResource.setJndiName(this.jndiName);
        if (this.description != null) {
            jdbcResource.setDescription(this.description);
        }
        jdbcResource.setPoolName(this.poolName);
        jdbcResource.setEnabled(this.enabled);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)jdbcResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                jdbcResource.getProperty().add(prop);
            }
        }
        return jdbcResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }

    public ResourceStatus delete(Resources resources, SimpleJndiName jndiName, String target) throws Exception {
        LOG.log(System.Logger.Level.DEBUG, "delete(resources={0}, jndiName={1}, target={2})", resources, jndiName, target);
        if (jndiName == null) {
            String msg = localStrings.getLocalString("jdbc.resource.noJndiName", "No JNDI name defined for JDBC resource.");
            return new ResourceStatus(1, msg);
        }
        JdbcResource jdbcResource = (JdbcResource)resources.getResourceByName(JdbcResource.class, jndiName);
        if (jdbcResource == null) {
            String msg = localStrings.getLocalString("delete.jdbc.resource.notfound", "A JDBC resource named {0} does not exist.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if ("system-all-req".equals(jdbcResource.getObjectType())) {
            String msg = localStrings.getLocalString("delete.jdbc.resource.system-all-req.object-type", "The jdbc resource [ {0} ] cannot be deleted as it is required to be configured in the system.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if (this.environment.isDas()) {
            if ("domain".equals(target)) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(jndiName).isEmpty()) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.resource-ref.exist", "jdbc-resource [ {0} ] is referenced in an instance/cluster target, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(jndiName, target)) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.no.resource-ref", "jdbc-resource [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    return new ResourceStatus(1, msg);
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(jndiName).size() > 1) {
                    String msg = localStrings.getLocalString("delete.jdbc.resource.multiple.resource-refs", "jdbc resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    return new ResourceStatus(1, msg);
                }
            }
        }
        try {
            SingleConfigCode configCode;
            if (!"domain".equals(target)) {
                this.resourceUtil.deleteResourceRef(jndiName, target);
            }
            if (ConfigSupport.apply((SingleConfigCode)(configCode = param -> param.getResources().remove(jdbcResource)), (ConfigBeanProxy)resources) == null) {
                String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("jdbc.resource.deletionFailed", "JDBC resource {0} delete failed ", new Object[]{jndiName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = localStrings.getLocalString("jdbc.resource.deleteSuccess", "JDBC resource {0} deleted successfully", new Object[]{jndiName});
        return new ResourceStatus(0, msg);
    }
}

