/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.embedded.Server;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class Util {
    private static ServiceLocator habitat = Globals.getDefaultHabitat();
    @Inject
    private ProcessEnvironment penv;
    private CallbackHandler callbackHandler;
    private Object appClientMsgSecConfigs;

    public static ServiceLocator getDefaultHabitat() {
        return habitat;
    }

    public static Util getInstance() {
        return (Util)habitat.getService(Util.class, new Annotation[0]);
    }

    public boolean isACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.penv.getProcessType().isServer();
    }

    public boolean isNotServerOrACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public Object getAppClientMsgSecConfigs() {
        return this.appClientMsgSecConfigs;
    }

    public void setAppClientMsgSecConfigs(Object appClientMsgSecConfigs) {
        this.appClientMsgSecConfigs = appClientMsgSecConfigs;
    }

    public static boolean isEmbeddedServer() {
        List servers = Server.getServerNames();
        return !servers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeConfigFileToTempDir(String fileName) throws IOException {
        File filePath = new File(fileName);
        if (filePath.exists()) {
            return filePath;
        }
        File localFile = null;
        if (filePath.getParentFile() != null && filePath.getParentFile().exists()) {
            localFile = filePath;
            if (!localFile.createNewFile()) {
                throw new IOException();
            }
        } else {
            String userHome = System.getProperty("user.home");
            String embeddedServerName = Util.getCurrentEmbeddedServerName();
            File tempDir = new File(userHome + File.separator + ".glassfish7-" + embeddedServerName + File.separator + "config");
            boolean mkDirSuccess = true;
            if (!tempDir.exists()) {
                mkDirSuccess = tempDir.mkdirs();
            }
            localFile = new File(tempDir.getAbsolutePath() + File.separator + fileName);
            if (mkDirSuccess && !localFile.exists()) {
                localFile.createNewFile();
            }
        }
        FileOutputStream oStream = null;
        InputStream iStream = null;
        try {
            oStream = new FileOutputStream(localFile);
            iStream = Util.class.getResourceAsStream("/config/" + fileName);
            while (iStream != null && iStream.available() > 0) {
                oStream.write(iStream.read());
            }
        }
        finally {
            if (oStream != null) {
                oStream.close();
            }
            if (iStream != null) {
                iStream.close();
            }
        }
        return localFile;
    }

    public static String getCurrentEmbeddedServerName() {
        List embeddedServerNames = Server.getServerNames();
        String embeddedServerName = embeddedServerNames.get(0) == null ? "embedded" : (String)embeddedServerNames.get(0);
        return embeddedServerName;
    }
}

