/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.SecurityContextProxy;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.UserNameAndPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SecurityContext
extends AbstractSecurityContext {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static InheritableThreadLocal<SecurityContext> currentSecCtx = new InheritableThreadLocal();
    private static SecurityContext defaultSecurityContext = SecurityContext.generateDefaultSecurityContext();
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    private boolean serverGeneratedSecurityContext;
    private Principal sessionPrincipal;

    public SecurityContext(String userName, Subject subject) {
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        this.initiator = new UserNameAndPassword(userName);
        Subject sub = s;
        PrivilegedAction<Subject> action = () -> {
            sub.getPrincipals().add(this.initiator);
            return sub;
        };
        this.subject = AppservAccessController.doPrivileged(action);
    }

    public SecurityContext(Subject subject) {
        if (subject == null) {
            subject = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        final Subject fsub = subject;
        this.subject = subject;
        this.initiator = AppservAccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Iterator<Principal> prinIter;
                Principal prin = null;
                for (Object obj : fsub.getPublicCredentials()) {
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    DistinguishedPrincipalCredential dpc = (DistinguishedPrincipalCredential)obj;
                    prin = dpc.getPrincipal();
                    break;
                }
                if (prin == null && (prinIter = fsub.getPrincipals().iterator()).hasNext()) {
                    prin = prinIter.next();
                }
                return prin;
            }
        });
        this.postConstruct();
    }

    private void initDefaultCallerPrincipal() {
        if (this.initiator == null) {
            this.initiator = SecurityContext.getDefaultCallerPrincipal();
        }
    }

    public SecurityContext(String userName, Subject subject, String realm) {
        PrincipalGroupFactory factory;
        Subject s = subject;
        if (s == null) {
            s = new Subject();
            _logger.warning("NCLS-SECURITY-05052");
        }
        if ((factory = (PrincipalGroupFactory)Globals.getDefaultHabitat().getService(PrincipalGroupFactory.class, new Annotation[0])) != null) {
            this.initiator = factory.getPrincipalInstance(userName, realm);
        }
        final Subject sub = s;
        this.subject = AppservAccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                sub.getPrincipals().add(SecurityContext.this.initiator);
                return sub;
            }
        });
    }

    public SecurityContext() {
        _logger.log(Level.FINE, "Default CTOR of SecurityContext called");
        this.subject = new Subject();
        this.initiator = null;
        this.setServerGeneratedCredentials();
        AppservAccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext.this.subject.setReadOnly();
                return null;
            }
        });
    }

    public static SecurityContext init() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static SecurityContext getDefaultSecurityContext() {
        return defaultSecurityContext;
    }

    public static Subject getDefaultSubject() {
        return SecurityContext.defaultSecurityContext.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal getDefaultCallerPrincipal() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            if (SecurityContext.defaultSecurityContext.initiator == null) {
                String guestUser = null;
                try {
                    guestUser = AppservAccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            SecurityService securityService = (SecurityService)SecurityServicesUtil.getInstance().getHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
                            if (securityService == null) {
                                return null;
                            }
                            return securityService.getDefaultPrincipal();
                        }
                    });
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "NCLS-SECURITY-05038", e);
                }
                finally {
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
                SecurityContext.defaultSecurityContext.initiator = new UserNameAndPassword(guestUser);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SecurityContext.defaultSecurityContext.initiator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityContext generateDefaultSecurityContext() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return AppservAccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

                    @Override
                    public SecurityContext run() throws Exception {
                        return new SecurityContext();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-SECURITY-05036", e);
                // ** MonitorExit[var0] (shouldn't be in output)
            }
            return null;
        }
    }

    public static void reset(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    public static SecurityContext getCurrent() {
        SecurityContext sc = (SecurityContext)currentSecCtx.get();
        if (sc == null) {
            sc = defaultSecurityContext;
        }
        return sc;
    }

    public static void setCurrent(SecurityContext sc) {
        if (sc == null || sc == defaultSecurityContext) {
            currentSecCtx.set(sc);
            return;
        }
        SecurityContext current = (SecurityContext)currentSecCtx.get();
        if (sc == current) {
            return;
        }
        boolean permitted = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                _logger.fine("permission check done to set SecurityContext");
                sm.checkPermission(doAsPrivilegedPerm);
            }
            permitted = true;
        }
        catch (SecurityException se) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-05048", se);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-05049", t);
        }
        if (permitted) {
            currentSecCtx.set(sc);
        } else {
            _logger.severe("NCLS-SECURITY-05050");
        }
    }

    public static void setUnauthenticatedContext() {
        _logger.entering(SecurityContext.class.getName(), "setCurrentSecurityContext");
        currentSecCtx.set(defaultSecurityContext);
    }

    public boolean didServerGenerateCredentials() {
        return this.serverGeneratedSecurityContext;
    }

    private void setServerGeneratedCredentials() {
        this.serverGeneratedSecurityContext = true;
    }

    @Override
    public Principal getCallerPrincipal() {
        return this == defaultSecurityContext ? SecurityContext.getDefaultCallerPrincipal() : this.initiator;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "SecurityContext[Initiator: " + this.initiator + ", Subject " + this.subject + "]";
    }

    public Principal getSessionPrincipal() {
        return this.sessionPrincipal;
    }

    public void setSessionPrincipal(Principal sessionPrincipal) {
        this.sessionPrincipal = sessionPrincipal;
    }

    public Set<Principal> getPrincipalSet() {
        return this.subject.getPrincipals();
    }

    public void postConstruct() {
        this.initDefaultCallerPrincipal();
    }

    public AppServSecurityContext newInstance(String userName, Subject subject, String realm) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "newInstance", new Object[]{userName, subject, realm});
        }
        return new SecurityContext(userName, subject, realm);
    }

    public AppServSecurityContext newInstance(String userName, Subject subject) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "newInstance", new Object[]{userName, subject});
        }
        return new SecurityContext(userName, subject);
    }

    public void setCurrentSecurityContext(AppServSecurityContext context) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(this.getClass().getName(), "setCurrentSecurityContext", context);
        }
        if (context == null) {
            SecurityContext.setCurrent(null);
            return;
        }
        if (context instanceof SecurityContext) {
            SecurityContext.setCurrent((SecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected SecurityContext, found " + context);
    }

    public AppServSecurityContext getCurrentSecurityContext() {
        return SecurityContext.getCurrent();
    }

    public void setUnauthenticatedSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public void setSecurityContextWithPrincipal(Principal principal) {
        SecurityContext ctx = this.getSecurityContextForPrincipal(principal);
        SecurityContext.setCurrent(ctx);
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal p) {
        if (p == null) {
            return null;
        }
        if (p instanceof SecurityContextProxy) {
            return ((SecurityContextProxy)((Object)p)).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject s = new Subject();
                s.getPrincipals().add(p);
                return new SecurityContext(p.getName(), s);
            }
        });
    }
}

