/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.KillNotPossibleException;
import com.sun.enterprise.universal.process.KillTimeoutException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;

public final class ProcessUtils {
    private static final System.Logger LOG = System.getLogger(ProcessUtils.class.getName());
    private static final int SOCKET_TIMEOUT = 5000;
    private static final String[] PATH = ProcessUtils.getSystemPath();

    private ProcessUtils() {
    }

    public static boolean waitWhileIsAlive(long pid, Duration timeout, boolean printDots) {
        return ProcessUtils.waitFor(() -> !ProcessUtils.isAlive(pid), timeout, printDots);
    }

    public static boolean isAlive(File pidFile) {
        Long pid = ProcessUtils.loadPid(pidFile);
        if (pid == null) {
            return false;
        }
        return ProcessUtils.isAlive(pid);
    }

    public static boolean isAlive(long pid) {
        Optional<ProcessHandle> handle = ProcessHandle.of(pid);
        return handle.isPresent() ? ProcessUtils.isAlive(handle.get()) : false;
    }

    public static boolean isAlive(ProcessHandle process) {
        if (!process.isAlive()) {
            return false;
        }
        ProcessHandle.Info info = process.info();
        if (!(!info.commandLine().isEmpty() || OS.isWindowsForSure() && info.command().isPresent())) {
            LOG.log(System.Logger.Level.TRACE, "Could not retrieve command line for the pid {0}, therefore we assume that the process stopped.", process.pid());
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static boolean waitWhileListening(HostAndPort endpoint, Duration timeout, boolean printDots) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isListening(HostAndPort endpoint) {
        boolean bl;
        Socket server = new Socket();
        try {
            server.connect(new InetSocketAddress(endpoint.getHost(), endpoint.getPort()), 5000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    server.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.TRACE, "An attempt to open a socket to " + String.valueOf(endpoint) + " resulted in exception. Therefore we assume the server has stopped.", (Throwable)ex);
                return false;
            }
        }
        server.close();
        return bl;
    }

    public static void kill(File pidFile, Duration timeout, boolean printDots) throws KillNotPossibleException, KillTimeoutException {
        LOG.log(System.Logger.Level.DEBUG, "kill(pidFile={0}, timeout={1}, printDots={2})", pidFile, timeout, printDots);
        Long pid = ProcessUtils.loadPid(pidFile);
        if (pid == null) {
            return;
        }
        if (!ProcessUtils.isAlive(pid)) {
            LOG.log(System.Logger.Level.INFO, "Process with pid {0} has already stopped.", pid);
            return;
        }
        Optional<ProcessHandle> handleOptional = ProcessHandle.of(pid);
        Optional<String> commandLine = handleOptional.get().info().commandLine();
        LOG.log(System.Logger.Level.INFO, "Killing process with pid {0} and command line {1}", pid, commandLine);
        if (!handleOptional.get().destroyForcibly()) {
            if (ProcessUtils.isAlive(pid)) {
                throw new KillNotPossibleException("It wasn't possible to destroy the process with pid=" + pid + ". Check your system permissions.");
            }
            return;
        }
        if (!ProcessUtils.waitWhileIsAlive(pid, timeout, printDots)) {
            throw new KillTimeoutException(MessageFormat.format("The process {0} was killed, but it is still alive after timeout {1} s.", pid, timeout.getSeconds()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitFor(Supplier<Boolean> sign, Duration timeout, boolean printDots) {
        boolean bl;
        Instant start;
        DotPrinter dotPrinter;
        block5: {
            boolean bl2;
            LOG.log(System.Logger.Level.DEBUG, "waitFor(sign={0}, timeout={1}, printDots={2})", sign, timeout, printDots);
            dotPrinter = DotPrinter.startWaiting(printDots);
            start = Instant.now();
            try {
                Instant deadline = start.plus(timeout);
                while (Instant.now().isBefore(deadline)) {
                    if (sign.get().booleanValue()) {
                        bl = true;
                        break block5;
                    }
                    Thread.onSpinWait();
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                DotPrinter.stopWaiting(dotPrinter);
                LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
                throw throwable;
            }
            DotPrinter.stopWaiting(dotPrinter);
            LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
            return bl2;
        }
        DotPrinter.stopWaiting(dotPrinter);
        LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
        return bl;
    }

    public static File getExe(String name) {
        for (String path : PATH) {
            File f = new File(path + "/" + name);
            if (!f.canExecute()) continue;
            return SmartFile.sanitize(f);
        }
        return null;
    }

    public static void saveCurrentPid(File pidFile) throws IOException {
        FileUtils.writeStringToFile(Long.toString(ProcessHandle.current().pid()), pidFile, StandardCharsets.ISO_8859_1);
    }

    public static Long loadPid(File pidFile) throws IllegalArgumentException {
        if (pidFile == null || !pidFile.exists()) {
            return null;
        }
        try {
            String fileContent = FileUtils.readSmallFile(pidFile, StandardCharsets.ISO_8859_1).trim();
            return fileContent.isEmpty() ? null : Long.valueOf(fileContent);
        }
        catch (IOException | NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse the PID file: " + String.valueOf(pidFile), e);
        }
    }

    private static String[] getSystemPath() {
        String tempPaths;
        if (OS.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        if (StringUtils.ok(tempPaths)) {
            return tempPaths.split(File.pathSeparator);
        }
        return new String[0];
    }

    private static class DotPrinter
    extends Thread {
        public DotPrinter() {
            super("DotPrinter");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    System.out.print(".");
                    System.out.flush();
                }
            }
            catch (InterruptedException e) {
                System.out.println();
                Thread.currentThread().interrupt();
                return;
            }
        }

        public static DotPrinter startWaiting(boolean printDots) {
            if (printDots) {
                DotPrinter dotPrinter = new DotPrinter();
                dotPrinter.start();
                return dotPrinter;
            }
            return null;
        }

        public static void stopWaiting(DotPrinter dotPrinter) {
            if (dotPrinter != null) {
                dotPrinter.interrupt();
            }
        }
    }
}

