/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.EncoderDecoderUtilsBase;
import org.glassfish.grizzly.http2.HeaderDecodingException;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.hpack.DecodingCallback;

class DecoderUtils
extends EncoderDecoderUtilsBase {
    private static final Logger LOGGER = Grizzly.logger(DecoderUtils.class);
    private static final String INVALID_CHARACTER_MESSAGE = "Invalid character 0x%02x at index '%s' found in header %s [%s: %s]";

    DecoderUtils() {
    }

    static void decodeRequestHeaders(Http2Session http2Session, final HttpRequestPacket request, final Map<String, String> capture) throws IOException, HeaderDecodingException {
        final HashSet serviceHeaders = new HashSet();
        final AtomicBoolean noMoreServiceHeaders = new AtomicBoolean();
        try {
            http2Session.getHeadersDecoder().decode(new DecodingCallback(){

                @Override
                public void onDecoded(CharSequence name, CharSequence value) {
                    if (capture != null) {
                        capture.put(name.toString(), value.toString());
                    }
                    int len = name.length();
                    for (int i = 0; i < len; ++i) {
                        if (!Character.isUpperCase(name.charAt(i))) continue;
                        throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM);
                    }
                    if (name.charAt(0) == ':') {
                        if (noMoreServiceHeaders.get()) {
                            throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM);
                        }
                        DecoderUtils.processServiceRequestHeader(request, serviceHeaders, name.toString(), value.toString());
                    } else {
                        noMoreServiceHeaders.compareAndSet(false, true);
                        DecoderUtils.processNormalHeader(request, name.toString(), value.toString());
                    }
                }
            });
            if (serviceHeaders.size() != 3) {
                throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM);
            }
        }
        catch (RuntimeException re) {
            if (re instanceof HeaderDecodingException) {
                throw re;
            }
            throw new IOException(re);
        }
        finally {
            request.setProtocol(Protocol.HTTP_2_0);
            request.getResponse().setProtocol(Protocol.HTTP_2_0);
        }
    }

    static void decodeResponseHeaders(Http2Session http2Session, final HttpResponsePacket response, final Map<String, String> capture) throws IOException {
        try {
            http2Session.getHeadersDecoder().decode(new DecodingCallback(){

                @Override
                public void onDecoded(CharSequence name, CharSequence value) {
                    if (capture != null) {
                        capture.put(name.toString(), value.toString());
                    }
                    if (name.charAt(0) == ':') {
                        DecoderUtils.processServiceResponseHeader(response, name.toString(), value.toString());
                    } else {
                        DecoderUtils.processNormalHeader(response, name.toString(), value.toString());
                    }
                }
            });
        }
        catch (RuntimeException re) {
            throw new IOException(re);
        }
        finally {
            response.setProtocol(Protocol.HTTP_2_0);
            response.getRequest().setProtocol(Protocol.HTTP_2_0);
        }
    }

    static void decodeTrailerHeaders(Http2Session http2Session, HttpHeader header, final Map<String, String> capture) throws IOException {
        try {
            final MimeHeaders headers = header.getHeaders();
            http2Session.getHeadersDecoder().decode(new DecodingCallback(){

                @Override
                public void onDecoded(CharSequence name, CharSequence value) {
                    if (capture != null) {
                        capture.put(name.toString(), value.toString());
                    }
                    headers.addValue(name.toString()).setString(value.toString());
                }
            });
        }
        catch (RuntimeException re) {
            throw new IOException(re);
        }
    }

    private static void processServiceRequestHeader(HttpRequestPacket request, Set<String> serviceHeaders, String name, String value) {
        int valueLen = value.length();
        switch (name) {
            case ":path": {
                if (!serviceHeaders.add(name)) {
                    throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Duplicate :path");
                }
                if (value.isEmpty()) {
                    throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Empty :path");
                }
                int questionIdx = value.indexOf(63);
                if (questionIdx == -1) {
                    request.getRequestURIRef().init(value);
                } else {
                    request.getRequestURIRef().init(value.substring(0, questionIdx));
                    if (questionIdx < valueLen - 1) {
                        request.getQueryStringDC().setString(value.substring(questionIdx + 1));
                    }
                }
                return;
            }
            case ":method": {
                if (!serviceHeaders.add(name)) {
                    throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Duplicate :method");
                }
                request.getMethodDC().setString(value);
                return;
            }
            case ":scheme": {
                if (!serviceHeaders.add(name)) {
                    throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Duplicate :scheme");
                }
                request.setSecure(valueLen == 5);
                return;
            }
            case ":authority": {
                request.getHeaders().setValue(Header.Host).setString(value);
                return;
            }
        }
        throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Unknown service header: " + name);
    }

    private static void processServiceResponseHeader(HttpResponsePacket response, String name, String value) {
        DecoderUtils.validateHeaderCharacters(name, value);
        int valueLen = value.length();
        switch (name) {
            case ":status": {
                if (valueLen != 3) {
                    throw new IllegalStateException("Unexpected status code: " + value);
                }
                response.setStatus(Integer.parseInt(value));
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{name, value});
    }

    private static void processNormalHeader(HttpHeader httpHeader, String name, String value) {
        if (name.equals(Header.Host.getLowerCase())) {
            return;
        }
        MimeHeaders mimeHeaders = httpHeader.getHeaders();
        DataChunk valueChunk = mimeHeaders.addValue(name);
        DecoderUtils.validateHeaderCharacters(name, value);
        valueChunk.setString(value);
        DecoderUtils.finalizeKnownHeader(httpHeader, name, value);
    }

    private static void finalizeKnownHeader(HttpHeader httpHeader, String name, String value) {
        switch (name) {
            case "content-length": {
                httpHeader.setContentLengthLong(Long.parseLong(value));
                return;
            }
            case "upgrade": {
                httpHeader.getUpgradeDC().setString(value);
                return;
            }
            case "expect": {
                ((Http2Request)httpHeader).requiresAcknowledgement(true);
            }
            case "connection": {
                throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "Invalid use of connection header.");
            }
            case "te": {
                if ("trailers".equals(value)) break;
                throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, "TE header only allowed a value of trailers.");
            }
        }
    }

    private static void validateHeaderCharacters(CharSequence name, CharSequence value) {
        assert (name != null);
        assert (value != null);
        int idx = DecoderUtils.ensureRange(name);
        if (idx != -1) {
            String msg = String.format(INVALID_CHARACTER_MESSAGE, name.charAt(idx), idx, "name", name, value);
            throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, msg);
        }
        idx = DecoderUtils.ensureRange(value);
        if (idx != -1) {
            String msg = String.format(INVALID_CHARACTER_MESSAGE, name.charAt(idx), idx, "value", name, value);
            throw new HeaderDecodingException(ErrorCode.PROTOCOL_ERROR, HeaderDecodingException.ErrorType.STREAM, msg);
        }
    }

    private static int ensureRange(CharSequence cs) {
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            char c = cs.charAt(i);
            if (c >= ' ' && c <= '\u00ff') continue;
            return i;
        }
        return -1;
    }
}

