/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cfg;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.bootstrap.Which;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public final class StartupContextUtil {
    private StartupContextUtil() {
    }

    public static File detectInstallRoot() {
        File bootstrapFile = StartupContextUtil.findBootstrapFile();
        return bootstrapFile.getParentFile().getParentFile();
    }

    private static File findBootstrapFile() {
        try {
            return Which.jarFile(StartupContextUtil.class);
        }
        catch (IOException e) {
            throw new Error("Cannot get bootstrap path from " + StartupContextUtil.class + " class location, aborting", e);
        }
    }

    public static File getInstallRoot(StartupContext context) {
        return StartupContextUtil.getInstallRoot(context.getArguments());
    }

    public static File getInstallRoot(Properties properties) {
        return StartupContextUtil.absolutize(new File(properties.getProperty("com.sun.aas.installRoot")));
    }

    public static File getInstanceRoot(StartupContext context) {
        return StartupContextUtil.getInstanceRoot(context.getArguments());
    }

    public static File getInstanceRoot(Properties properties) {
        return StartupContextUtil.absolutize(new File(properties.getProperty("com.sun.aas.instanceRoot")));
    }

    public static String[] getOriginalArguments(StartupContext context) {
        Properties args = context.getArguments();
        String s = args.getProperty("-startup-args");
        if (s == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, ",,,", false);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }

    private static File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }
}

