/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.util;

import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;

public class ResourceUtil {
    private static final String RESOURCES_XML_META_INF = "META-INF/glassfish-resources.xml";
    private static final String RESOURCES_XML_WEB_INF = "WEB-INF/glassfish-resources.xml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasResourcesXML(ReadableArchive archive, ServiceLocator locator) {
        try {
            if (!DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.earType(), (ServiceLocator)locator)) {
                if (!DeploymentUtils.isArchiveOfType((ReadableArchive)archive, (ArchiveType)DOLUtils.warType(), (ServiceLocator)locator)) return archive.exists(RESOURCES_XML_META_INF);
                return archive.exists(RESOURCES_XML_WEB_INF);
            }
            if (archive.exists(RESOURCES_XML_META_INF)) {
                return true;
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String element = (String)entries.nextElement();
                if (!element.endsWith(".jar") && !element.endsWith(".war") && !element.endsWith(".rar") && !element.endsWith("_jar") && !element.endsWith("_war") && !element.endsWith("_rar")) continue;
                ReadableArchive subArchive = archive.getSubArchive(element);
                try {
                    boolean answer = subArchive != null && ResourceUtil.hasResourcesXML(subArchive, locator);
                    if (!answer) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (subArchive == null) continue;
                    subArchive.close();
                }
            }
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

