/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.AbstractDataSource;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionDefinition;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAllocationException;
import jakarta.resource.spi.security.PasswordCredential;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.sql.DataSource;

@ConnectionDefinition(connectionFactory=DataSource.class, connectionFactoryImpl=AbstractDataSource.class, connection=Connection.class, connectionImpl=ConnectionHolder.class)
public class DSManagedConnectionFactory
extends ManagedConnectionFactoryImpl {
    private static Logger _logger = LogDomains.getLogger(DSManagedConnectionFactory.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private transient DataSource dataSourceObj;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.logFine("In createManagedConnection");
        PasswordCredential passwordCredential = SecurityUtils.getPasswordCredential(this, subject, connectionRequestInfo);
        DataSource dataSource = this.getDataSource();
        Connection connection = null;
        ManagedConnectionImpl managedConnectionImpl = null;
        try {
            connection = this.isEqual(passwordCredential, this.getUser(), this.getPassword()) ? dataSource.getConnection() : dataSource.getConnection(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
        }
        catch (SQLException sqle) {
            _logger.log(Level.FINE, "jdbc.exc_create_conn", sqle.getMessage());
            throw new ResourceAllocationException(StringManager.getManager(DataSourceObjectBuilder.class).getString("jdbc.cannot_allocate_connection", (Object)sqle.getMessage()), (Throwable)sqle);
        }
        try {
            managedConnectionImpl = this.constructManagedConnection(null, connection, passwordCredential, this);
            this.validateAndSetIsolation(managedConnectionImpl);
        }
        finally {
            if (managedConnectionImpl == null && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    _logger.log(Level.FINEST, "Exception while closing connection : createManagedConnection" + connection);
                }
            }
        }
        return managedConnectionImpl;
    }

    @Override
    public DataSource getDataSource() throws ResourceException {
        if (this.dataSourceObj == null) {
            try {
                this.dataSourceObj = (DataSource)super.getDataSource();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        return this.dataSourceObj;
    }

    @Override
    public boolean equals(Object other) {
        this.logFine("In equals");
        if (other instanceof DSManagedConnectionFactory) {
            DSManagedConnectionFactory otherMCF = (DSManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 217 + this.spec.hashCode();
    }
}

