/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.loader.JasperAdapter;
import com.sun.enterprise.loader.ResourceLocator;
import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.security.integration.PermsHolder;
import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.hk2.api.PreDestroy;

public class ASURLClassLoader
extends GlassfishUrlClassLoader
implements JasperAdapter,
InstrumentableClassLoader,
PreDestroy,
DDPermissionsLoader {
    private static final Logger _logger = CULoggerInfo.getLogger();
    private final Set<URLEntry> urlSet = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<String, String> notFoundResources = new ConcurrentHashMap<String, String>();
    private final Map<String, String> notFoundClasses = new ConcurrentHashMap<String, String>();
    private volatile boolean doneCalled;
    private volatile String doneSnapshot;
    private final ArrayList<ClassFileTransformer> transformers = new ArrayList(1);
    private static final StringManager sm = StringManager.getManager(ASURLClassLoader.class);
    private final PermsHolder permissionsHolder = new PermsHolder();

    public ASURLClassLoader() {
        super(new URL[0]);
        _logger.log(Level.FINE, "ClassLoader: {0} is getting created.", this);
    }

    public ASURLClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public boolean isClosed() {
        return this.doneCalled;
    }

    public void preDestroy() {
        try {
            this.close();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "Could not close the classloader " + this, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.doneCalled) {
            return;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            if (this.doneCalled) {
                return;
            }
            this.doneSnapshot = "ASURLClassLoader.done() called ON " + this + "\n AT " + Instant.now() + " \n BY :" + Arrays.toString(Thread.currentThread().getStackTrace());
            this.doneCalled = true;
            for (URLEntry u : this.urlSet) {
                if (u.zip != null) {
                    try {
                        u.zip.reallyClose();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.INFO, CULoggerInfo.getString("NCLS-COMUTIL-00010", u.source), ioe);
                    }
                }
                if (u.table != null) {
                    u.table.clear();
                    u.table = null;
                }
                Object var3_3 = null;
            }
            this.urlSet.clear();
            this.notFoundResources.clear();
            this.notFoundClasses.clear();
        }
        super.close();
    }

    public void appendURL(File file) throws IOException {
        try {
            this.appendURL(file.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00011", file.toURI()), mue);
            throw new IOException(mue);
        }
    }

    @Override
    public void addURL(URL url) {
        this.appendURL(url);
    }

    public synchronized void appendURL(URL url) {
        try {
            if (url == null) {
                _logger.log(Level.INFO, "NCLS-COMUTIL-00012");
                return;
            }
            URLEntry entry = new URLEntry(url);
            if (!this.urlSet.contains(entry)) {
                this.urlSet.add(entry);
                if (entry.isJar) {
                    this.checkManifest(entry.zip, entry.file);
                }
            } else {
                _logger.log(Level.FINE, "[ASURLClassLoader] Ignoring duplicate URL: {0}", url);
                if (entry.zip != null) {
                    try {
                        entry.zip.reallyClose();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.INFO, CULoggerInfo.getString("NCLS-COMUTIL-00013", url), ioe);
                    }
                }
            }
            this.clearNotFoundCaches();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00011", url), ioe);
        }
    }

    @Override
    public synchronized URL[] getURLs() {
        return (URL[])this.urlSet.stream().map(urlEntry -> urlEntry.source).toArray(URL[]::new);
    }

    public String getClasspath() {
        StringBuilder strBuf = null;
        URL[] urls = this.getURLs();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                if (strBuf == null) {
                    strBuf = new StringBuilder();
                }
                if (i > 0) {
                    strBuf.append(File.pathSeparator);
                }
                strBuf.append(urls[i].getFile());
            }
        }
        return strBuf == null ? null : strBuf.toString();
    }

    public synchronized void refresh() throws IOException {
        this.clearNotFoundCaches();
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public ClassLoader copy() {
        ASURLClassLoader copyFrom = this;
        PrivilegedAction<DelegatingClassLoader> privilegedAction = () -> new DelegatingClassLoader(copyFrom);
        return AccessController.doPrivileged(privilegedAction);
    }

    private void clearNotFoundCaches() {
        this.notFoundResources.clear();
        this.notFoundClasses.clear();
    }

    private URL findResource0(URLEntry res, String name) {
        PrivilegedAction<URL> action = () -> {
            if (res.isJar) {
                try {
                    JarEntry jarEntry = res.zip.getJarEntry(name);
                    if (jarEntry == null) {
                        return null;
                    }
                    InternalURLStreamHandler handler = new InternalURLStreamHandler(res, name);
                    URL ret = new URL("jar", null, -1, res.source + "!/" + name, handler);
                    handler.tieUrl(ret);
                    return ret;
                }
                catch (Throwable thr) {
                    _logger.log(Level.INFO, "NCLS-COMUTIL-00014", thr);
                }
            } else {
                try {
                    File resourceFile = new File(res.file, name);
                    if (resourceFile.exists()) {
                        return resourceFile.toURI().toURL();
                    }
                }
                catch (IOException e) {
                    _logger.log(Level.INFO, "NCLS-COMUTIL-00014", e);
                }
            }
            return null;
        };
        return AccessController.doPrivileged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, CULoggerInfo.getString("NCLS-COMUTIL-00015", name, this), new Throwable());
            return null;
        }
        String nf = this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return null;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            for (URLEntry u : this.urlSet) {
                URL url;
                if (!u.hasItem(name) || (url = this.findResource0(u, name)) == null) continue;
                return url;
            }
        }
        this.notFoundResources.put(name, name);
        return null;
    }

    @Override
    public synchronized Enumeration<URL> findResources(String name) throws IOException {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, "NCLS-COMUTIL-00016", new Object[]{name, this.doneSnapshot});
            return Collections.emptyEnumeration();
        }
        ArrayList<URL> resourcesList = new ArrayList<URL>();
        String nf = this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return Collections.emptyEnumeration();
        }
        for (URLEntry urlEntry : this.urlSet) {
            URL url = this.findResource0(urlEntry, name);
            if (url == null) continue;
            resourcesList.add(url);
        }
        if (resourcesList.isEmpty()) {
            this.notFoundResources.put(name, name);
        }
        return Collections.enumeration(resourcesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jar, File file) throws IOException {
        if (jar == null || file == null) {
            return;
        }
        Manifest man = jar.getManifest();
        if (man == null) {
            return;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    this.appendURL(newFile);
                }
                catch (MalformedURLException ex) {
                    _logger.log(Level.SEVERE, "NCLS-COMUTIL-00014", ex);
                }
            }
        }
    }

    private byte[] loadClassData0(URLEntry res, String entryName) {
        PrivilegedAction<byte[]> action = () -> {
            InputStream classStream = null;
            try {
                if (res.isJar) {
                    ProtectedJarFile zip = res.zip;
                    JarEntry entry = zip.getJarEntry(entryName);
                    if (entry == null) return null;
                    classStream = zip.getInputStream(entry);
                    byte[] classData1 = this.getClassData(classStream);
                    res.setProtectionDomain(this, entry.getCertificates());
                    return classData1;
                }
                File classFile = new File(res.file, entryName.replace('/', File.separatorChar));
                if (!classFile.exists()) return null;
                try {
                    classStream = new FileInputStream(classFile);
                    byte[] classData2 = this.getClassData(classStream);
                    res.setProtectionDomain(this, null);
                    byte[] byArray = classData2;
                    return byArray;
                }
                finally {
                    if (classStream != null) {
                        try {
                            classStream.close();
                        }
                        catch (IOException closeIOE) {
                            _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", closeIOE);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                _logger.log(Level.INFO, "NCLS-COMUTIL-00014", ioe);
            }
            return null;
        };
        return AccessController.doPrivileged(action);
    }

    @Override
    public void addEEPermissions(PermissionCollection eePc) throws SecurityException {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setEEPermissions(eePc);
        }
    }

    @Override
    public void addDeclaredPermissions(PermissionCollection declaredPc) throws SecurityException {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setDeclaredPermissions(declaredPc);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection cachedPc = this.permissionsHolder.getCachedPerms(codeSource);
        if (cachedPc != null) {
            return cachedPc;
        }
        return this.permissionsHolder.getPermissions(codeSource, super.getPermissions(codeSource));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String packageName;
        int lastPackageSep;
        ClassData classData = this.findClassData(name);
        if (PreprocessorUtil.isPreprocessorEnabled()) {
            String entryName = name.replace('.', '/') + ".class";
            classData.setClassBytes(PreprocessorUtil.processClass(entryName, classData.getClassBytes()));
        }
        if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getDefinedPackage(packageName = name.substring(0, lastPackageSep)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iae) {
                _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
            }
        }
        try {
            ArrayList xformers = (ArrayList)this.transformers.clone();
            if (!xformers.isEmpty()) {
                for (ClassFileTransformer transformer : xformers) {
                    String internalClassName;
                    byte[] transformedBytes = transformer.transform(this, internalClassName = name.replace('.', '/'), null, classData.pd, classData.getClassBytes());
                    if (transformedBytes == null) continue;
                    _logger.log(Level.FINE, "NCLS-COMUTIL-00017", name);
                    classData.setClassBytes(transformedBytes);
                }
            }
        }
        catch (IllegalClassFormatException icfEx) {
            throw new ClassNotFoundException(icfEx.toString(), icfEx);
        }
        try {
            byte[] bytes = classData.getClassBytes();
            return this.defineClass(name, bytes, 0, bytes.length, classData.pd);
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
        }
    }

    private synchronized ClassData findClassData(String name) throws ClassNotFoundException {
        if (this.doneCalled) {
            ClassNotFoundException exception = new ClassNotFoundException(name);
            _logger.log(Level.WARNING, CULoggerInfo.getString("NCLS-COMUTIL-00018", name, this), exception);
            throw exception;
        }
        String nf = this.notFoundClasses.get(name);
        if (nf != null && nf.equals(name)) {
            throw new ClassNotFoundException(name);
        }
        String entryName = name.replace('.', '/') + ".class";
        for (URLEntry u : this.urlSet) {
            byte[] result;
            if (!u.hasItem(entryName) || (result = this.loadClassData0(u, entryName)) == null) continue;
            if (System.getSecurityManager() == null) {
                return new ClassData(result, u.pd);
            }
            CodeSource cs = u.pd.getCodeSource();
            PermissionCollection pc = this.getPermissions(cs);
            ProtectionDomain pdWithPemissions = new ProtectionDomain(u.pd.getCodeSource(), pc, u.pd.getClassLoader(), u.pd.getPrincipals());
            return new ClassData(result, pdWithPemissions);
        }
        this.notFoundClasses.put(name, name);
        throw new ClassNotFoundException(name);
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[4096];
        try (BufferedInputStream bstream = new BufferedInputStream(istream);){
            byte[] byArray;
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                int num;
                while ((num = bstream.read(buf)) != -1) {
                    bout.write(buf, 0, num);
                }
                byArray = bout.toByteArray();
            }
            return byArray;
        }
    }

    protected String getClassLoaderName() {
        return "ASURLClassLoader";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClassLoaderName()).append(" :\n");
        if (this.doneCalled) {
            buffer.append("doneCalled = true").append('\n');
            buffer.append("doneSnapshot = ").append(this.doneSnapshot);
        } else {
            buffer.append("urlSet = ").append(this.urlSet).append('\n');
            buffer.append("doneCalled = false").append('\n');
        }
        buffer.append(" Parent -> ").append(this.getParent()).append('\n');
        return buffer.toString();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ResourceLocator locator = new ResourceLocator(this, this.getParentClassLoader(), true);
        return locator.getResources(name);
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader parent = this.getParent();
        if (parent == null) {
            return ASURLClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    protected static final class URLEntry {
        final URL source;
        volatile File file = null;
        volatile ProtectedJarFile zip = null;
        volatile boolean isJar = false;
        volatile HashMap<String, String> table = null;
        volatile ProtectionDomain pd = null;

        public URLEntry(URL url) throws IOException {
            this.source = url;
            this.init();
        }

        private void init() throws IOException {
            try {
                this.file = new File(this.source.toURI());
            }
            catch (URISyntaxException use) {
                throw new IOException(use);
            }
            this.isJar = this.file.isFile();
            if (this.isJar) {
                this.zip = new ProtectedJarFile(this.file);
            }
            this.table = new HashMap();
        }

        private void fillTable(File f, HashMap<String, String> t, String parent) throws IOException {
            File[] children;
            Object localName = parent.isEmpty() ? "" : parent + "/";
            for (File child : children = f.listFiles()) {
                this.processFile(child, t, (String)localName);
            }
        }

        private void processFile(File fileToProcess, HashMap<String, String> t, String parentLocalName) throws IOException {
            String key = parentLocalName + fileToProcess.getName();
            if (fileToProcess.isFile()) {
                t.put(key, key);
            } else if (fileToProcess.isDirectory()) {
                this.fillTable(fileToProcess, t, key);
            }
        }

        private boolean hasItem(String item) {
            File targetFile;
            boolean result;
            if (this.table.isEmpty()) {
                return true;
            }
            String target = item;
            if (item.startsWith("./")) {
                target = item.substring(2);
            }
            if (!(result = this.table.containsKey(target)) && !this.isJar && (targetFile = this.privilegedCheckForFile(target)) != null) {
                try {
                    this.processFile(targetFile, this.table, "");
                    result = true;
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00020", target, this.file.getAbsolutePath()), ioe);
                    return false;
                }
            }
            return result;
        }

        private File privilegedCheckForFile(String targetPath) {
            try {
                PrivilegedExceptionAction<File> action = () -> {
                    File targetFile = new File(this.file, targetPath);
                    if (!targetFile.exists()) {
                        targetFile = null;
                    }
                    return targetFile;
                };
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException pae) {
                _logger.log(Level.SEVERE, CULoggerInfo.getString("NCLS-COMUTIL-00021", targetPath, this.file.getAbsolutePath()), pae.getCause());
                return null;
            }
        }

        public void setProtectionDomain(ClassLoader ejbClassLoader, Certificate[] signers) throws MalformedURLException {
            if (this.pd == null) {
                this.pd = new ProtectionDomain(new CodeSource(this.file.toURL(), signers), null, ejbClassLoader, null);
            }
        }

        public String toString() {
            return "URLEntry : " + this.source;
        }

        public boolean equals(Object obj) {
            if (obj instanceof URLEntry) {
                URLEntry e = (URLEntry)obj;
                try {
                    if (this.source.toURI().equals(e.source.toURI())) {
                        return true;
                    }
                }
                catch (URISyntaxException e1) {
                    throw new RuntimeException(e1);
                }
            }
            return false;
        }

        public int hashCode() {
            try {
                return this.source.toURI().hashCode();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ProtectedJarFile
    extends JarFile {
        public ProtectedJarFile(File file) throws IOException {
            super(file, true, 1, Runtime.version());
        }

        @Override
        public void close() {
        }

        public void reallyClose() throws IOException {
            super.close();
        }

        @Deprecated(since="6.1.0", forRemoval=true)
        protected void finalize() throws IOException {
            try {
                super.finalize();
                this.reallyClose();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
    }

    private static final class ClassData {
        private byte[] classBytes;
        private final ProtectionDomain pd;

        ClassData(byte[] classBytes, ProtectionDomain pd) {
            this.classBytes = classBytes;
            this.pd = pd;
        }

        private synchronized byte[] getClassBytes() {
            return this.classBytes;
        }

        private synchronized void setClassBytes(byte[] newBytes) {
            this.classBytes = newBytes;
        }
    }

    private class InternalURLStreamHandler
    extends URLStreamHandler {
        private volatile URL mURL;
        private final URLEntry mRes;

        public InternalURLStreamHandler(URLEntry res, String name) {
            this.mRes = res;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            String path = u.getPath();
            int separator = path.lastIndexOf(33);
            assert (separator != -1);
            try {
                URI jarFileURI = new URI(path.substring(0, separator));
                if (!jarFileURI.equals(this.mRes.file.toURI())) {
                    throw new IOException("Cannot open a foreign URL; this.url=" + this.mURL + "; foreign.url=" + u);
                }
                String entryName = path.substring(separator + 1);
                assert (entryName.startsWith("/"));
                entryName = entryName.substring(1);
                return new InternalJarURLConnection(u, this.mRes, entryName);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        public void tieUrl(URL url) {
            if (this.mURL != null) {
                throw new IllegalStateException("Setting the URL more than once not allowed");
            }
            this.mURL = url;
        }
    }

    private static final class DelegatingClassLoader
    extends SecureClassLoader {
        private final ASURLClassLoader delegate;

        DelegatingClassLoader(ASURLClassLoader applicationCL) {
            super(applicationCL.getParent());
            this.delegate = applicationCL;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String packageName;
            ClassData classData = this.delegate.findClassData(name);
            int lastPackageSep = name.lastIndexOf(46);
            if (lastPackageSep != -1 && this.getDefinedPackage(packageName = name.substring(0, lastPackageSep)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException iae) {
                    _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
                }
            }
            try {
                byte[] bytes = classData.getClassBytes();
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, classData.pd);
                return clazz;
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
            }
        }

        @Override
        protected URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }
    }

    private class InternalJarURLConnection
    extends JarURLConnection {
        private final URLEntry mRes;
        private final String mName;

        public InternalJarURLConnection(URL url, URLEntry res, String name) throws MalformedURLException {
            super(url);
            this.mRes = res;
            this.mName = name;
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return this.mRes.zip;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.mName == null || this.mName.isEmpty()) {
                throw new IOException("no entry name specified");
            }
            ZipEntry entry = this.mRes.zip.getEntry(this.mName);
            if (entry == null) {
                throw new IOException("no entry called " + this.mName + " found in " + this.mRes.source);
            }
            return this.mRes.zip.getInputStream(entry);
        }
    }
}

