/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.node.BundleNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.VersionUpgrade;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.xml.DTDRegistry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

@Service
@PerLookup
public class SaxParserHandler
extends DefaultHandler {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static final MappingStuff mappingStuff = new MappingStuff();
    private final List<XMLNode<?>> nodes = new ArrayList();
    private XMLNode<?> topNode;
    protected String publicID;
    private StringBuffer elementData;
    private Map<String, String> prefixMapping;
    private boolean stopOnXMLErrors;
    private boolean pushedNamespaceContext;
    private final NamespaceSupport namespaces = new NamespaceSupport();
    private final Stack<String> elementStack = new Stack();
    private String rootElement;
    private List<VersionUpgrade> versionUpgradeList;
    private boolean doDelete;
    private String errorReportingString = "";

    protected static Map<String, String> getMapping() {
        return SaxParserHandler.mappingStuff.mMapping;
    }

    protected static List<VersionUpgrade> getVersionUpgrades(String key) {
        List<VersionUpgrade> versionUpgradeList = SaxParserHandler.mappingStuff.mVersionUpgrades.get(key);
        if (versionUpgradeList != null) {
            return versionUpgradeList;
        }
        List<Class<?>> classList = SaxParserHandler.mappingStuff.mVersionUpgradeClasses.get(key);
        if (classList == null) {
            return null;
        }
        versionUpgradeList = new ArrayList<VersionUpgrade>();
        for (int n = 0; n < classList.size(); ++n) {
            VersionUpgrade versionUpgrade = null;
            try {
                versionUpgrade = (VersionUpgrade)classList.get(n).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (versionUpgrade == null) continue;
            versionUpgradeList.add(versionUpgrade);
        }
        SaxParserHandler.mappingStuff.mVersionUpgrades.put(key, versionUpgradeList);
        return versionUpgradeList;
    }

    protected static Collection<String> getElementsAllowingEmptyValues() {
        return SaxParserHandler.mappingStuff.mElementsAllowingEmptyValues;
    }

    protected static Collection<String> getElementsPreservingWhiteSpace() {
        return SaxParserHandler.mappingStuff.mElementsPreservingWhiteSpace;
    }

    public static void registerBundleNode(BundleNode bundleNode, String bundleTagName) {
        if (SaxParserHandler.mappingStuff.mBundleRegistrationStatus.containsKey(bundleTagName)) {
            LOG.log(Level.FINEST, "Mapping already contains entry for tag {0}, returning.", bundleTagName);
            return;
        }
        HashMap<String, String> dtdMapping = new HashMap<String, String>();
        HashMap versionUpgrades = new HashMap();
        String rootNodeKey = bundleNode.registerBundle(dtdMapping);
        SaxParserHandler.mappingStuff.mRootNodesMutable.putIfAbsent(rootNodeKey, bundleNode.getClass());
        SaxParserHandler.mappingStuff.mRootNodesMutable.putAll(bundleNode.registerRuntimeBundle(dtdMapping, versionUpgrades));
        SaxParserHandler.mappingStuff.mVersionUpgradeClasses.putAll(versionUpgrades);
        for (Map.Entry entry : dtdMapping.entrySet()) {
            String dtd;
            String publicID = (String)entry.getKey();
            String systemIDResolution = SaxParserHandler.resolvePublicID(publicID, dtd = (String)entry.getValue());
            if (systemIDResolution == null) {
                SaxParserHandler.mappingStuff.mMapping.put(publicID, dtd.substring(dtd.lastIndexOf(47) + 1));
                continue;
            }
            SaxParserHandler.mappingStuff.mMapping.put(publicID, systemIDResolution);
        }
        LOG.log(Level.FINER, "Final mapping keys for root node key {0}:\n {1}", new Object[]{rootNodeKey, SaxParserHandler.mappingStuff.mMapping.keySet()});
        Collection<String> c = bundleNode.elementsAllowingEmptyValue();
        if (!c.isEmpty()) {
            SaxParserHandler.mappingStuff.mElementsAllowingEmptyValuesMutable.addAll(c);
        }
        if (!(c = bundleNode.elementsPreservingWhiteSpace()).isEmpty()) {
            SaxParserHandler.mappingStuff.mElementsPreservingWhiteSpaceMutable.addAll(c);
        }
        SaxParserHandler.mappingStuff.mBundleRegistrationStatus.put(rootNodeKey, Boolean.TRUE);
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            LOG.log(Level.FINEST, "resolveEntity, publicID={0}, systemID={1}", new Object[]{publicID, systemID});
            if (publicID != null && SaxParserHandler.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                return new InputSource(new BufferedInputStream(this.getDTDUrlFor(SaxParserHandler.getMapping().get(publicID))));
            }
            if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                return null;
            }
            String namespaceResolution = SaxParserHandler.resolveSchemaNamespace(systemID);
            String fileName = namespaceResolution == null ? SaxParserHandler.getSchemaURLFor(systemID.substring(systemID.lastIndexOf(47) + 1)) : SaxParserHandler.getSchemaURLFor(namespaceResolution);
            if (fileName == null) {
                throw new SAXException("Requested schema " + systemID + " is not found in local repository, please ensure that there are no typos in the XML namespace declaration.");
            }
            LOG.log(Level.FINE, "Resolved publicID={0} and systemID={1} to {2}", new Object[]{publicID, systemID, fileName});
            return new InputSource(fileName);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception ioe) {
            throw new SAXException(ioe);
        }
    }

    public void setStopOnError(boolean stop) {
        this.stopOnXMLErrors = stop;
    }

    @Override
    public void error(SAXParseException spe) throws SAXParseException {
        LOG.log(Level.SEVERE, "AS-DEPLOYMENT-00118", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXParseException {
        LOG.log(Level.SEVERE, "AS-DEPLOYMENT-00118", new Object[]{this.errorReportingString, String.valueOf(spe.getLineNumber()), String.valueOf(spe.getColumnNumber()), spe.getLocalizedMessage()});
        if (this.stopOnXMLErrors) {
            throw spe;
        }
    }

    protected InputStream getDTDUrlFor(String dtdFileName) {
        String dtdLoc = DTDRegistry.DTD_LOCATION.replace('/', File.separatorChar);
        File f = new File(dtdLoc + File.separatorChar + dtdFileName);
        try {
            return new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException fnfe) {
            LOG.fine("Cannot find DTD " + dtdFileName);
            return null;
        }
    }

    public static String getSchemaURLFor(String schemaSystemID) throws IOException {
        File f = SaxParserHandler.getSchemaFileFor(schemaSystemID);
        if (f == null) {
            return null;
        }
        return f.toURI().toURL().toString();
    }

    public static File getSchemaFileFor(String schemaSystemID) throws IOException {
        LOG.log(Level.FINE, "Getting Schema {0}", schemaSystemID);
        String schemaLoc = DTDRegistry.SCHEMA_LOCATION.replace('/', File.separatorChar);
        File f = new File(schemaLoc + File.separatorChar + schemaSystemID);
        if (f.exists()) {
            return f;
        }
        LOG.log(Level.INFO, "Cannot find the schema file {0}", f);
        return null;
    }

    public static String resolveSchemaNamespace(String systemID) {
        List<String> namespaces = DOLUtils.getProprietarySchemaNamespaces();
        for (String namespace : namespaces) {
            if (!systemID.startsWith(namespace)) continue;
            return systemID.substring(namespace.length());
        }
        return null;
    }

    public static String resolvePublicID(String publicID, String dtd) {
        List<String> dtdStarts = DOLUtils.getProprietaryDTDStart();
        for (String dtdStart : dtdStarts) {
            if (!dtd.startsWith(dtdStart)) continue;
            return dtd.substring(dtdStart.length());
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received notation " + name + " :=: " + publicId + " :=: " + systemId);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixMapping == null) {
            this.prefixMapping = new HashMap<String, String>();
        }
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
            this.pushedNamespaceContext = true;
        }
        this.namespaces.declarePrefix(prefix, uri);
        this.prefixMapping.put(prefix, uri);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        LOG.log(Level.FINEST, "startElement(qName={0})", qName);
        if (!this.pushedNamespaceContext) {
            this.namespaces.pushContext();
        }
        this.pushedNamespaceContext = false;
        this.doDelete = false;
        Object lastElement = null;
        try {
            lastElement = this.elementStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (lastElement == null) {
            this.rootElement = localName;
            this.versionUpgradeList = SaxParserHandler.getVersionUpgrades(this.rootElement);
            if (this.versionUpgradeList != null) {
                for (VersionUpgrade versionUpgrade : this.versionUpgradeList) {
                    versionUpgrade.init();
                }
            }
            this.elementStack.push(localName);
        } else {
            lastElement = (String)lastElement + "/" + localName;
            this.elementStack.push((String)lastElement);
        }
        if (this.versionUpgradeList != null) {
            for (VersionUpgrade versionUpgrade : this.versionUpgradeList) {
                if (VersionUpgrade.UpgradeType.REMOVE_ELEMENT != versionUpgrade.getUpgradeType()) continue;
                Map<String, String> matchXPath = versionUpgrade.getMatchXPath();
                int entriesMatched = 0;
                for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                    if (!entry.getKey().equals(lastElement)) continue;
                    entry.setValue(this.elementData.toString());
                    ++entriesMatched;
                }
                if (entriesMatched != matchXPath.size()) continue;
                this.doDelete = true;
                break;
            }
        }
        LOG.finer(() -> "Start of element with qName=" + qName + ", localName=" + localName + ", uri=" + uri);
        XMLNode node = null;
        this.elementData = new StringBuffer();
        if (this.nodes.isEmpty()) {
            Class<?> rootNodeClass = SaxParserHandler.mappingStuff.mRootNodes.get(localName);
            if (rootNodeClass == null) {
                LOG.log(Level.SEVERE, "The " + localName + " is not supported!");
                if (this.stopOnXMLErrors) {
                    throw new IllegalArgumentException(this.errorReportingString + " Element [" + localName + "] is not a valid root element");
                }
            } else {
                try {
                    node = (XMLNode)rootNodeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    LOG.log(Level.FINE, "Instantiating {0}", node);
                    if (node instanceof RootXMLNode) {
                        if (this.publicID != null) {
                            ((RootXMLNode)node).setDocType(this.publicID);
                        }
                        this.addPrefixMapping(node);
                    }
                    this.nodes.add(node);
                    this.topNode = node;
                    node.getDescriptor();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error occurred", e);
                    return;
                }
            }
        } else {
            node = this.nodes.get(this.nodes.size() - 1);
        }
        if (node != null) {
            XMLElement element = new XMLElement(qName, this.namespaces);
            if (node.handlesElement(element)) {
                node.startElement(element, attributes);
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Asking for new handler for " + element + " to " + node);
                }
                XMLNode<?> newNode = node.getHandlerFor(element);
                LOG.log(Level.FINE, "Got new node: {0}", newNode);
                this.nodes.add(newNode);
                this.addPrefixMapping(newNode);
                newNode.startElement(element, attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        boolean ignoredBecauseEmpty;
        String lastElement = null;
        try {
            lastElement = this.elementStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("End of element with qName=" + qName + ", localName=" + localName + ", uri=" + uri + " and value=" + this.elementData);
        }
        if (this.nodes.isEmpty()) {
            this.elementData = null;
            return;
        }
        XMLElement element = new XMLElement(qName, this.namespaces);
        XMLNode<?> topNode = this.nodes.get(this.nodes.size() - 1);
        boolean bl = ignoredBecauseEmpty = this.elementData != null && this.elementData.length() == 0 && !this.allowsEmptyValue(element.getQName());
        if (this.elementData != null && ignoredBecauseEmpty) {
            LOG.fine(() -> "Ignoring empty element with qName=" + qName);
        }
        if (this.elementData != null && !ignoredBecauseEmpty) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("For element " + element.getQName() + " and value " + this.elementData);
            }
            boolean doReplace = false;
            String replacementName = null;
            String replacementValue = null;
            if (this.versionUpgradeList != null) {
                for (VersionUpgrade versionUpgrade : this.versionUpgradeList) {
                    if (VersionUpgrade.UpgradeType.REPLACE_ELEMENT != versionUpgrade.getUpgradeType()) continue;
                    Map<String, String> matchXPath = versionUpgrade.getMatchXPath();
                    int entriesMatched = 0;
                    for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                        if (!entry.getKey().equals(lastElement)) continue;
                        entry.setValue(this.elementData.toString());
                        ++entriesMatched;
                    }
                    if (entriesMatched != matchXPath.size()) continue;
                    if (versionUpgrade.isValid()) {
                        doReplace = true;
                        replacementName = versionUpgrade.getReplacementElementName();
                        replacementValue = versionUpgrade.getReplacementElementValue();
                        break;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append("Invalid upgrade from <");
                    for (Map.Entry<String, String> entry : matchXPath.entrySet()) {
                        buf.append(entry.getKey()).append("  ").append(entry.getValue()).append(" >");
                    }
                    LOG.log(Level.SEVERE, buf.toString());
                    break;
                }
            }
            if (doReplace) {
                element = new XMLElement(replacementName, this.namespaces);
                topNode.setElementValue(element, replacementValue);
            } else if (!this.doDelete) {
                if (SaxParserHandler.getElementsPreservingWhiteSpace().contains(element.getQName())) {
                    topNode.setElementValue(element, this.elementData.toString());
                } else if (element.getQName().equals("env-entry-value")) {
                    Object envEntryDesc = topNode.getDescriptor();
                    if (envEntryDesc instanceof EnvironmentProperty) {
                        EnvironmentProperty envProp = (EnvironmentProperty)envEntryDesc;
                        if (String.class.getName().equals(envProp.getType()) || Character.class.getName().equals(envProp.getType())) {
                            topNode.setElementValue(element, this.elementData.toString());
                        } else {
                            topNode.setElementValue(element, this.elementData.toString().trim());
                        }
                    } else {
                        topNode.setElementValue(element, this.elementData.toString().trim());
                    }
                } else {
                    String val = this.elementData.toString().trim();
                    if ("true".equalsIgnoreCase(val)) {
                        topNode.setElementValue(element, val.toLowerCase(Locale.US));
                    } else if ("false".equalsIgnoreCase(val)) {
                        topNode.setElementValue(element, val.toLowerCase(Locale.US));
                    } else {
                        topNode.setElementValue(element, val);
                    }
                }
            }
            this.elementData = null;
        }
        if (topNode.endElement(element)) {
            LOG.log(Level.FINE, "Removing top node {0}", topNode);
            this.nodes.remove(this.nodes.size() - 1);
        }
        this.namespaces.popContext();
        this.pushedNamespaceContext = false;
        try {
            lastElement = this.elementStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (lastElement != null && lastElement.lastIndexOf("/") >= 0) {
            lastElement = lastElement.substring(0, lastElement.lastIndexOf("/"));
            this.elementStack.push(lastElement);
        }
    }

    @Override
    public void characters(char[] ch, int start, int stop) {
        if (this.elementData != null) {
            this.elementData = this.elementData.append(ch, start, stop);
        }
    }

    public XMLNode getTopNode() {
        return this.topNode;
    }

    public void setTopNode(XMLNode node) {
        this.topNode = node;
        this.nodes.add(node);
    }

    private void addPrefixMapping(XMLNode node) {
        if (this.prefixMapping != null) {
            for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                node.addPrefixMapping(entry.getKey(), entry.getValue());
            }
            this.prefixMapping = null;
        }
    }

    public void setErrorReportingString(String errorReportingString) {
        this.errorReportingString = errorReportingString;
    }

    private boolean allowsEmptyValue(String elementName) {
        return SaxParserHandler.getElementsAllowingEmptyValues().contains(elementName);
    }

    private static final class MappingStuff {
        public final ConcurrentMap<String, Boolean> mBundleRegistrationStatus = new ConcurrentHashMap<String, Boolean>();
        public final ConcurrentMap<String, String> mMapping = new ConcurrentHashMap<String, String>();
        private final ConcurrentMap<String, Class<?>> mRootNodesMutable = new ConcurrentHashMap();
        public final Map<String, Class<?>> mRootNodes = Collections.unmodifiableMap(this.mRootNodesMutable);
        private final CopyOnWriteArraySet<String> mElementsAllowingEmptyValuesMutable = new CopyOnWriteArraySet();
        public final Collection<String> mElementsAllowingEmptyValues = Collections.unmodifiableSet(this.mElementsAllowingEmptyValuesMutable);
        private final CopyOnWriteArraySet<String> mElementsPreservingWhiteSpaceMutable = new CopyOnWriteArraySet();
        public final Collection<String> mElementsPreservingWhiteSpace = Collections.unmodifiableSet(this.mElementsPreservingWhiteSpaceMutable);
        private final Map<String, List<Class<?>>> mVersionUpgradeClasses = new ConcurrentHashMap();
        private final Map<String, List<VersionUpgrade>> mVersionUpgrades = new ConcurrentHashMap<String, List<VersionUpgrade>>();

        MappingStuff() {
        }
    }
}

