/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.glassfish.bootstrap.embedded.EmbeddedGlassFishRuntimeBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.runnablejar.InfoPrinter;
import org.glassfish.runnablejar.commandline.Arguments;
import org.glassfish.runnablejar.commandline.CommandLineParser;

public class UberMain {
    private static final Logger logger = Logger.getLogger(UberMain.class.getName());
    private static final String SERVER_NAME = "server";
    GlassFish glassFish;
    CommandRunner commandRunner;

    public static void main(String ... args) throws IOException, GlassFishException {
        Arguments arguments = new CommandLineParser().parse(args);
        if (arguments.askedForHelp) {
            arguments.printHelp();
        } else {
            EmbeddedGlassFishRuntimeBuilder.addModuleJars = false;
            new UberMain().run(arguments);
        }
    }

    public void run(Arguments arguments) throws GlassFishException {
        this.addShutdownHook();
        GlassFishProperties gfProps = arguments.glassFishProperties;
        this.setFromSystemProperty(gfProps, "org.glassfish.embeddable.autoDelete", "true");
        this.glassFish = GlassFishRuntime.bootstrap().newGlassFish(gfProps);
        this.glassFish.start();
        this.commandRunner = this.glassFish.getCommandRunner();
        for (String command : arguments.commands) {
            this.executeCommandFromString(command);
        }
        if (!arguments.deployables.isEmpty()) {
            if (this.glassFish.getDeployer().getDeployedApplications().isEmpty() && arguments.deployables.size() == 1) {
                String deployable2 = arguments.deployables.get(0);
                this.executeCommandFromString("deploy --contextroot=/ " + deployable2);
                logger.log(Level.INFO, () -> "Application " + Path.of(deployable2, new String[0]).getFileName() + " deployed at context root \"/\"");
            } else {
                arguments.deployables.forEach(deployable -> {
                    this.executeCommandFromString("deploy " + deployable);
                    logger.log(Level.INFO, () -> "Application " + Path.of(deployable, new String[0]).getFileName() + " deployed");
                });
            }
        }
        if (arguments.shutdown) {
            logger.log(Level.INFO, () -> "Shutting down after startup as requested");
            System.exit(0);
        }
        switch (this.glassFish.getStatus()) {
            case INIT: 
            case STARTING: 
            case STARTED: {
                if (!arguments.noInfo) {
                    this.printInfoAfterStartup();
                }
                if (!this.glassFish.getDeployer().getDeployedApplications().isEmpty()) break;
                this.runCommandPromptLoop();
                System.exit(0);
                break;
            }
            case STOPPING: {
                logger.log(Level.INFO, () -> "GlassFish is shutting down...");
                break;
            }
            default: {
                logger.log(Level.INFO, () -> "GlassFish is shut down");
            }
        }
    }

    protected void printInfoAfterStartup() throws GlassFishException {
        Level LOG_LEVEL = Level.INFO;
        if (logger.isLoggable(LOG_LEVEL)) {
            Domain domain = (Domain)this.glassFish.getService(Domain.class);
            List applications = domain.getApplicationsInTarget(SERVER_NAME);
            List listeners = domain.getServers().getServer(SERVER_NAME).getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener();
            logger.log(LOG_LEVEL, "\n\n" + new InfoPrinter().getInfoAfterStartup(applications, listeners) + "\n");
        }
    }

    private void runCommandPromptLoop() throws GlassFishException {
        while (true) {
            System.out.print("\n\nGlassFish $ ");
            String str = null;
            try {
                str = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())).readLine();
            }
            catch (IOException | RuntimeException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (str == null || str.trim().length() == 0) continue;
            if ("exit".equalsIgnoreCase(str) || "quit".equalsIgnoreCase(str)) break;
            this.executeCommandFromString(str);
        }
    }

    private void executeCommandFromString(String stringCommand) {
        logger.log(Level.FINE, () -> "Executing command: " + stringCommand);
        String[] split = stringCommand.split(" ");
        String command = split[0].trim();
        String[] commandParams = null;
        if (split.length > 1) {
            commandParams = new String[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                commandParams[i - 1] = split[i].trim();
            }
        }
        try {
            CommandResult result = commandParams == null ? this.commandRunner.run(command, new String[0]) : this.commandRunner.run(command, commandParams);
            switch (result.getExitStatus()) {
                case SUCCESS: {
                    logger.log(Level.INFO, () -> "SUCCESS: " + result.getOutput());
                    break;
                }
                default: {
                    if (result.getFailureCause() != null) {
                        throw result.getFailureCause();
                    }
                    throw new RuntimeException("Command completed with " + result.getExitStatus() + ": " + result.getOutput() + ". Command was: " + stringCommand);
                }
            }
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, ex.getMessage());
            logger.log(Level.FINE, ex.getMessage(), ex);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

            @Override
            public void run() {
                if (UberMain.this.glassFish != null) {
                    UberMain.this.stopGlassFish();
                }
            }
        });
    }

    private void stopGlassFish() {
        try {
            this.glassFish.stop();
        }
        catch (GlassFishException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                this.glassFish.dispose();
            }
            catch (GlassFishException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void setFromSystemProperty(GlassFishProperties gfProps, String propertyName, String defaultValue) {
        String systemProperty = System.getProperty(propertyName);
        if (systemProperty != null) {
            gfProps.setProperty(propertyName, systemProperty);
        } else if (!gfProps.getProperties().containsKey(propertyName)) {
            gfProps.setProperty(propertyName, defaultValue);
        }
    }
}

