/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Watcher
implements Closeable {
    private Path root;
    private boolean watch = true;
    private WatchService watcher;
    private PathMatcher dirMatcher;
    private PathMatcher fileMatcher;
    private final Map<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
    private volatile long lastModified;
    private final Map<Path, Boolean> processedMap = new ConcurrentHashMap<Path, Boolean>();

    public void init() throws IOException {
        if (this.root == null) {
            Iterable<Path> rootDirectories = this.getFileSystem().getRootDirectories();
            for (Path rootDirectory : rootDirectories) {
                if (rootDirectory == null) continue;
                this.root = rootDirectory;
                break;
            }
        }
        if (!Files.exists(this.root, new LinkOption[0])) {
            this.fail("Root path does not exist: %s", this.root);
        } else if (!Files.isDirectory(this.root, new LinkOption[0])) {
            this.fail("Root path is not a directory: %s", this.root);
        }
        if (this.watcher == null) {
            this.watcher = this.watch ? this.getFileSystem().newWatchService() : null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            this.watcher.close();
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setRootPath(String rootPath) {
        Path path = new File(rootPath).getAbsoluteFile().toPath();
        this.setRoot(path);
    }

    public void setRootDirectory(File directory) {
        this.setRoot(directory.toPath());
    }

    public Path getRoot() {
        return this.root;
    }

    public void setRoot(Path root) {
        this.root = root;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public WatchService getWatcher() {
        return this.watcher;
    }

    public void setWatcher(WatchService watcher) {
        this.watcher = watcher;
    }

    public PathMatcher getDirMatcher() {
        return this.dirMatcher;
    }

    public void setDirMatcher(PathMatcher dirMatcher) {
        this.dirMatcher = dirMatcher;
    }

    public PathMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    public void setFileMatcher(PathMatcher fileMatcher) {
        this.fileMatcher = fileMatcher;
    }

    public void rescan() throws IOException {
        for (WatchKey key : this.keys.keySet()) {
            key.cancel();
        }
        this.keys.clear();
        Files.walkFileTree(this.root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new FilteringFileVisitor());
    }

    public void processEvents() {
        WatchKey key;
        while ((key = this.watcher.poll()) != null) {
            Path dir = this.keys.get(key);
            if (dir == null) {
                this.warn("Could not find key for %s", key);
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = null;
                if (name != null) {
                    child = dir.resolve(name);
                }
                this.debug("Processing event %s on path %s", kind, child);
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                try {
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        if (Files.isDirectory(child, new LinkOption[0])) {
                            Files.walkFileTree(child, new FilteringFileVisitor());
                            continue;
                        }
                        if (!Files.isRegularFile(child, new LinkOption[0])) continue;
                        this.scan(child);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        if (!Files.isRegularFile(child, new LinkOption[0])) continue;
                        this.scan(child);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    this.unscan(child);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.debug("Removing key %s and dir %s from keys", key, dir);
            this.keys.remove(key);
            if (!this.keys.isEmpty()) continue;
            break;
        }
    }

    private void scan(Path file) throws IOException {
        if (this.isMatchesFile(file)) {
            this.process(file);
            this.processedMap.put(file, Boolean.TRUE);
        }
    }

    protected boolean isMatchesFile(Path file) {
        boolean matches = true;
        if (this.fileMatcher != null) {
            Path rel = this.root.relativize(file);
            matches = this.fileMatcher.matches(rel);
        }
        return matches;
    }

    private void unscan(Path file) throws IOException {
        if (this.isMatchesFile(file)) {
            this.onRemove(file);
            this.lastModified = System.currentTimeMillis();
        } else {
            ArrayList<Path> files = new ArrayList<Path>(this.processedMap.keySet());
            for (Path path : files) {
                if (Files.exists(path, new LinkOption[0])) continue;
                this.debug("File has been deleted: %s", path);
                this.processedMap.remove(path);
                if (!this.isMatchesFile(path)) continue;
                this.onRemove(file);
                this.lastModified = System.currentTimeMillis();
            }
        }
    }

    private void watch(Path path) throws IOException {
        if (this.watcher != null) {
            WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.keys.put(key, path);
            this.debug("Watched path %s key %s", path, key);
        } else {
            this.warn("No watcher yet for path %s", path);
        }
    }

    protected FileSystem getFileSystem() {
        return FileSystems.getDefault();
    }

    public void fail(String message, Object ... args) {
        this.warn(message, args);
        throw new IllegalArgumentException(message);
    }

    protected abstract void debug(String var1, Object ... var2);

    protected abstract void warn(String var1, Object ... var2);

    protected abstract void process(Path var1);

    protected abstract void onRemove(Path var1);

    public class FilteringFileVisitor
    implements FileVisitor<Path> {
        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path rel;
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (Watcher.this.dirMatcher != null && !"".equals((rel = Watcher.this.root.relativize(dir)).toString()) && !Watcher.this.dirMatcher.matches(rel)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            Watcher.this.watch(dir);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            Watcher.this.scan(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

