/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.v3.admin.AdminConsoleConfigUpgrade;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.adapter.ConsoleLoadingOption;
import com.sun.enterprise.v3.admin.adapter.InstallerThread;
import com.sun.enterprise.v3.admin.adapter.Utils;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.types.Property;

@Service
public final class AdminConsoleAdapter
extends HttpHandler
implements Adapter,
EventListener {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private static final String TEST_BACKEND_IS_READY = "/testifbackendisready.html";
    private static final String STATUS_TOKEN = "%%%STATUS%%%";
    private static final String RESOURCE_PACKAGE = "com/sun/enterprise/v3/admin/adapter";
    private static final Set<Method> allowedHttpMethods = Set.of(Method.GET, Method.POST, Method.HEAD, Method.DELETE, Method.PUT);
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    @Named(value="default-instance-name")
    private AdminService adminService;
    @Inject
    private Domain domain;
    @Inject
    @Named(value="default-instance-name")
    private Config serverConfig;
    @Inject
    private Events events;
    @Inject
    private ServiceLocator serviceLocator;
    private final CountDownLatch serverReady = new CountDownLatch(1);
    private AdminConsoleConfigUpgrade adminConsoleConfigUpgrade;
    private AdminEndpointDecider endpointDecider;
    private ResourceBundle resourceBundle;
    private String contextRoot;
    private Path warFile;
    private ConsoleLoadingOption loadingOption = ConsoleLoadingOption.DEFAULT;
    private volatile AdapterState stateMsg = AdapterState.UNINITIALIZED;
    private volatile boolean installing;
    private boolean isRegistered;
    private volatile boolean isRestStarted;
    private volatile boolean isRestBeingStarted;

    public String getContextRoot() {
        return this.endpointDecider.getGuiContextRoot();
    }

    public HttpHandler getHttpService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) {
        this.resourceBundle = this.getResourceBundle(request.getLocale());
        Method method = request.getMethod();
        if (!AdminConsoleAdapter.checkHttpMethodAllowed(method)) {
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, AdminConsoleAdapter.getAllowedHttpMethodsAsString());
            return;
        }
        if (!this.serverEnvironment.isDas()) {
            this.sendStatusNotAvailable(response, "statusNotDAS.html");
            return;
        }
        if (this.loadingOption == ConsoleLoadingOption.NEVER) {
            this.sendStatusNotAvailable(response, "statusDisabled.html");
            return;
        }
        if (this.adminConsoleConfigUpgrade == null) {
            this.adminConsoleConfigUpgrade = (AdminConsoleConfigUpgrade)this.serviceLocator.getService(AdminConsoleConfigUpgrade.class, new Annotation[0]);
        }
        try {
            if (!this.serverReady.await(100L, TimeUnit.SECONDS)) {
                logger.log(Level.SEVERE, "NCLS-CORE-00007");
                return;
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "NCLS-CORE-00008");
            return;
        }
        this.logRequest(request);
        if (this.isResourceRequest(request)) {
            try {
                this.handleResourceRequest(request, response);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "NCLS-CORE-00009", new Object[]{request.getRequestURI(), e});
                logger.log(Level.FINE, e, e::toString);
            }
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        Object serverVersion = Version.getProductIdInfo();
        if (TEST_BACKEND_IS_READY.equals(request.getRequestURI())) {
            Object status;
            try {
                status = this.resourceBundle.getString(this.getStateMsg().getI18NKey());
            }
            catch (MissingResourceException e) {
                status = this.getStateMsg().toString();
            }
            String welcomeKey = AdapterState.WELCOME_TO.getI18NKey();
            try {
                serverVersion = this.resourceBundle.getString(welcomeKey) + " " + (String)serverVersion + ".";
            }
            catch (MissingResourceException e) {
                serverVersion = String.valueOf((Object)AdapterState.WELCOME_TO) + " " + (String)serverVersion + ".";
            }
            status = (String)status + "\n" + (String)serverVersion;
            try {
                OutputBuffer outputBuffer = this.getOutputBuffer(response);
                byte[] bytes = (":::" + (String)status).getBytes(StandardCharsets.UTF_8);
                response.setContentLength(bytes.length);
                outputBuffer.write(bytes);
                outputBuffer.flush();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "NCLS-CORE-00009", e);
            }
            return;
        }
        if (!this.isApplicationLoaded()) {
            if ("/favicon.ico".equals(request.getRequestURI())) {
                return;
            }
            if (!this.isRestStarted) {
                this.forceRestModuleLoad();
            }
            AdminConsoleAdapter adminConsoleAdapter = this;
            synchronized (adminConsoleAdapter) {
                if (this.isInstalling()) {
                    this.sendStatusPage(response);
                } else if (!this.isApplicationLoaded()) {
                    this.loadConsole();
                    this.sendStatusPage(response);
                }
            }
        }
    }

    void loadConsole() {
        try {
            this.setInstalling(true);
            this.startThread();
        }
        catch (Exception e) {
            this.setInstalling(false);
            throw new RuntimeException("Unable to install Admin Console!", e);
        }
    }

    private boolean isResourceRequest(Request request) {
        return this.getContentType(request.getRequestURI()) != null;
    }

    private void forceRestModuleLoad() {
        if (this.isRestBeingStarted) {
            return;
        }
        this.isRestBeingStarted = true;
        Thread thread = new Thread("Force REST Module Load Thread"){

            @Override
            public void run() {
                AdminConsoleAdapter.this.initRest();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String getContentType(String resource) {
        if (resource == null || resource.isEmpty()) {
            return null;
        }
        if (resource.endsWith(".gif")) {
            return "image/gif";
        }
        if (resource.endsWith(".jpg")) {
            return "image/jpeg";
        }
        logger.log(Level.FINE, () -> "Unhandled content type: " + resource);
        return null;
    }

    private void handleResourceRequest(Request request, Response response) throws IOException {
        String resourcePath = RESOURCE_PACKAGE + request.getRequestURI();
        ClassLoader loader = AdminConsoleAdapter.class.getClassLoader();
        try (InputStream resourceStream = loader.getResourceAsStream(resourcePath);){
            if (resourceStream == null) {
                logger.log(Level.WARNING, "NCLS-CORE-00010", resourcePath);
                return;
            }
            byte[] bytes = resourceStream.readAllBytes();
            String contentType = this.getContentType(resourcePath);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            response.setContentLength(bytes.length);
            OutputStream out = response.getOutputStream();
            out.write(bytes);
            out.flush();
        }
    }

    boolean isApplicationLoaded() {
        return this.stateMsg == AdapterState.APPLICATION_LOADED;
    }

    boolean isInstalling() {
        return this.installing;
    }

    void setInstalling(boolean installing) {
        this.installing = installing;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    void setStateMsg(AdapterState stateMsg) {
        this.stateMsg = stateMsg;
        logger.log(Level.FINE, stateMsg::toString);
    }

    AdapterState getStateMsg() {
        return this.stateMsg;
    }

    ConsoleLoadingOption getLoadingOption() {
        return this.loadingOption;
    }

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
        this.init();
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event<?> event) {
        this.serverReady.countDown();
        if (logger != null) {
            logger.log(Level.FINE, "AdminConsoleAdapter is ready.");
        }
    }

    private void init() {
        Property locationProperty;
        String loadingOptionValue;
        Property loadingOptionProperty = this.adminService.getProperty("adminConsoleStartup");
        if (loadingOptionProperty != null && (loadingOptionValue = loadingOptionProperty.getValue()) != null) {
            try {
                this.loadingOption = ConsoleLoadingOption.valueOf(loadingOptionValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "AdminConsoleAdapter: Illegal console loading option \"{0}\"", loadingOptionValue);
            }
        }
        if ((locationProperty = this.adminService.getProperty("adminConsoleDownloadLocation")) == null || locationProperty.getValue() == null || locationProperty.getValue().isEmpty()) {
            this.warFile = Path.of(System.getProperty("com.sun.aas.installRoot"), "lib/install/applications/admingui.war");
            this.writeAdminServiceProperty("adminConsoleDownloadLocation", "${com.sun.aas.installRoot}/lib/install/applications/admingui.war");
        } else {
            String locationValue = locationProperty.getValue();
            this.warFile = Path.of(locationValue, new String[0]);
            if (!this.warFile.isAbsolute()) {
                this.warFile = Path.of(System.getProperty("com.sun.aas.installRoot"), new String[0]).resolveSibling(locationValue);
            }
        }
        logger.log(Level.FINE, () -> "Admin Console download location: " + String.valueOf(this.warFile.toAbsolutePath()));
        this.initState();
        try {
            this.endpointDecider = new AdminEndpointDecider(this.serverConfig);
            this.contextRoot = this.endpointDecider.getGuiContextRoot();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "NCLS-CORE-00011", e);
        }
    }

    void initRest() {
        try {
            NetworkListener adminListener = this.domain.getServerNamed("server").getConfig().getNetworkConfig().getNetworkListener("admin-listener");
            SecureAdmin secureAdmin = (SecureAdmin)this.serviceLocator.getService(SecureAdmin.class, new Annotation[0]);
            URL url = new URL(SecureAdmin.isEnabled((SecureAdmin)secureAdmin) ? "https" : "http", adminListener.getAddress(), Integer.parseInt(adminListener.getPort()), "/management/domain");
            URLConnection connection = url.openConnection();
            try (InputStream ignored = connection.getInputStream();){
                this.isRestStarted = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, null, e);
        }
    }

    private void initState() {
        if (this.appExistsInConfig()) {
            this.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        } else {
            Path explodedWar = this.warFile.resolveSibling("__admingui");
            if (Files.exists(explodedWar, new LinkOption[0]) || Files.exists(this.warFile, new LinkOption[0])) {
                this.setStateMsg(AdapterState.DOWNLOADED);
            } else {
                this.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
            }
        }
    }

    private boolean appExistsInConfig() {
        return this.getConfig() != null;
    }

    Application getConfig() {
        return this.domain.getSystemApplicationReferencedFrom(this.serverEnvironment.getInstanceName(), "__admingui");
    }

    private void logRequest(Request request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AdminConsoleAdapter''s STATE IS: {0}", (Object)this.getStateMsg());
            logger.log(Level.FINE, "Current Thread: {0}", Thread.currentThread().getName());
            for (String name : request.getParameterNames()) {
                String values = Arrays.toString(request.getParameterValues(name));
                logger.log(Level.FINE, "Parameter name: {0} values: {1}", new Object[]{name, values});
            }
        }
    }

    private void startThread() {
        new InstallerThread(this, this.serviceLocator, this.domain, this.serverEnvironment, this.contextRoot, this.endpointDecider.getGuiHosts()).start();
    }

    private OutputBuffer getOutputBuffer(Response response) {
        response.setStatus(HttpStatus.ACCEPTED_202);
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        return response.getOutputBuffer();
    }

    private void sendStatusPage(Response response) {
        try {
            OutputBuffer outputBuffer = this.getOutputBuffer(response);
            String html = Utils.packageResource2String("status.html");
            String localHtml = this.replaceTokens(html, this.resourceBundle);
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.resourceBundle.getString(status);
            }
            catch (MissingResourceException e) {
                status = this.getStateMsg().toString();
            }
            byte[] bytes = localHtml.replace(STATUS_TOKEN, status).getBytes(StandardCharsets.UTF_8);
            response.setContentLength(bytes.length);
            outputBuffer.write(bytes);
            outputBuffer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendStatusNotAvailable(Response response, String statusPage) {
        try {
            OutputBuffer outputBuffer = this.getOutputBuffer(response);
            String html = Utils.packageResource2String(statusPage);
            String localHtml = this.replaceTokens(html, this.resourceBundle);
            byte[] bytes = localHtml.getBytes(StandardCharsets.UTF_8);
            response.setContentLength(bytes.length);
            outputBuffer.write(bytes);
            outputBuffer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.v3.admin.adapter.LocalStrings", locale);
    }

    private String replaceTokens(String text, ResourceBundle bundle) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int end = 0;
        while (start != -1) {
            start = text.indexOf("%%%", end);
            if (start == -1) continue;
            sb.append(text, end, start);
            end = text.indexOf("%%%", start += 3);
            if (end != -1) {
                try {
                    sb.append(bundle.getString(text.substring(start, end)));
                }
                catch (MissingResourceException e) {
                    sb.append("%%%").append(text, start, end).append("%%%");
                }
                end += 3;
                continue;
            }
            sb.append("%%%");
            end = start;
        }
        sb.append(text.substring(end));
        return sb.toString();
    }

    private void writeAdminServiceProperty(String propertyName, String propertyValue) {
        try {
            ConfigSupport.apply(adminService -> {
                Property newProperty = (Property)adminService.createChild(Property.class);
                adminService.getProperty().add(newProperty);
                newProperty.setName(propertyName);
                newProperty.setValue(propertyValue);
                return newProperty;
            }, (ConfigBeanProxy)this.adminService);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "NCLS-CORE-00012", new Object[]{propertyName, propertyValue, e});
        }
    }

    public int getListenPort() {
        return this.endpointDecider.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.endpointDecider.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.endpointDecider.getGuiHosts();
    }

    private static boolean checkHttpMethodAllowed(Method method) {
        return allowedHttpMethods.contains(method);
    }

    private static String getAllowedHttpMethodsAsString() {
        StringBuilder sb = new StringBuilder();
        for (Method method : allowedHttpMethods) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(method.getMethodString());
        }
        return sb.toString();
    }
}

