/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.listener;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.listener.ConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.util.IdentityHashMap;
import java.util.Map;

public class LocalTxConnectionEventListener
extends ConnectionEventListener {
    private final PoolManager poolManager = ConnectorRuntime.getRuntime().getPoolManager();
    private final IdentityHashMap<Object, ResourceHandle> associatedHandles = new IdentityHashMap(10);
    private final ResourceHandle resource;

    public LocalTxConnectionEventListener(ResourceHandle resource) {
        this.resource = resource;
    }

    public synchronized void connectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        this.poolManager.resourceClosed(handle);
    }

    public synchronized void connectionErrorOccurred(ConnectionEvent evt) {
        this.resource.setConnectionErrorOccurred();
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
        this.poolManager.resourceErrorOccurred(this.resource);
    }

    @Override
    public synchronized void badConnectionClosed(ConnectionEvent evt) {
        Object connectionHandle = evt.getConnectionHandle();
        ResourceHandle handle = this.associatedHandles.getOrDefault(connectionHandle, this.resource);
        ManagedConnection mc = (ManagedConnection)evt.getSource();
        mc.removeConnectionEventListener((jakarta.resource.spi.ConnectionEventListener)this);
        this.poolManager.badResourceClosed(handle);
    }

    public void localTransactionStarted(ConnectionEvent evt) {
    }

    public void localTransactionCommitted(ConnectionEvent evt) {
    }

    public void localTransactionRolledback(ConnectionEvent evt) {
    }

    public synchronized void associateHandle(Object userHandle, ResourceHandle resourceHandle) {
        this.associatedHandles.put(userHandle, resourceHandle);
    }

    public synchronized ResourceHandle removeAssociation(Object userHandle) {
        return this.associatedHandles.remove(userHandle);
    }

    public synchronized Map<Object, ResourceHandle> getAssociatedHandlesAndClearMap() {
        IdentityHashMap result = (IdentityHashMap)this.associatedHandles.clone();
        this.associatedHandles.clear();
        return result;
    }
}

