/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableMap;
import org.jboss.weld.util.collections.ImmutableMapEntry;
import org.jboss.weld.util.collections.ImmutableSet;

public abstract class ImmutableMap<K, V>
extends AbstractImmutableMap<K, V> {
    ImmutableMap() {
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        Preconditions.checkNotNull(map);
        return ImmutableMap.builder().putAll(map).build();
    }

    public static <K, V> Map<K, V> of(K key, V value) {
        return new ImmutableMapEntry<K, V>(key, value);
    }

    public static <T, K, V> ImmutableMapCollector<T, K, V> collector(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return new ImmutableMapCollector<T, K, V>(keyMapper, valueMapper);
    }

    public static <K, V> Builder<K, V> builder() {
        return new HashMapBuilder();
    }

    private static class ImmutableMapCollector<T, K, V>
    implements Collector<T, HashMapBuilder<K, V>, Map<K, V>> {
        private static final Set<Collector.Characteristics> CHARACTERISTICS = ImmutableSet.of(new Collector.Characteristics[0]);
        private final Function<T, K> keyMapper;
        private final Function<T, V> valueMapper;

        private ImmutableMapCollector(Function<T, K> keyMapper, Function<T, V> valueMapper) {
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public Supplier<HashMapBuilder<K, V>> supplier() {
            return () -> new HashMapBuilder();
        }

        @Override
        public BiConsumer<HashMapBuilder<K, V>, T> accumulator() {
            return (b, i) -> b.put(this.keyMapper.apply(i), this.valueMapper.apply(i));
        }

        @Override
        public BinaryOperator<HashMapBuilder<K, V>> combiner() {
            return (builder1, builder2) -> builder1.putAll(builder2);
        }

        @Override
        public Function<HashMapBuilder<K, V>, Map<K, V>> finisher() {
            return HashMapBuilder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }

    private static class HashMapBuilder<K, V>
    implements Builder<K, V> {
        private static final int DEFAULT_INITIAL_CAPACITY = 4;
        private static final float LOAD_FACTOR = 1.2f;
        private Map<K, V> map = new HashMap(4, 1.2f);

        private HashMapBuilder() {
        }

        @Override
        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<K, V> items) {
            this.map.putAll(items);
            return this;
        }

        @Override
        HashMapBuilder<K, V> putAll(HashMapBuilder<K, V> items) {
            this.map.putAll(items.map);
            return this;
        }

        @Override
        public Map<K, V> build() {
            if (this.map.isEmpty()) {
                return Collections.emptyMap();
            }
            if (this.map.size() == 1) {
                return new ImmutableMapEntry<K, V>(this.map.entrySet().iterator().next());
            }
            return Collections.unmodifiableMap(this.map);
        }
    }

    public static interface Builder<K, V> {
        public Builder<K, V> put(K var1, V var2);

        public Builder<K, V> putAll(Map<K, V> var1);

        public Map<K, V> build();
    }
}

