/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class Resizer
extends TimerTask {
    protected static final Logger _logger = LogDomains.getLogger(Resizer.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected PoolInfo poolInfo;
    protected DataStructure dataStructure;
    protected PoolProperties pool;
    protected ResourceHandler handler;
    protected boolean preferValidateOverRecreate;

    public Resizer(PoolInfo poolInfo, DataStructure ds, PoolProperties pp, ResourceHandler handler, boolean preferValidateOverRecreate) {
        this.poolInfo = poolInfo;
        this.dataStructure = ds;
        this.pool = pp;
        this.handler = handler;
        this.preferValidateOverRecreate = preferValidateOverRecreate;
    }

    @Override
    public void run() {
        Resizer.debug("Resizer for pool " + String.valueOf(this.poolInfo));
        try {
            this.resizePool(true);
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.poolInfo, ex.getMessage()};
            _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
        }
    }

    public void resizePool(boolean forced) {
        if (this.pool.getWaitQueueLength() > 0) {
            return;
        }
        int noOfResourcesRemoved = this.removeIdleAndInvalidResources();
        int poolScaleDownQuantity = this.pool.getResizeQuantity() - noOfResourcesRemoved;
        this.scaleDownPool(poolScaleDownQuantity, forced);
        this.ensureSteadyPool();
        Resizer.debug("No. of resources held for pool [ " + String.valueOf(this.poolInfo) + " ] : " + this.dataStructure.getResourcesSize());
    }

    private void ensureSteadyPool() {
        if (this.dataStructure.getResourcesSize() < this.pool.getSteadyPoolSize()) {
            for (int i = this.dataStructure.getResourcesSize(); i < this.pool.getSteadyPoolSize(); ++i) {
                try {
                    this.handler.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException ex) {
                    Object[] params = new Object[]{this.poolInfo, ex.getMessage()};
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
                }
            }
        }
    }

    protected void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() > 0 && forced) {
            ResourceHandle h;
            int n = scaleDownQuantity = scaleDownQuantity <= this.dataStructure.getResourcesSize() - this.pool.getSteadyPoolSize() ? scaleDownQuantity : 0;
            while (scaleDownQuantity > 0 && (h = this.dataStructure.getResource()) != null) {
                this.dataStructure.removeResource(h);
                --scaleDownQuantity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.dataStructure.getResourcesSize();
        int size = this.dataStructure.getFreeListSize();
        long currentTime = System.currentTimeMillis();
        int validConnectionsCounter = 0;
        int idleConnKeptInSteadyCounter = 0;
        HashSet<ResourceHandle> activeResources = new HashSet<ResourceHandle>();
        HashSet<String> resourcesToValidate = new HashSet<String>();
        try {
            ResourceHandle h;
            while ((h = this.dataStructure.getResource()) != null) {
                ResourceState state = h.getResourceState();
                if (currentTime - state.getTimestamp() < this.pool.getIdleTimeout()) {
                    ++validConnectionsCounter;
                    resourcesToValidate.add(h.toString());
                    activeResources.add(h);
                    continue;
                }
                boolean isResourceEligibleForRemoval = this.isResourceEligibleForRemoval(h, validConnectionsCounter);
                if (!isResourceEligibleForRemoval) {
                    ++idleConnKeptInSteadyCounter;
                    activeResources.add(h);
                    Resizer.debug("PreferValidateOverRecreate: Keeping idle resource " + String.valueOf(h) + " in the steady part of the free pool as the RA reports it to be valid (" + ++validConnectionsCounter + " <= " + this.pool.getSteadyPoolSize() + ")");
                    continue;
                }
                this.dataStructure.removeResource(h);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.dataStructure.returnResource(activeResource);
            }
        }
        this.removeInvalidResources(resourcesToValidate);
        if (this.preferValidateOverRecreate) {
            Resizer.debug("Idle resources validated and kept in the steady pool for pool [ " + String.valueOf(this.poolInfo) + " ] - " + idleConnKeptInSteadyCounter);
            Resizer.debug("Number of Idle resources freed for pool [ " + String.valueOf(this.poolInfo) + " ] - " + (size - activeResources.size() - idleConnKeptInSteadyCounter));
            Resizer.debug("Number of Invalid resources removed for pool [ " + String.valueOf(this.poolInfo) + " ] - " + (activeResources.size() - this.dataStructure.getFreeListSize() + idleConnKeptInSteadyCounter));
        } else {
            Resizer.debug("Number of Idle resources freed for pool [ " + String.valueOf(this.poolInfo) + " ] - " + (size - activeResources.size()));
            Resizer.debug("Number of Invalid resources removed for pool [ " + String.valueOf(this.poolInfo) + " ] - " + (activeResources.size() - this.dataStructure.getFreeListSize()));
        }
        int noOfResourcesRemoved = poolSizeBeforeRemoval - this.dataStructure.getResourcesSize();
        return noOfResourcesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidResources(Set<String> freeConnectionsToValidate) {
        try {
            Resizer.debug("Sending a set of free connections to RA, of size : " + freeConnectionsToValidate.size());
            int invalidConnectionsCount = 0;
            HashSet<ResourceHandle> validResources = new HashSet<ResourceHandle>();
            try {
                ResourceHandle handle;
                while ((handle = this.dataStructure.getResource()) != null) {
                    if (freeConnectionsToValidate.contains(handle.toString())) {
                        HashSet<ManagedConnection> connectionsToTest = new HashSet<ManagedConnection>();
                        connectionsToTest.add((ManagedConnection)handle.getResource());
                        Set<ManagedConnection> invalidConnections = this.handler.getInvalidConnections(connectionsToTest);
                        if (invalidConnections != null && !invalidConnections.isEmpty()) {
                            invalidConnectionsCount = this.validateAndRemoveResource(handle, invalidConnections);
                            continue;
                        }
                        validResources.add(handle);
                        continue;
                    }
                    validResources.add(handle);
                }
            }
            finally {
                for (ResourceHandle resourceHandle : validResources) {
                    this.dataStructure.returnResource(resourceHandle);
                }
                validResources.clear();
                Resizer.debug("No. of invalid connections received from RA : " + invalidConnectionsCount);
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
    }

    protected static void debug(String debugStatement) {
        _logger.log(Level.FINE, debugStatement);
    }

    protected int validateAndRemoveResource(ResourceHandle handle, Set<ManagedConnection> invalidConnections) {
        int invalidConnectionsCount = 0;
        for (ManagedConnection invalid : invalidConnections) {
            if (!invalid.equals(handle.getResource())) continue;
            this.dataStructure.removeResource(handle);
            this.handler.invalidConnectionDetected(handle);
            ++invalidConnectionsCount;
        }
        return invalidConnectionsCount;
    }

    protected boolean isResourceEligibleForRemoval(ResourceHandle h, int validConnectionsCounter) {
        boolean isResourceEligibleForRemoval = false;
        ResourceState state = h.getResourceState();
        ResourceAllocator alloc = h.getResourceAllocator();
        if (this.preferValidateOverRecreate && alloc.hasValidatingMCF()) {
            if (validConnectionsCounter < this.pool.getSteadyPoolSize() && alloc.isConnectionValid(h)) {
                h.setLastValidated(System.currentTimeMillis());
                state.touchTimestamp();
            } else {
                if (_logger.isLoggable(Level.FINEST)) {
                    if (validConnectionsCounter <= this.pool.getSteadyPoolSize()) {
                        _logger.log(Level.FINEST, "PreferValidateOverRecreate: Removing idle resource " + String.valueOf(h) + " from the free pool as the RA reports it to be invalid");
                    } else {
                        _logger.log(Level.FINEST, "PreferValidateOverRecreate: Removing idle resource " + String.valueOf(h) + " from the free pool as the steady part size has already been exceeded (" + validConnectionsCounter + " > " + this.pool.getSteadyPoolSize() + ")");
                    }
                }
                isResourceEligibleForRemoval = true;
            }
        } else {
            isResourceEligibleForRemoval = true;
        }
        return isResourceEligibleForRemoval;
    }
}

