/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.Constants;
import com.sun.enterprise.glassfish.bootstrap.EmbeddedMain;
import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.StaticGlassFishRuntime;
import com.sun.enterprise.glassfish.bootstrap.UberMain;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.Which;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.spi.RuntimeBuilder;

public class StaticGlassFishRuntimeBuilder
implements RuntimeBuilder {
    private static Logger logger = Util.getLogger();
    private static final String JAR_EXT = ".jar";
    final List<String> moduleExcludes = Arrays.asList("jsftemplating.jar", "gf-client-module.jar");

    public GlassFishRuntime build(BootstrapProperties bsProps) throws GlassFishException {
        String installRoot = this.getInstallRoot(bsProps);
        if (installRoot != null) {
            System.setProperty("org.glassfish.embeddable.installRoot", installRoot);
        }
        List<URL> moduleJarURLs = this.getModuleJarURLs(installRoot);
        Object cl = this.getClass().getClassLoader();
        if (!moduleJarURLs.isEmpty()) {
            cl = new StaticClassLoader(this.getClass().getClassLoader(), moduleJarURLs);
        }
        EmbeddedMain main = new EmbeddedMain((ClassLoader)cl);
        SingleHK2Factory.initialize(cl);
        ModulesRegistry modulesRegistry = AbstractFactory.getInstance().createModulesRegistry();
        modulesRegistry.setParentClassLoader((ClassLoader)cl);
        StaticGlassFishRuntime glassFishRuntime = new StaticGlassFishRuntime(main);
        logger.logp(Level.FINER, this.getClass().getName(), "build", "Created GlassFishRuntime {0} with InstallRoot {1}, Bootstrap Options {2}", new Object[]{glassFishRuntime, installRoot, bsProps});
        return glassFishRuntime;
    }

    public boolean handles(BootstrapProperties bsProps) {
        String builderName = bsProps.getProperty("GlassFish.BUILDER_NAME");
        if (builderName != null && !builderName.equals(this.getClass().getName())) {
            return false;
        }
        String platform = bsProps.getProperty("GlassFish_Platform");
        return platform == null || Constants.Platform.Static.toString().equalsIgnoreCase(platform);
    }

    private String getInstallRoot(BootstrapProperties props) {
        File installRoot;
        String installRootProp = props.getInstallRoot();
        if (installRootProp == null && this.isValidInstallRoot(installRoot = MainHelper.findInstallRoot())) {
            installRootProp = installRoot.getAbsolutePath();
        }
        return installRootProp;
    }

    private boolean isValidInstallRoot(File installRoot) {
        return installRoot == null ? false : this.isValidInstallRoot(installRoot.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> getModuleJarURLs(String installRoot) {
        if (installRoot == null) {
            return new ArrayList<URL>();
        }
        JarFile jarfile = null;
        try {
            jarfile = new JarFile(Which.jarFile(this.getClass()));
            String mainClassName = jarfile.getManifest().getMainAttributes().getValue("Main-Class");
            if (UberMain.class.getName().equals(mainClassName)) {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                return arrayList;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex);
        }
        finally {
            if (jarfile != null) {
                try {
                    jarfile.close();
                }
                catch (IOException ex) {}
            }
        }
        File modulesDir = new File(installRoot, "modules/");
        final File autostartModulesDir = new File(modulesDir, "autostart/");
        final ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        modulesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(autostartModulesDir)) {
                    pathname.listFiles(this);
                } else if (pathname.getName().endsWith(StaticGlassFishRuntimeBuilder.JAR_EXT) && !StaticGlassFishRuntimeBuilder.this.moduleExcludes.contains(pathname.getName())) {
                    try {
                        moduleJarURLs.add(pathname.toURI().toURL());
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex);
                    }
                }
                return false;
            }
        });
        return moduleJarURLs;
    }

    private boolean isValidInstallRoot(String installRootPath) {
        if (installRootPath == null || !new File(installRootPath).exists()) {
            return false;
        }
        if (!new File(installRootPath, "modules").exists()) {
            return false;
        }
        return new File(installRootPath, "lib/dtds").exists();
    }

    private static class StaticClassLoader
    extends GlassfishUrlClassLoader {
        public StaticClassLoader(ClassLoader parent, List<URL> moduleJarURLs) {
            super(moduleJarURLs.toArray(new URL[moduleJarURLs.size()]), parent);
        }
    }
}

