/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class GlassfishBootstrapClassLoader
extends URLClassLoader {
    public GlassfishBootstrapClassLoader(File glassfishDir, ClassLoader parent) throws IOException {
        super(GlassfishBootstrapClassLoader.createUrls(glassfishDir), parent);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": " + String.valueOf(Arrays.stream(this.getURLs()).collect(Collectors.toList()));
    }

    private static URL[] createUrls(File glassfishDir) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File libDir = glassfishDir.toPath().resolve(Paths.get("lib", "bootstrap")).toFile();
        urls.add(GlassfishBootstrapClassLoader.getURL(libDir, "glassfish-jul-extension"));
        urls.add(GlassfishBootstrapClassLoader.getURL(libDir, "grizzly-npn-api"));
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL getURL(File dir, String jarFileName) throws IOException {
        File file = new File(dir, jarFileName + ".jar");
        try {
            if (!file.canRead()) {
                throw new IOException("The jar file does not exist or cannot be read: " + String.valueOf(file));
            }
            return new File(dir, jarFileName + ".jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("Could not convert file " + String.valueOf(file) + " to url.", e);
        }
    }

    static {
        GlassfishBootstrapClassLoader.registerAsParallelCapable();
    }
}

