/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ConfiguratorImpl;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.ExtrasUtilities;

public class GlassFishImpl
implements GlassFish {
    private ModuleStartup gfKernel;
    private ServiceLocator habitat;
    volatile GlassFish.Status status = GlassFish.Status.INIT;

    public GlassFishImpl(ModuleStartup gfKernel, ServiceLocator habitat, Properties gfProps) throws GlassFishException {
        this.gfKernel = gfKernel;
        this.habitat = habitat;
        ExtrasUtilities.enableTopicDistribution((ServiceLocator)habitat);
        this.configure(gfProps);
    }

    private void configure(Properties gfProps) throws GlassFishException {
        ConfiguratorImpl configurator = new ConfiguratorImpl(this.habitat);
        configurator.configure(gfProps);
    }

    public synchronized void start() throws GlassFishException {
        if (this.status == GlassFish.Status.STARTED || this.status == GlassFish.Status.STARTING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + String.valueOf(this.status) + " state.");
        }
        this.status = GlassFish.Status.STARTING;
        this.gfKernel.start();
        this.status = GlassFish.Status.STARTED;
    }

    public synchronized void stop() throws GlassFishException {
        if (this.status == GlassFish.Status.STOPPED || this.status == GlassFish.Status.STOPPING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + String.valueOf(this.status) + " state.");
        }
        this.status = GlassFish.Status.STOPPING;
        this.gfKernel.stop();
        this.status = GlassFish.Status.STOPPED;
    }

    public synchronized void dispose() throws GlassFishException {
        if (this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already disposed.");
        }
        if (this.status != GlassFish.Status.STOPPED) {
            try {
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.gfKernel = null;
        this.habitat = null;
        this.status = GlassFish.Status.DISPOSED;
    }

    public GlassFish.Status getStatus() {
        return this.status;
    }

    public <T> T getService(Class<T> serviceType) throws GlassFishException {
        return this.getService(serviceType, null);
    }

    public synchronized <T> T getService(Class<T> serviceType, String serviceName) throws GlassFishException {
        if (this.status != GlassFish.Status.STARTED) {
            throw new IllegalArgumentException("Server is not started yet. It is in " + String.valueOf(this.status) + "state");
        }
        return (T)(serviceName != null ? this.habitat.getService(serviceType, serviceName, new Annotation[0]) : this.habitat.getService(serviceType, new Annotation[0]));
    }

    public Deployer getDeployer() throws GlassFishException {
        return this.getService(Deployer.class);
    }

    public CommandRunner getCommandRunner() throws GlassFishException {
        return this.getService(CommandRunner.class);
    }
}

