/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.admin.InstanceDeployCommandParameters;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transaction;

@Service(name="_deploy")
@PerLookup
@ExecuteOn(value={RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_deploy", description="_deploy")})
public class InstanceDeployCommand
extends InstanceDeployCommandParameters
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InstanceDeployCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Applications applications;
    @Inject
    ServerEnvironment env;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    private Domain domain;

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "write"));
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(AdminCommandContext ctxt) {
        block66: {
            Throwable cause;
            Object errorMessage;
            ReadableArchive archive;
            Logger logger;
            ActionReport report;
            long operationStartTime;
            block65: {
                block64: {
                    Object errorMessage2;
                    block63: {
                        block62: {
                            String enabledAttr;
                            String vs;
                            operationStartTime = Calendar.getInstance().getTimeInMillis();
                            report = ctxt.getActionReport();
                            logger = ctxt.getLogger();
                            archive = null;
                            this.origin = OpsParams.Origin.deploy_instance;
                            this.command = OpsParams.Command._deploy;
                            this.previousContextRoot = this.preservedcontextroot;
                            if (this.previousVirtualServers != null && (vs = this.previousVirtualServers.getProperty(this.target)) != null) {
                                this.virtualservers = vs;
                            }
                            if (this.previousEnabledAttributes != null && (enabledAttr = this.previousEnabledAttributes.getProperty(this.target)) != null) {
                                String enabledAttrForApp = this.previousEnabledAttributes.getProperty("domain");
                                this.enabled = Boolean.valueOf(enabledAttr) != false && Boolean.valueOf(enabledAttrForApp) != false;
                            }
                            if (this.path.exists()) break block62;
                            report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{this.path.getAbsolutePath()}));
                            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                            try {
                                if (archive != null) {
                                    archive.close();
                                }
                            }
                            catch (IOException e) {
                                logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                            }
                            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                                logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                                errorMessage = report.getMessage();
                                cause = report.getFailureCause();
                                if (cause != null) {
                                    String causeMessage = cause.getMessage();
                                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                        errorMessage = (String)errorMessage + " : " + cause.getMessage();
                                    }
                                    logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                                }
                                report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage}));
                                report.setFailureCause(null);
                            }
                            return;
                        }
                        if (!this.snifferManager.hasNoSniffers()) break block63;
                        String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
                        report.failure(logger, msg);
                        try {
                            if (archive != null) {
                                archive.close();
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                        } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                            errorMessage2 = report.getMessage();
                            Throwable cause2 = report.getFailureCause();
                            if (cause2 != null) {
                                String causeMessage = cause2.getMessage();
                                if (causeMessage != null && !causeMessage.equals(errorMessage2)) {
                                    errorMessage2 = (String)errorMessage2 + " : " + cause2.getMessage();
                                }
                                logger.log(Level.SEVERE, (String)errorMessage2, cause2.getCause());
                            }
                            report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage2}));
                            report.setFailureCause(null);
                        }
                        return;
                    }
                    archive = this.archiveFactory.openArchive(this.path, (DeployCommandParameters)this);
                    ArchiveHandler archiveHandler = this.deployment.getArchiveHandler(archive, this.type);
                    if (archiveHandler != null) break block64;
                    report.failure(logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{this.path.getName()}));
                    try {
                        if (archive != null) {
                            archive.close();
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        errorMessage2 = report.getMessage();
                        Throwable cause3 = report.getFailureCause();
                        if (cause3 != null) {
                            String causeMessage = cause3.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage2)) {
                                errorMessage2 = (String)errorMessage2 + " : " + cause3.getMessage();
                            }
                            logger.log(Level.SEVERE, (String)errorMessage2, cause3.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage2}));
                        report.setFailureCause(null);
                    }
                    return;
                }
                if (!this.keepreposdir.booleanValue()) {
                    FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), VersioningUtils.getRepositoryName((String)this.name)));
                }
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)this, report).source(archive).build();
                deploymentContext.clean();
                deploymentContext.getAppProps().putAll((Map<?, ?>)this.appprops);
                this.processGeneratedContent(this.generatedcontent, deploymentContext, logger);
                Transaction t = null;
                Application application = this.applications.getApplication(this.name);
                t = application != null ? new Transaction() : this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
                ApplicationInfo appInfo = this.deployment.deploy(deploymentContext);
                if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) break block65;
                try {
                    this.moveAltDDFilesToPermanentLocation(deploymentContext, logger);
                    if (application != null) {
                        this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t, true);
                    } else {
                        this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t);
                    }
                }
                catch (Exception e) {
                    this.deployment.undeploy(this.name, deploymentContext);
                    deploymentContext.clean();
                    throw e;
                }
            }
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
            } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = report.getMessage();
                cause = report.getFailureCause();
                if (cause != null) {
                    String causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = (String)errorMessage + " : " + cause.getMessage();
                    }
                    logger.log(Level.SEVERE, (String)errorMessage, cause.getCause());
                }
                report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage}));
                report.setFailureCause(null);
            }
            break block66;
            catch (Throwable e) {
                try {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(e.getMessage());
                    report.setFailureCause(e);
                }
                catch (Throwable throwable) {
                    try {
                        if (archive != null) {
                            archive.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e2);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                    } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        Object errorMessage3 = report.getMessage();
                        Throwable cause4 = report.getFailureCause();
                        if (cause4 != null) {
                            String causeMessage = cause4.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage3)) {
                                errorMessage3 = (String)errorMessage3 + " : " + cause4.getMessage();
                            }
                            logger.log(Level.SEVERE, (String)errorMessage3, cause4.getCause());
                        }
                        report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage3}));
                        report.setFailureCause(null);
                    }
                    throw throwable;
                }
                try {
                    if (archive != null) {
                        archive.close();
                    }
                }
                catch (IOException e3) {
                    logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e3);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                } else if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                    Object errorMessage4 = report.getMessage();
                    cause = report.getFailureCause();
                    if (cause != null) {
                        String causeMessage = cause.getMessage();
                        if (causeMessage != null && !causeMessage.equals(errorMessage4)) {
                            errorMessage4 = (String)errorMessage4 + " : " + cause.getMessage();
                        }
                        logger.log(Level.SEVERE, (String)errorMessage4, cause.getCause());
                    }
                    report.setMessage(localStrings.getLocalString("failToLoadOnInstance", "Failed to load the application on instance {0} : {1}", new Object[]{this.server.getName(), errorMessage4}));
                    report.setFailureCause(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGeneratedContent(File generatedContentParam, ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        if (generatedContentParam == null) {
            return;
        }
        File baseDir = deploymentContext.getScratchDir("xml").getParentFile().getParentFile();
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IOException(localStrings.getLocalString("instancedeploy.command.errcredir", "Error creating directory {0}.  No further information about the failure is available.", new Object[]{baseDir.getAbsolutePath()}));
        }
        URI baseURI = baseDir.toURI();
        try (ZipFile zipFile = new ZipFile(generatedContentParam);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                URI outputFileURI = Util.resolve((URI)baseURI, (String)zipEntry.getName());
                File outputFile = new File(outputFileURI);
                if (zipEntry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new IOException(localStrings.getLocalString("instancedeploy.command.errcredir", "Error creating directory {0}.  No further information about the failure is available.", new Object[]{baseDir.getAbsolutePath()}));
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    FileUtils.copy((InputStream)inputStream, (File)outputFile, (long)zipEntry.getSize());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    private void moveAltDDFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger) throws IOException {
        File finalAltDDDir = deploymentContext.getAppAltDDDir();
        if (!finalAltDDDir.mkdirs()) {
            logger.log(Level.FINE, " Attempting to create directory {0} was reported as failed; attempting to continue", new Object[]{finalAltDDDir.getAbsolutePath()});
        }
        DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.altdd, logger, this.env);
        DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.runtimealtdd, logger, this.env);
    }
}

