/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

public abstract class AbstractClassLoaderResourceLoader
implements ResourceLoader {
    private static final String ERROR_LOADING_CLASS = "Error loading class ";

    @Override
    public Class<?> classForName(String name) {
        try {
            return this.classLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException(ERROR_LOADING_CLASS + name, e);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.classLoader().getResource(name);
    }

    @Override
    public Collection<URL> getResources(String name) {
        try {
            return new EnumerationList<URL>(this.classLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, e);
        }
    }

    protected abstract ClassLoader classLoader();
}

