/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ssl.SSLSupport;

class JSSESupport
implements SSLSupport {
    private static final Logger logger = Grizzly.logger(JSSESupport.class);
    private static final SSLSupport.CipherData[] ciphers = new SSLSupport.CipherData[]{new SSLSupport.CipherData("_WITH_NULL_", 0), new SSLSupport.CipherData("_WITH_IDEA_CBC_", 128), new SSLSupport.CipherData("_WITH_RC2_CBC_40_", 40), new SSLSupport.CipherData("_WITH_RC4_40_", 40), new SSLSupport.CipherData("_WITH_RC4_128_", 128), new SSLSupport.CipherData("_WITH_DES40_CBC_", 40), new SSLSupport.CipherData("_WITH_DES_CBC_", 56), new SSLSupport.CipherData("_WITH_3DES_EDE_CBC_", 168), new SSLSupport.CipherData("_WITH_AES_128_", 128), new SSLSupport.CipherData("_WITH_AES_256_", 256)};
    protected SSLSocket ssl;
    protected SSLEngine sslEngine;
    protected SSLSession session;

    JSSESupport(SSLSocket sock) {
        this.ssl = sock;
        this.session = this.ssl.getSession();
    }

    JSSESupport(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.session = sslEngine.getSession();
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws IOException {
        return this.getPeerCertificates(false);
    }

    protected Certificate[] getX509Certificates(SSLSession session) throws IOException {
        Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificates();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new X509Certificate[]{};
        }
        Certificate[] x509Certs = new X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (X509Certificate)cf.generateCertificate(stream);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINE, "Cert #" + i + " = " + String.valueOf(x509Certs[i]));
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error translating " + String.valueOf(jsseCerts[i]), ex);
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    @Override
    public Certificate[] getPeerCertificates(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        Certificate[] jsseCerts = null;
        try {
            jsseCerts = this.session.getPeerCertificates();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            this.session.invalidate();
            this.handShake();
            this.session = this.ssl == null ? this.sslEngine.getSession() : this.ssl.getSession();
        }
        return this.getX509Certificates(this.session);
    }

    protected void handShake() throws IOException {
        this.ssl.setNeedClientAuth(true);
        this.ssl.startHandshake();
    }

    @Override
    public Integer getKeySize() throws IOException {
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue("jakarta.servlet.request.key_size");
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (SSLSupport.CipherData element : ciphers) {
                if (cipherSuite.indexOf(element.phrase) < 0) continue;
                size = element.keySize;
                break;
            }
            keySize = size;
            this.session.putValue("jakarta.servlet.request.key_size", keySize);
        }
        return keySize;
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(32);
        for (byte element : ssl_session) {
            String digit = Integer.toHexString(element);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }
}

