/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.jts.ResourceRecoveryManagerImpl;
import com.sun.enterprise.transaction.jts.recovery.GMSCallBack;
import com.sun.enterprise.transaction.jts.recovery.OracleXAResource;
import com.sun.enterprise.transaction.jts.recovery.SybaseXAResource;
import com.sun.enterprise.transaction.spi.JavaEETransactionManagerDelegate;
import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.AdminUtil;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RWLock;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.WorkException;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEETransactionManagerJTSDelegate
implements JavaEETransactionManagerDelegate,
PostConstruct {
    private static StringManager sm = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private static final ReadWriteLock lock = new ReadWriteLock();
    private static JavaEETransactionManagerJTSDelegate instance;
    @Inject
    private ServiceLocator serviceLocator;
    private JavaEETransactionManager javaEETransactionManager;
    private final ThreadLocal<TransactionManager> transactionManagerLocal = new ThreadLocal();
    private final Hashtable globalTransactions;
    private final Hashtable<String, XAResourceWrapper> xaresourcewrappers = new Hashtable();
    private Logger logger;
    private boolean lao = true;
    private volatile TransactionManager transactionManagerImpl;
    private TransactionService transactionService;

    public JavaEETransactionManagerJTSDelegate() {
        this.globalTransactions = new Hashtable();
    }

    public void postConstruct() {
        if (this.javaEETransactionManager != null) {
            this.javaEETransactionManager.setDelegate((JavaEETransactionManagerDelegate)this);
        }
        this.logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, (String)"jakarta.enterprise.resource.jta");
        this.initTransactionProperties();
        JavaEETransactionManagerJTSDelegate.setInstance(this);
    }

    public boolean useLAO() {
        return this.lao;
    }

    public void setUseLAO(boolean b) {
        this.lao = b;
    }

    public void commitDistributedTransaction() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.logger.log(Level.FINE, "TM: commit");
        this.validateTransactionManager();
        TransactionManager transactionManager = this.transactionManagerLocal.get();
        Transaction obj = transactionManager.getTransaction();
        JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETransactionManager;
        boolean success = false;
        if (javaEETMS.isInvocationStackEmpty()) {
            try {
                transactionManager.commit();
                success = true;
            }
            catch (HeuristicMixedException e) {
                success = true;
                throw e;
            }
            finally {
                javaEETMS.monitorTxCompleted((Object)obj, success);
            }
        }
        try {
            javaEETMS.setTransactionCompeting(true);
            transactionManager.commit();
            success = true;
        }
        catch (HeuristicMixedException e) {
            success = true;
            throw e;
        }
        finally {
            javaEETMS.monitorTxCompleted((Object)obj, success);
            javaEETMS.setTransactionCompeting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackDistributedTransaction() throws IllegalStateException, SecurityException, SystemException {
        block7: {
            this.logger.log(Level.FINE, "TM: rollback");
            this.validateTransactionManager();
            TransactionManager transactionManager = this.transactionManagerLocal.get();
            Transaction obj = transactionManager.getTransaction();
            JavaEETransactionManagerSimplified javaEETMS = (JavaEETransactionManagerSimplified)this.javaEETransactionManager;
            try {
                if (javaEETMS.isInvocationStackEmpty()) {
                    transactionManager.rollback();
                    break block7;
                }
                try {
                    javaEETMS.setTransactionCompeting(true);
                    transactionManager.rollback();
                }
                finally {
                    javaEETMS.setTransactionCompeting(false);
                }
            }
            finally {
                javaEETMS.monitorTxCompleted((Object)obj, false);
            }
        }
    }

    public int getStatus() throws SystemException {
        JavaEETransaction tx = this.javaEETransactionManager.getCurrentTransaction();
        int status = 6;
        TransactionManager transactionManager = this.transactionManagerLocal.get();
        if (tx != null) {
            status = tx.getStatus();
        } else if (transactionManager != null) {
            status = transactionManager.getStatus();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TM: status: " + JavaEETransactionManagerSimplified.getStatusAsString((int)status));
        }
        return status;
    }

    public Transaction getTransaction() throws SystemException {
        JavaEETransaction javaEETransaction = this.javaEETransactionManager.getCurrentTransaction();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TM: getTransaction: tx=" + String.valueOf(javaEETransaction) + ", tm=" + String.valueOf(this.transactionManagerLocal.get()));
        }
        if (javaEETransaction != null) {
            return javaEETransaction;
        }
        TransactionInternal jtsTx = null;
        TransactionManager tm = this.transactionManagerLocal.get();
        if (tm != null) {
            jtsTx = (TransactionInternal)tm.getTransaction();
        }
        if (jtsTx == null) {
            return null;
        }
        javaEETransaction = (JavaEETransaction)this.globalTransactions.get(jtsTx);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TM: getTransaction: tx=" + String.valueOf(javaEETransaction) + ", jtsTx=" + String.valueOf(jtsTx));
        }
        if (javaEETransaction == null) {
            javaEETransaction = ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).createImportedTransaction(jtsTx);
            this.globalTransactions.put(jtsTx, javaEETransaction);
        }
        this.javaEETransactionManager.setCurrentTransaction(javaEETransaction);
        return javaEETransaction;
    }

    public JavaEETransaction getJavaEETransaction(Transaction transaction) {
        if (transaction instanceof JavaEETransaction) {
            return (JavaEETransaction)transaction;
        }
        return (JavaEETransaction)this.globalTransactions.get(transaction);
    }

    public boolean enlistDistributedNonXAResource(Transaction transaction, TransactionalResource transactionalResource) throws RollbackException, IllegalStateException, SystemException {
        if (this.useLAO()) {
            if (((JavaEETransactionManagerSimplified)this.javaEETransactionManager).resourceEnlistable(transactionalResource)) {
                XAResource res = transactionalResource.getXAResource();
                boolean result = transaction.enlistResource(res);
                if (!transactionalResource.isEnlisted()) {
                    transactionalResource.enlistedInTransaction(transaction);
                }
                return result;
            }
            return true;
        }
        throw new IllegalStateException(sm.getString("enterprise_distributedtx.nonxa_usein_jts"));
    }

    public boolean enlistLAOResource(Transaction transaction, TransactionalResource transactionalResource) throws RollbackException, IllegalStateException, SystemException {
        if (transaction instanceof JavaEETransaction) {
            JavaEETransaction eeTransaction = (JavaEETransaction)transaction;
            ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).startJTSTx(eeTransaction);
            if (this.useLAO() && transactionalResource != null && eeTransaction.getLAOResource() == null) {
                eeTransaction.setLAOResource(transactionalResource);
                if (transactionalResource.isTransactional()) {
                    return transaction.enlistResource(transactionalResource.getXAResource());
                }
            }
            return true;
        }
        return false;
    }

    public void setRollbackOnlyDistributedTransaction() throws IllegalStateException, SystemException {
        this.logger.log(Level.FINE, "TM: setRollbackOnly");
        this.validateTransactionManager();
        this.transactionManagerLocal.get().setRollbackOnly();
    }

    public Transaction suspend(JavaEETransaction tx) throws SystemException {
        if (tx != null) {
            if (!tx.isLocalTx()) {
                this.suspendXA();
            }
            this.javaEETransactionManager.setCurrentTransaction(null);
            return tx;
        }
        if (this.transactionManagerLocal.get() != null) {
            return this.suspendXA();
        }
        return null;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.logger.log(Level.FINE, "TM: resume");
        if (this.transactionManagerImpl != null) {
            this.setTransactionManager();
            this.transactionManagerLocal.get().resume(tx);
        }
    }

    public void removeTransaction(Transaction transaction) {
        this.globalTransactions.remove(transaction);
    }

    public int getOrder() {
        return 3;
    }

    public void setTransactionManager(JavaEETransactionManager eeTransactionManager) {
        this.javaEETransactionManager = eeTransactionManager;
        this.logger = ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).getLogger();
    }

    public TransactionInternal startJTSTx(JavaEETransaction transaction, boolean isAssociatedTimeout) throws RollbackException, IllegalStateException, SystemException {
        this.setTransactionManager();
        JavaEETransactionImpl eeTransactionImpl = (JavaEETransactionImpl)transaction;
        try {
            if (isAssociatedTimeout) {
                int timeout = eeTransactionImpl.cancelTimerTask();
                int newtimeout = (int)((System.currentTimeMillis() - eeTransactionImpl.getStartTime()) / 1000L);
                newtimeout = timeout - newtimeout;
                this.beginJTS(newtimeout);
            } else {
                this.beginJTS(((JavaEETransactionManagerSimplified)this.javaEETransactionManager).getEffectiveTimeout());
            }
        }
        catch (NotSupportedException ex) {
            throw new RuntimeException(sm.getString("enterprise_distributedtx.lazy_transaction_notstarted"), ex);
        }
        TransactionInternal jtsTx = (TransactionInternal)this.transactionManagerLocal.get().getTransaction();
        this.globalTransactions.put(jtsTx, eeTransactionImpl);
        return jtsTx;
    }

    public void initRecovery(boolean force) {
        TransactionServiceProperties.initRecovery(force);
    }

    public void recover(XAResource[] resourceList) {
        this.setTransactionManager();
        TransactionManagerImpl.recover(Collections.enumeration(Arrays.asList(resourceList)));
    }

    public void release(Xid xid) throws WorkException {
        this.setTransactionManager();
        TransactionManagerImpl.release(xid);
    }

    public void recreate(Xid xid, long timeout) throws WorkException {
        this.setTransactionManager();
        TransactionManagerImpl.recreate(xid, timeout);
    }

    public XATerminator getXATerminator() {
        this.setTransactionManager();
        return TransactionManagerImpl.getXATerminator();
    }

    private Transaction suspendXA() throws SystemException {
        this.logger.log(Level.FINE, "TM: suspend");
        this.validateTransactionManager();
        return this.transactionManagerLocal.get().suspend();
    }

    private void validateTransactionManager() throws IllegalStateException {
        if (this.transactionManagerLocal.get() == null) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.transaction_notactive"));
        }
    }

    private void setTransactionManager() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "TM: setTransactionManager: tm=" + String.valueOf(this.transactionManagerLocal.get()));
        }
        if (this.transactionManagerImpl == null) {
            this.transactionManagerImpl = TransactionManagerImpl.getTransactionManagerImpl();
        }
        if (this.transactionManagerLocal.get() == null) {
            this.transactionManagerLocal.set(this.transactionManagerImpl);
        }
    }

    public XAResourceWrapper getXAResourceWrapper(String clName) {
        XAResourceWrapper xaResourceWrapper = this.xaresourcewrappers.get(clName);
        if (xaResourceWrapper == null) {
            return null;
        }
        return xaResourceWrapper.getInstance();
    }

    public void handlePropertyUpdate(String name, Object value) {
        if (name.equals("keypoint-interval")) {
            Configuration.setKeypointTrigger(Integer.parseInt((String)value, 10));
        } else if (name.equals("retry-timeout-in-seconds")) {
            Configuration.setCommitRetryVar((String)value);
        }
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, XAResource[] xaresArray) throws Exception {
        if (!delegated) {
            RecoveryManager.recoverIncompleteTx(xaresArray);
            return true;
        }
        return DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
    }

    public void beginJTS(int timeout) throws NotSupportedException, SystemException {
        TransactionManagerImpl transactionManagerImpl = (TransactionManagerImpl)this.transactionManagerLocal.get();
        transactionManagerImpl.begin(timeout);
        ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).monitorTxBegin(transactionManagerImpl.getTransaction());
    }

    public boolean supportsXAResource() {
        return true;
    }

    public void initTransactionProperties() {
        if (this.serviceLocator != null) {
            this.transactionService = (TransactionService)this.serviceLocator.getService(TransactionService.class, "default-instance-name", new Annotation[0]);
            if (this.transactionService != null) {
                String value = this.transactionService.getPropertyValue("use-last-agent-optimization");
                if (value != null && "false".equals(value)) {
                    this.setUseLAO(false);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "TM: LAO is disabled");
                    }
                }
                if ((value = this.transactionService.getPropertyValue("oracle-xa-recovery-workaround")) == null || "true".equals(value)) {
                    this.xaresourcewrappers.put("oracle.jdbc.xa.client.OracleXADataSource", new OracleXAResource());
                }
                if (Boolean.parseBoolean(this.transactionService.getPropertyValue("sybase-xa-recovery-workaround"))) {
                    this.xaresourcewrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", new SybaseXAResource());
                }
                if (Boolean.parseBoolean(this.transactionService.getAutomaticRecovery())) {
                    Properties props = TransactionServiceProperties.getJTSProperties(this.serviceLocator, false);
                    DefaultTransactionService.setServerName(props);
                    if (Boolean.parseBoolean(this.transactionService.getPropertyValue("delegated-recovery"))) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.log(Level.FINE, "TM: Registering for GMS notification callback");
                        }
                        int waitTime = 60;
                        value = this.transactionService.getPropertyValue("wait-time-before-recovery-insec");
                        if (value != null) {
                            try {
                                waitTime = Integer.parseInt(value);
                            }
                            catch (Exception e) {
                                this.logger.log(Level.WARNING, "error_wait_time_before_recovery", e);
                            }
                        }
                        new GMSCallBack(waitTime, this.serviceLocator);
                    }
                }
            }
        }
    }

    public boolean isNullTransaction() {
        try {
            return InterceptorImpl.isTxCtxtNull();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public TransactionAdminBean getTransactionAdminBean(Transaction t) throws SystemException {
        TransactionAdminBean tBean = null;
        if (t instanceof TransactionImpl) {
            String id = ((TransactionImpl)t).getTransactionId();
            long startTime = ((TransactionImpl)t).getStartTime();
            long elapsedTime = System.currentTimeMillis() - startTime;
            String status = JavaEETransactionManagerSimplified.getStatusAsString((int)t.getStatus());
            JavaEETransactionImpl tran = (JavaEETransactionImpl)this.globalTransactions.get(t);
            if (tran != null) {
                tBean = ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).getTransactionAdminBean((Transaction)tran);
                tBean.setIdentifier((Object)t);
                tBean.setId(id);
                tBean.setStatus(status);
                tBean.setElapsedTime(elapsedTime);
                if (tBean.getComponentName() == null) {
                    tBean.setComponentName("unknown");
                }
            } else {
                tBean = new TransactionAdminBean((Object)t, id, status, elapsedTime, "unknown", null);
            }
        } else {
            tBean = ((JavaEETransactionManagerSimplified)this.javaEETransactionManager).getTransactionAdminBean(t);
        }
        return tBean;
    }

    public String getTxLogLocation() {
        if (Configuration.getServerName() == null) {
            Properties props = TransactionServiceProperties.getJTSProperties(this.serviceLocator, false);
            DefaultTransactionService.setServerName(props);
        }
        return Configuration.getDirectory("com.sun.jts.logDirectory", "jts", new int[1]);
    }

    public void registerRecoveryResourceHandler(XAResource xaResource) {
        ResourceRecoveryManagerImpl.registerRecoveryResourceHandler(xaResource);
    }

    public Lock getReadLock() {
        return lock;
    }

    public void acquireWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            return;
        }
        AdminUtil.freezeAll();
        lock.acquireWriteLock();
    }

    public void releaseWriteLock() {
        if (AdminUtil.isFrozenAll()) {
            AdminUtil.unfreezeAll();
        }
        lock.releaseWriteLock();
    }

    public boolean isWriteLocked() {
        return AdminUtil.isFrozenAll();
    }

    public static JavaEETransactionManagerJTSDelegate getInstance() {
        return instance;
    }

    private static void setInstance(JavaEETransactionManagerJTSDelegate new_instance) {
        if (instance == null) {
            instance = new_instance;
        }
    }

    public void initXA() {
        this.setTransactionManager();
    }

    private static class ReadWriteLock
    implements Lock {
        private static final RWLock freezeLock = new RWLock();

        private ReadWriteLock() {
        }

        @Override
        public void lock() {
            freezeLock.acquireReadLock();
        }

        @Override
        public void unlock() {
            freezeLock.releaseReadLock();
        }

        private void acquireWriteLock() {
            freezeLock.acquireWriteLock();
        }

        private void releaseWriteLock() {
            freezeLock.releaseWriteLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

