/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.runtime.common;

import java.lang.reflect.Constructor;
import java.security.Principal;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.security.common.UserNameAndPassword;

public class PrincipalNameDescriptor
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private String principalName;
    private String className;
    private transient ClassLoader cLoader;

    public PrincipalNameDescriptor(String name) {
        this.principalName = name;
    }

    public String getName() {
        return this.principalName;
    }

    public String getClassName() {
        if (this.className == null) {
            return UserNameAndPassword.class.getName();
        }
        return this.className;
    }

    public void setName(String name) {
        this.principalName = name;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setClassLoader(ClassLoader c) {
        this.cLoader = c;
    }

    public final Principal toPrincipal() {
        try {
            if (this.cLoader == null) {
                this.cLoader = Thread.currentThread().getContextClassLoader();
            }
            Class<?> clazz = Class.forName(this.getClassName(), true, this.cLoader);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (Principal)constructor.newInstance(this.principalName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Invalid principal settings: " + String.valueOf((Object)this), ex);
        }
    }

    public String toString() {
        return "principal-name: " + this.principalName + "; className: " + this.getClassName();
    }
}

