/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.web.integration;

import java.security.Principal;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.exousia.modules.locked.AuthorizationRoleMapper;
import org.glassfish.internal.api.Globals;

public class GlassfishRoleMapper
implements AuthorizationRoleMapper {
    private static final Logger defaultLogger = Logger.getLogger(GlassfishRoleMapper.class.getName());
    private final Logger logger;

    public GlassfishRoleMapper(Logger logger) {
        this.logger = logger == null ? defaultLogger : logger;
    }

    private SecurityRoleMapper getInternalMapper(String contextId) {
        SecurityRoleMapperFactory factory = (SecurityRoleMapperFactory)Globals.get(SecurityRoleMapperFactory.class);
        if (factory == null) {
            String msg = "RoleMapper.factory.lookup.failed";
            this.logger.log(Level.SEVERE, msg);
            throw new SecurityException(msg);
        }
        SecurityRoleMapper securityRoleMapper = factory.getRoleMapper(contextId);
        if (securityRoleMapper == null) {
            String msg = "RoleMapper.mapper.lookup.failed";
            this.logger.log(Level.SEVERE, msg);
            throw new SecurityException(msg);
        }
        return securityRoleMapper;
    }

    private Set<String> getDeclaredRoles(SecurityRoleMapper srm) {
        String msg = "RoleMapper.unable.to.get.roles";
        this.logger.log(Level.SEVERE, msg);
        throw new UnsupportedOperationException(msg);
    }

    private Set<Principal> getPrincipalsInRole(SecurityRoleMapper securityRoleMapper, String roleName) throws SecurityException, UnsupportedOperationException {
        Map roleMap = securityRoleMapper.getRoleToSubjectMapping();
        if (roleMap == null) {
            return null;
        }
        Subject subject = (Subject)roleMap.get(roleName);
        if (subject == null) {
            return null;
        }
        return subject.getPrincipals();
    }

    public boolean arePrincipalsInRole(SecurityRoleMapper srm, Principal[] principals, String roleName) throws SecurityException {
        if (principals == null || principals.length == 0) {
            return false;
        }
        Set<Principal> rolePrincipals = this.getPrincipalsInRole(srm, roleName);
        if (rolePrincipals == null || rolePrincipals.isEmpty()) {
            return false;
        }
        for (Principal principal : principals) {
            if (!rolePrincipals.contains(principal)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getDeclaredRoles(String contextId) {
        return this.getDeclaredRoles(this.getInternalMapper(contextId));
    }

    public boolean isSubjectInRole(String contextId, Subject subject, String roleName) throws SecurityException {
        return this.arePrincipalsInRole(contextId, this.toArray(subject.getPrincipals()), roleName);
    }

    public boolean arePrincipalsInRole(String contextId, Principal[] principals, String roleName) throws SecurityException {
        return this.arePrincipalsInRole(this.getInternalMapper(contextId), principals, roleName);
    }

    public Set<String> getRolesOfSubject(String contextId, Subject subject) throws SecurityException, UnsupportedOperationException {
        return this.getRolesOfPrincipals(contextId, this.toArray(subject.getPrincipals()));
    }

    public Set<String> getRolesOfPrincipals(String contextId, Principal[] principals) throws SecurityException, UnsupportedOperationException {
        if (principals.length == 0) {
            return null;
        }
        SecurityRoleMapper securityRoleMapper = this.getInternalMapper(contextId);
        Set<String> roleNames = this.getDeclaredRoles(securityRoleMapper);
        HashSet<String> roles = new HashSet<String>();
        block0: for (String roleName : roleNames) {
            Set<Principal> principalsInRole = this.getPrincipalsInRole(securityRoleMapper, roleName);
            if (principalsInRole == null) continue;
            for (Principal p : principals) {
                if (!principalsInRole.contains(p)) continue;
                roles.add(roleName);
                continue block0;
            }
        }
        return roles;
    }

    public BitSet getRolesOfSubject(String contextId, String[] roles, Subject subject) throws SecurityException, UnsupportedOperationException {
        return this.getRolesOfPrincipals(contextId, roles, this.toArray(subject.getPrincipals()));
    }

    private Principal[] toArray(Set<Principal> principals) {
        Principal[] list = new Principal[principals.size()];
        int i = 0;
        for (Principal obj : principals) {
            if (!(obj instanceof Principal)) continue;
            list[i] = obj;
        }
        return list;
    }

    public BitSet getRolesOfPrincipals(String contextId, String[] roles, Principal[] principals) throws SecurityException, UnsupportedOperationException {
        if (principals.length == 0 || roles == null || roles.length == 0) {
            return null;
        }
        BitSet roleSet = new BitSet(roles.length);
        SecurityRoleMapper srm = this.getInternalMapper(contextId);
        for (int i = 0; i < roles.length; ++i) {
            roleSet.set(i, this.arePrincipalsInRole(srm, principals, roles[i]));
        }
        return roleSet;
    }

    public Set<Principal> getPrincipalsInRole(String contextId, String roleName) throws SecurityException, UnsupportedOperationException {
        return this.getPrincipalsInRole(this.getInternalMapper(contextId), roleName);
    }
}

