/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class EventsImpl
implements Events {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    @Inject
    private ExecutorService executor;
    private final Queue<EventListener> listeners = new ConcurrentLinkedQueue<EventListener>();

    public void register(EventListener listener) {
        this.listeners.add(listener);
    }

    public void send(EventListener.Event<?> event) {
        this.send(event, true);
    }

    public void send(EventListener.Event<?> event, boolean asynchronously) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            EventTypes interested;
            Method eventMethod;
            EventListener listener = (EventListener)iterator.next();
            try {
                eventMethod = listener.getClass().getMethod("event", EventListener.Event.class);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "NCLS-CORE-00068", t);
                iterator.remove();
                continue;
            }
            RestrictTo restrictTo = eventMethod.getParameters()[0].getAnnotation(RestrictTo.class);
            if (restrictTo != null && !event.is(interested = EventTypes.create((String)restrictTo.value()))) continue;
            if (asynchronously) {
                this.executor.submit(() -> {
                    try {
                        listener.event(event);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "NCLS-CORE-00069", t);
                    }
                });
                continue;
            }
            try {
                listener.event(event);
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "NCLS-CORE-00069", t);
            }
        }
    }

    public boolean unregister(EventListener listener) {
        return this.listeners.remove(listener);
    }
}

