/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@PerLookup
public class V2ToV3ConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    private List<String> oldJvmOptions = null;
    private final List<String> newJvmOptions = new ArrayList<String>();
    private static final String[] BASE_REMOVAL_LIST = new String[]{"-Djavax.management.builder.initial", "-Dsun.rmi.dgc.server.gcInterval", "-Dsun.rmi.dgc.client.gcInterval", "-Dcom.sun.enterprise.taglibs", "-Dcom.sun.enterprise.taglisteners", "-XX:LogFile"};
    private static final String[] ADD_LIST = new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+LogVMOutput", "-XX:LogFile=${com.sun.aas.instanceRoot}/logs/jvm.log", "-Djava.awt.headless=true", "-DANTLR_USE_DIRECT_CLASS_LOADING=true", "-Dosgi.shell.telnet.maxconn=1", "-Dosgi.shell.telnet.ip=127.0.0.1", "-Dgosh.args=--noshutdown -c noop=true", "-Dfelix.fileinstall.dir=${com.sun.aas.installRoot}/modules/autostart/", "-Dfelix.fileinstall.poll=5000", "-Dfelix.fileinstall.debug=3", "-Dfelix.fileinstall.bundles.new.start=true", "-Dfelix.fileinstall.bundles.startTransient=true", "-Dfelix.fileinstall.disableConfigSave=false", "-Dfelix.fileinstall.log.level=2", "-Djavax.management.builder.initial=com.sun.enterprise.v3.admin.AppServerMBeanServerBuilder", "-Dorg.glassfish.web.rfc2109_cookie_names_enforced=false"};
    private static final String[] ADD_LIST_DAS = new String[]{"-Dosgi.shell.telnet.port=6666"};
    private static final String[] ADD_LIST_NOT_DAS = new String[]{"-Dosgi.shell.telnet.port=${OSGI_SHELL_TELNET_PORT}"};
    private static final List<String> REMOVAL_LIST = new ArrayList<String>();

    public Collection<JavaConfig> getJavaConfigs() {
        ArrayList<JavaConfig> result = new ArrayList<JavaConfig>();
        for (Config c : this.configs.getConfig()) {
            if (c.getJavaConfig() == null) continue;
            result.add(c.getJavaConfig());
        }
        return result;
    }

    public void postConstruct() {
        if (this.configs == null || this.configs.getConfig() == null || this.configs.getConfig().isEmpty()) {
            return;
        }
        try {
            for (Config c : this.configs.getConfig()) {
                JavaConfig jc = c.getJavaConfig();
                if (jc == null) continue;
                this.newJvmOptions.clear();
                this.oldJvmOptions = Collections.unmodifiableList(jc.getJvmOptions());
                this.doAdditions("server-config".equals(c.getName()));
                this.doRemovals();
                ConfigSupport.apply((SingleConfigCode)new JavaConfigChanger(), (ConfigBeanProxy)jc);
            }
        }
        catch (Exception e) {
            SLogger.getLogger().log(Level.SEVERE, "NCLS-SRVRMGMT-00004", e);
            throw new RuntimeException(e);
        }
    }

    private void doRemovals() {
        for (String s : this.oldJvmOptions) {
            if (this.shouldRemove(s)) continue;
            this.newJvmOptions.add(s);
        }
    }

    private void doAdditions(boolean isDas) {
        this.doAdditionsFrom(ADD_LIST);
        if (isDas) {
            this.doAdditionsFrom(ADD_LIST_DAS);
        } else {
            this.doAdditionsFrom(ADD_LIST_NOT_DAS);
        }
    }

    private void doAdditionsFrom(String[] strings) {
        this.newJvmOptions.addAll(Arrays.asList(strings));
    }

    private boolean shouldRemove(String option) {
        if (!this.ok(option)) {
            return true;
        }
        for (String s : REMOVAL_LIST) {
            if (!option.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        Collections.addAll(REMOVAL_LIST, BASE_REMOVAL_LIST);
        Collections.addAll(REMOVAL_LIST, ADD_LIST);
    }

    private class JavaConfigChanger
    implements SingleConfigCode<JavaConfig> {
        private JavaConfigChanger() {
        }

        public Object run(JavaConfig jc) throws PropertyVetoException, TransactionFailure {
            jc.setJvmOptions(V2ToV3ConfigUpgrade.this.newJvmOptions);
            return jc;
        }
    }
}

