/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;
import org.glassfish.web.loader.WebappClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.TCCLSingletonProvider;

public class ACLSingletonProvider
extends SingletonProvider {
    public static void initializeSingletonProvider() {
        boolean earSupport;
        try {
            Class.forName("org.glassfish.javaee.full.deployment.EarClassLoader");
            earSupport = true;
        }
        catch (ClassNotFoundException ignore) {
            earSupport = false;
        }
        SingletonProvider.initialize((SingletonProvider)(earSupport ? new ACLSingletonProvider() : new TCCLSingletonProvider()));
    }

    public <T> ACLSingleton<T> create(Class<? extends T> expectedType) {
        return new ACLSingleton();
    }

    private static class ACLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new Hashtable<ClassLoader, T>();
        private final ClassLoader commonClassLoader = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
        private static ClassLoader bootstrapCL = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Object.class.getClassLoader();
            }
        }) : Object.class.getClassLoader();

        private ACLSingleton() {
        }

        public T get(String id) {
            ClassLoader appClassLoader = this.getClassLoader();
            T instance = this.store.get(appClassLoader);
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + String.valueOf(appClassLoader));
            }
            return instance;
        }

        private ClassLoader getClassLoader() {
            ClassLoader contextClassLoader;
            ClassLoader classLoader = contextClassLoader = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw new RuntimeException("Thread's context class loader is null");
            }
            ClassLoader classLoader2 = contextClassLoader;
            ClassLoader appClassLoader = contextClassLoader;
            while (classLoader2 != this.commonClassLoader && classLoader2 != bootstrapCL) {
                if (classLoader2 instanceof EarLibClassLoader) {
                    return classLoader2;
                }
                if (classLoader2 instanceof WebappClassLoader) {
                    appClassLoader = classLoader2;
                }
                classLoader2 = this.getParent(classLoader2);
            }
            return appClassLoader;
        }

        private ClassLoader getParent(final ClassLoader classLoader) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return classLoader.getParent();
                }
            }) : classLoader.getParent();
        }

        public boolean isSet(String id) {
            return this.store.containsKey(this.getClassLoader());
        }

        public void set(String id, T object) {
            this.store.put(this.getClassLoader(), object);
        }

        public void clear(String id) {
            this.store.remove(this.getClassLoader());
        }
    }
}

