/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee.loader;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.j2ee.DASJ2EEServerImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEDomainImpl;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.j2ee.AMXEELoggerInfo;
import org.glassfish.admin.amx.j2ee.J2EEDomain;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.api.amx.AMXLoader;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public final class AMXJ2EEStartupService
implements PostConstruct,
PreDestroy,
AMXLoader,
ConfigListener {
    @Inject
    private MBeanServer mMBeanServer;
    @Inject
    InjectedValues mCore;
    @Inject
    private Domain domain;
    private static final Logger logger = AMXEELoggerInfo.getLogger();
    @Inject
    ServiceLocator mHabitat;
    @Inject
    private ApplicationRegistry mAppsRegistry;

    public InjectedValues getCore() {
        return this.mCore;
    }

    public ApplicationRegistry getApplicationRegistry() {
        return this.mAppsRegistry;
    }

    public void postConstruct() {
        this.addListenerToServer();
    }

    private void addListenerToServer() {
        Servers servers = this.domain.getServers();
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)servers);
        bean.addListener((ConfigListener)this);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])propertyChangeEvents, (Changed)new PropertyChangeHandler(propertyChangeEvents), (Logger)logger);
    }

    public void preDestroy() {
        this.unloadAMXMBeans();
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy();
    }

    public ObjectName getJ2EEDomain() {
        return this.getDomainRootProxy().child("J2EEDomain").extra().objectName();
    }

    private J2EEDomain getJ2EEDomainProxy() {
        return ProxyFactory.getInstance(this.mMBeanServer).getProxy(this.getJ2EEDomain(), J2EEDomain.class);
    }

    public synchronized ObjectName loadAMXMBeans() {
        FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", String.valueOf(this));
        FeatureAvailability.getInstance().waitForFeature("AMXConfigReady", String.valueOf(this));
        DomainRoot domainRootProxy = ProxyFactory.getInstance(this.mMBeanServer).getDomainRootProxy(false);
        ObjectName domainRoot = domainRootProxy.objectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.mMBeanServer, domainRoot);
        MetadataImpl metadata = new MetadataImpl();
        metadata.add("Config", ConfigBeanRegistry.getInstance().getObjectNameForProxy((ConfigBeanProxy)this.domain));
        String serverName = ((Server)this.mHabitat.getService(Server.class, new Annotation[0])).getName();
        J2EEDomainImpl impl = new J2EEDomainImpl(domainRoot, metadata);
        impl.setServerName(serverName);
        ObjectName objectName = objectNames.buildChildObjectName(J2EEDomain.class);
        try {
            objectName = this.mMBeanServer.registerMBean(impl, objectName).getObjectName();
        }
        catch (JMException e) {
            throw new Error(e);
        }
        logger.log(Level.INFO, "AS-AMXEE-006", objectName);
        return objectName;
    }

    public synchronized void unloadAMXMBeans() {
        J2EEDomain j2eeDomain = this.getJ2EEDomainProxy();
        if (j2eeDomain != null) {
            ImplUtil.unregisterAMXMBeans(j2eeDomain);
        }
    }

    class PropertyChangeHandler
    implements Changed {
        private PropertyChangeHandler(PropertyChangeEvent[] events) {
        }

        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            switch (type) {
                case ADD: {
                    if (!(changedInstance instanceof Server)) break;
                    Server server = (Server)changedInstance;
                    String serverName = server.getName();
                    MetadataImpl meta = new MetadataImpl();
                    meta.setCorrespondingConfig(ConfigBeanRegistry.getInstance().getObjectNameForProxy((ConfigBeanProxy)server));
                    DASJ2EEServerImpl impl = new DASJ2EEServerImpl(AMXJ2EEStartupService.this.getJ2EEDomain(), meta);
                    ObjectName serverObjectName = new ObjectNameBuilder(AMXJ2EEStartupService.this.mMBeanServer, AMXJ2EEStartupService.this.getJ2EEDomain()).buildChildObjectName("J2EEServer", serverName);
                    try {
                        ObjectName objectName = AMXJ2EEStartupService.this.mMBeanServer.registerMBean(impl, serverObjectName).getObjectName();
                        break;
                    }
                    catch (JMException e) {
                        throw new Error(e);
                    }
                }
                case REMOVE: {
                    if (!(changedInstance instanceof Server)) break;
                    Server server = (Server)changedInstance;
                    String serverName = server.getName();
                    ObjectName serverObjectName = new ObjectNameBuilder(AMXJ2EEStartupService.this.mMBeanServer, AMXJ2EEStartupService.this.getJ2EEDomain()).buildChildObjectName("J2EEServer", serverName);
                    try {
                        Set<ObjectName> serverSet = AMXJ2EEStartupService.this.mMBeanServer.queryNames(new ObjectName(serverObjectName.toString() + ",*"), null);
                        for (ObjectName element : serverSet) {
                            AMXJ2EEStartupService.this.mMBeanServer.unregisterMBean(element);
                        }
                        break;
                    }
                    catch (JMException e) {
                        throw new Error(e);
                    }
                }
            }
            return null;
        }
    }
}

