/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.JavaSystemJschLogger;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Service;

@Service(name="SSHLauncher")
@PerLookup
public class SSHLauncher {
    private static final String SSH_DIR_NAME = ".ssh";
    private static final String AUTH_KEY_FILE = "authorized_keys";
    private static final int DEFAULT_TIMEOUT_MSEC = 120000;
    private static final String SSH_KEYGEN = "ssh-keygen";
    private static final char LINE_SEP = System.getProperty("line.separator").charAt(0);
    private String host;
    private int port;
    private String userName;
    private File keyFile;
    private Session session;
    private String authType;
    private String keyPassPhrase;
    private String knownHostsLocation;
    private Logger logger;
    private String password;
    private String rawPassword = null;
    private String rawKeyPassPhrase = null;

    public void init(Logger logger) {
        this.logger = logger;
    }

    public void init(Node node, Logger logger) {
        int port;
        String sshHost;
        this.logger = logger;
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Connecting to host " + host);
        }
        if ((sshHost = connector.getSshHost()) != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = new File(sshAuth.getKeyfile());
            this.rawPassword = sshAuth.getPassword();
            this.rawKeyPassPhrase = sshAuth.getKeyPassphrase();
        }
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.init(userName, this.host, port, this.rawPassword, this.keyFile, this.rawKeyPassPhrase, logger);
    }

    public void init(String userName, String host, int port, String password, File keyFile, String keyPassPhrase, Logger logger) {
        this.port = port == 0 ? 22 : port;
        this.host = host;
        this.keyFile = keyFile == null ? SSHUtil.getExistingKeyFile() : keyFile;
        this.logger = logger;
        this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        this.rawPassword = password;
        this.password = this.expandPasswordAlias(password);
        this.rawKeyPassPhrase = keyPassPhrase;
        this.keyPassPhrase = this.expandPasswordAlias(keyPassPhrase);
        File knownHosts = FileUtils.USER_HOME.toPath().resolve(Path.of(SSH_DIR_NAME, "known_hosts")).toFile();
        if (knownHosts.exists()) {
            this.knownHostsLocation = knownHosts.getAbsolutePath();
        }
        logger.log(Level.FINER, "SSH info is {0}", this);
    }

    private void openConnection() throws JSchException {
        assert (this.session == null);
        JSch jsch = new JSch();
        JSch.setLogger(new JavaSystemJschLogger((String)(this.logger != null ? this.logger.getName() + SSH_DIR_NAME : JSch.class.getName())));
        Object message = "";
        boolean triedAuthentication = false;
        if (this.keyFile != null) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Specified key file is " + String.valueOf(this.keyFile));
            }
            if (this.keyFile.exists()) {
                triedAuthentication = true;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Specified key file exists at " + String.valueOf(this.keyFile));
                }
                jsch.addIdentity(this.keyFile.getAbsolutePath(), this.keyPassPhrase);
            } else {
                message = "Specified key file does not exist \n";
            }
        } else if (SSHUtil.checkString(this.password) == null) {
            message = (String)message + "No key or password specified - trying default keys \n";
            this.logger.fine("keyfile and password are null. Will try to authenticate with default key file if available");
            Path home = FileUtils.USER_HOME.toPath();
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                message = (String)message + "Tried to authenticate using " + keyName + "\n";
                File key = home.resolve(Path.of(SSH_DIR_NAME, keyName)).toFile();
                if (!key.exists()) continue;
                triedAuthentication = true;
                jsch.addIdentity(key.getAbsolutePath());
            }
        }
        this.session = jsch.getSession(this.userName, this.host, this.port);
        this.session.setConfig("StrictHostKeyChecking", "no");
        if (SSHUtil.checkString(this.password) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Authenticating with password " + this.getPrintablePassword(this.password));
            }
            triedAuthentication = true;
            this.session.setPassword(this.password);
        }
        if (!triedAuthentication) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not authenticate");
            }
            throw new JSchException("Could not authenticate. " + (String)message);
        }
        SSHUtil.register(this.session);
        this.session.connect();
    }

    public int runCommand(List<String> command, OutputStream os, List<String> stdinLines) throws JSchException, IOException, InterruptedException {
        return this.runCommand(SSHLauncher.commandListToQuotedString(command), os, stdinLines);
    }

    public int runCommand(List<String> command, OutputStream os) throws JSchException, IOException, InterruptedException {
        return this.runCommand(command, os, null);
    }

    public int runCommand(String command, OutputStream os) throws JSchException, IOException, InterruptedException {
        return this.runCommand(command, os, null);
    }

    public int runCommand(String command, OutputStream os, List<String> stdinLines) throws JSchException, IOException, InterruptedException {
        command = SFTPClient.normalizePath(command);
        return this.runCommandAsIs(command, os, stdinLines);
    }

    public int runCommandAsIs(List<String> command, OutputStream os, List<String> stdinLines) throws JSchException, IOException, InterruptedException {
        return this.runCommandAsIs(SSHLauncher.commandListToQuotedString(command), os, stdinLines);
    }

    private int runCommandAsIs(String command, OutputStream os, List<String> stdinLines) throws JSchException, IOException, InterruptedException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Running command " + command + " on host: " + this.host);
        }
        boolean createNewSession = false;
        if (this.session == null) {
            createNewSession = true;
        }
        if (createNewSession) {
            this.openConnection();
        }
        int status = this.exec(command, os, this.listInputStream(stdinLines));
        if (createNewSession) {
            SSHUtil.unregister(this.session);
            this.session = null;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(String command, OutputStream os, InputStream is) throws JSchException, IOException, InterruptedException {
        ChannelExec execChannel = (ChannelExec)this.session.openChannel("exec");
        try {
            execChannel.setInputStream(is);
            execChannel.setCommand(command);
            InputStream in = execChannel.getInputStream();
            execChannel.connect();
            PumpThread t1 = new PumpThread(in, os);
            t1.start();
            PumpThread t2 = new PumpThread(execChannel.getErrStream(), os);
            t2.start();
            t1.join();
            t2.join();
            int n = execChannel.getExitStatus();
            return n;
        }
        finally {
            execChannel.disconnect();
        }
    }

    private int exec(String command, OutputStream os) throws JSchException, IOException, InterruptedException {
        return this.exec(command, os, null);
    }

    private InputStream listInputStream(List<String> stdinLines) throws IOException {
        if (stdinLines == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String line : stdinLines) {
            baos.write(line.getBytes());
            baos.write(LINE_SEP);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void pingConnection() throws JSchException, InterruptedException {
        this.logger.fine("Pinging connection for host: " + this.host);
        this.openConnection();
        SSHUtil.unregister(this.session);
        this.session = null;
    }

    public void validate(String host, int port, String userName, String password, File keyFile, String keyPassPhrase, String installDir, String landmarkPath, Logger logger) throws IOException {
        boolean validInstallDir = false;
        this.init(userName, host, port, password, keyFile, keyPassPhrase, logger);
        try {
            this.openConnection();
            logger.fine("Connection settings valid");
            Object testPath = installDir;
            if (StringUtils.ok((String)testPath)) {
                SFTPClient sftpClient = new SFTPClient(this.session);
                if (sftpClient.exists((String)testPath)) {
                    if (StringUtils.ok((String)landmarkPath)) {
                        testPath = installDir + "/" + landmarkPath;
                    }
                    validInstallDir = sftpClient.exists((String)testPath);
                } else {
                    validInstallDir = false;
                }
                SSHUtil.unregister(this.session);
                this.session = null;
                if (!validInstallDir) {
                    String msg = "Invalid install directory: could not find " + (String)testPath + " on " + host;
                    throw new FileNotFoundException(msg);
                }
                logger.fine("Node home validated");
            }
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
        catch (SftpException ex) {
            throw new IOException(ex);
        }
    }

    public SFTPClient getSFTPClient() throws JSchException {
        this.openConnection();
        return new SFTPClient(this.session);
    }

    public String expandPasswordAlias(String alias) {
        String expandedPassword = null;
        if (alias == null) {
            return null;
        }
        try {
            expandedPassword = RelativePathResolver.getRealPasswordFromAlias((String)alias);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Expansion failed for {0}: {1}", new Object[]{alias, e.getMessage()});
            return null;
        }
        return expandedPassword;
    }

    public boolean isPasswordAlias(String alias) {
        String aliasName = RelativePathResolver.getAlias((String)alias);
        return aliasName != null;
    }

    private String getPrintablePassword(String p) {
        String printable = "null";
        if (p != null) {
            printable = this.isPasswordAlias(p) ? p : "<concealed>";
        }
        return printable;
    }

    public void setupKey(String node, String pubKeyFile, boolean generateKey, String passwd) throws IOException, InterruptedException {
        block29: {
            File key = this.keyFile;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Key = " + String.valueOf(this.keyFile));
            }
            if (key.exists()) {
                if (this.checkConnection()) {
                    throw new IOException("SSH public key authentication is already configured for " + this.userName + "@" + node);
                }
            } else if (generateKey) {
                if (!this.generateKeyPair()) {
                    throw new IOException("SSH key pair generation failed. Please generate key manually.");
                }
            } else {
                throw new IOException("SSH key pair not present. Please generate a key pair manually or specify an existing one and re-run the command.");
            }
            if (passwd == null) {
                throw new IOException("SSH password is required for distributing the public key. You can specify the SSH password in a password file and pass it through --passwordfile option.");
            }
            try {
                JSch jsch = new JSch();
                Session s1 = jsch.getSession(this.userName, this.host, this.port);
                s1.setConfig("StrictHostKeyChecking", "no");
                s1.setPassword(passwd);
                s1.connect();
                if (!s1.isConnected()) {
                    throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
                }
                try (SFTPClient sftp = new SFTPClient(s1);){
                    File pubKey;
                    ChannelSftp sftpChannel = sftp.getSftpChannel();
                    this.session = s1;
                    if (!key.exists()) break block29;
                    this.setupSSHDir();
                    if (pubKeyFile == null) {
                        pubKeyFile = String.valueOf(this.keyFile) + ".pub";
                    }
                    if (!(pubKey = new File((String)pubKeyFile)).exists()) {
                        throw new IOException("Public key file " + (String)pubKeyFile + " does not exist.");
                    }
                    try {
                        if (!sftp.exists(SSH_DIR_NAME)) {
                            this.logger.fine(".ssh does not exist");
                            sftpChannel.cd(sftpChannel.getHome());
                            sftpChannel.mkdir(SSH_DIR_NAME);
                            sftpChannel.chmod(448, SSH_DIR_NAME);
                        }
                    }
                    catch (Exception e) {
                        throw new IOException("Error while creating .ssh directory on remote host: " + e.getMessage(), e);
                    }
                    try {
                        sftpChannel.cd(SSH_DIR_NAME);
                        sftpChannel.put(pubKey.getAbsolutePath(), "key.tmp");
                        sftpChannel.chmod(384, "key.tmp");
                    }
                    catch (SftpException ex) {
                        throw new IOException("Unable to copy the public key", ex);
                    }
                    String mergeCommand = "cd .ssh; cat key.tmp >> authorized_keys";
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("mergeCommand = " + mergeCommand);
                    }
                    if (this.exec(mergeCommand, new ByteArrayOutputStream()) != 0) {
                        throw new IOException("Failed to propogate the public key " + (String)pubKeyFile + " to " + this.host);
                    }
                    this.logger.info("Copied keyfile " + (String)pubKeyFile + " to " + this.userName + "@" + this.host);
                    if (this.exec("rm .ssh/key.tmp", new ByteArrayOutputStream()) != 0) {
                        this.logger.warning("WARNING: Failed to remove the public key file key.tmp on remote host " + this.host);
                    }
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Removed the temporary key file on remote host");
                    }
                    this.logger.info("Fixing file permissions for home(755), .ssh(700) and authorized_keys file(644)");
                    try {
                        sftpChannel.cd(sftpChannel.getHome());
                        sftpChannel.chmod(493, ".");
                        sftpChannel.chmod(448, SSH_DIR_NAME);
                        sftpChannel.chmod(420, ".ssh/authorized_keys");
                    }
                    catch (SftpException ex) {
                        throw new IOException("Unable to fix file permissions", ex);
                    }
                }
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) >= 0) {
            output.write(buf, 0, len);
        }
        byte[] o = output.toByteArray();
        output.close();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        boolean status = false;
        JSch jsch = new JSch();
        Session sess = null;
        try {
            this.logger.finer("Checking connection...");
            jsch.addIdentity(this.keyFile.getAbsolutePath(), this.rawKeyPassPhrase);
            sess = jsch.getSession(this.userName, this.host, this.port);
            sess.setConfig("StrictHostKeyChecking", "no");
            sess.connect();
            status = sess.isConnected();
            if (status) {
                this.logger.info("Successfully connected to " + this.userName + "@" + this.host + " using keyfile " + String.valueOf(this.keyFile));
            }
        }
        catch (JSchException ex) {
            Throwable t = ex.getCause();
            if (t != null) {
                String msg = t.getMessage();
                this.logger.warning("Failed to connect or authenticate: " + msg);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Failed to connect or autheticate: ", ex);
            }
        }
        finally {
            if (sess != null) {
                sess.disconnect();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPasswordAuth() {
        boolean status = false;
        JSch jsch = new JSch();
        Session sess = null;
        try {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Checking connection...");
            }
            sess = jsch.getSession(this.userName, this.host, this.port);
            sess.setConfig("StrictHostKeyChecking", "no");
            sess.setPassword(this.password);
            sess.connect();
            status = sess.isConnected();
            if (status && this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Successfully connected to " + this.userName + "@" + this.host + " using password authentication");
            }
        }
        catch (JSchException ex) {
            Throwable t = ex.getCause();
            if (t != null) {
                String msg = t.getMessage();
                this.logger.warning("Failed to connect or authenticate: " + msg);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Failed to connect or autheticate: ", ex);
            }
        }
        finally {
            if (sess != null) {
                sess.disconnect();
            }
        }
        return status;
    }

    private boolean generateKeyPair() throws IOException {
        int exit;
        String keygenCmd = this.findSSHKeygen();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Using " + keygenCmd + " to generate key pair");
        }
        if (!this.setupSSHDir()) {
            throw new IOException("Failed to set proper permissions on .ssh directory");
        }
        StringBuffer k = new StringBuffer();
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(keygenCmd);
        k.append(keygenCmd);
        cmdLine.add("-t");
        k.append(" ").append("-t");
        cmdLine.add("rsa");
        k.append(" ").append("rsa");
        cmdLine.add("-N");
        k.append(" ").append("-N");
        if (this.rawKeyPassPhrase != null && this.rawKeyPassPhrase.length() > 0) {
            cmdLine.add(this.rawKeyPassPhrase);
            k.append(" ").append(this.getPrintablePassword(this.rawKeyPassPhrase));
        } else if (OS.isWindows()) {
            cmdLine.add("\"\"");
            k.append(" ").append("\"\"");
        } else {
            cmdLine.add("");
            k.append(" ").append("");
        }
        cmdLine.add("-f");
        k.append(" ").append("-f");
        cmdLine.add(this.keyFile.getAbsolutePath());
        k.append(" ").append(this.keyFile);
        ProcessManager pm = new ProcessManager(cmdLine);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Command = " + String.valueOf(k));
        }
        pm.setTimeoutMsec(120000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing ssh-keygen: " + ex.getMessage());
            }
            exit = 1;
        }
        if (exit == 0) {
            this.logger.info(keygenCmd + " successfully generated the identification " + String.valueOf(this.keyFile));
        } else {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(pm.getStderr());
            }
            this.logger.info(keygenCmd + " failed");
        }
        return exit == 0;
    }

    private String findSSHKeygen() {
        File exe;
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList("/usr/bin/", "/usr/local/bin/"));
        if (OS.isWindows()) {
            paths.add("C:/cygwin/bin/");
            String mks = System.getenv("ROOTDIR");
            if (mks != null) {
                paths.add(mks + "/bin/");
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Paths = " + String.valueOf(paths));
        }
        if ((exe = ProcessUtils.getExe((String)SSH_KEYGEN)) != null) {
            return exe.getPath();
        }
        for (String s : paths) {
            File f = new File(s + SSH_KEYGEN);
            if (!f.canExecute()) continue;
            return f.getAbsolutePath();
        }
        return SSH_KEYGEN;
    }

    private boolean setupSSHDir() throws IOException {
        boolean ret = true;
        File f = new File(FileUtils.USER_HOME, SSH_DIR_NAME);
        if (!FileUtils.safeIsDirectory((File)f)) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create " + f.getPath());
            }
            this.logger.log(Level.INFO, "Created directory {0}", f);
        }
        if (!f.setReadable(false, false) || !f.setReadable(true)) {
            ret = false;
        }
        if (!f.setWritable(false, false) || !f.setWritable(true)) {
            ret = false;
        }
        if (!f.setExecutable(false, false) || !f.setExecutable(true)) {
            ret = false;
        }
        this.logger.finer("Fixed the .ssh directory permissions to 0700");
        return ret;
    }

    public String toString() {
        String displayPassword = this.getPrintablePassword(this.rawPassword);
        String displayKeyPassPhrase = this.getPrintablePassword(this.rawKeyPassPhrase);
        return String.format("host=%s port=%d user=%s password=%s keyFile=%s keyPassPhrase=%s authType=%s knownHostFile=%s", this.host, this.port, this.userName, displayPassword, this.keyFile, displayKeyPassPhrase, this.authType, this.knownHostsLocation);
    }

    private static String commandListToQuotedString(List<String> command) {
        if (command.size() == 1) {
            return command.get(0);
        }
        StringBuilder commandBuilder = new StringBuilder();
        boolean first = true;
        for (String s : command) {
            if (!first) {
                commandBuilder.append(" ");
            } else {
                first = false;
            }
            if (s.contains(" ")) {
                commandBuilder.append(FileUtils.quoteString((String)s));
                continue;
            }
            commandBuilder.append(s);
        }
        return commandBuilder.toString();
    }

    private static final class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out) {
            super("pump thread");
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    int len;
                    if ((len = this.in.read(buf)) < 0) {
                        this.in.close();
                        return;
                    }
                    this.out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

