/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.readers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.admin.rest.readers.InputException;
import org.glassfish.admin.rest.readers.InputObject;
import org.glassfish.admin.rest.readers.XmlInputReader;

public class XmlInputObject
extends InputObject {
    public static final Character AMP = Character.valueOf('&');
    public static final Character APOS = Character.valueOf('\'');
    public static final Character BANG = Character.valueOf('!');
    public static final Character EQ = Character.valueOf('=');
    public static final Character GT = Character.valueOf('>');
    public static final Character LT = Character.valueOf('<');
    public static final Character QUEST = Character.valueOf('?');
    public static final Character QUOT = Character.valueOf('\"');
    public static final Character SLASH = Character.valueOf('/');
    private XmlInputReader xmlReader;

    public XmlInputObject(InputStream inputstream) throws InputException, IOException {
        this(XmlInputObject.readAsString(inputstream));
    }

    public XmlInputObject(String source) throws InputException {
        this(new XmlInputReader(source));
    }

    public XmlInputObject(XmlInputReader xmlReader) throws InputException {
        this.xmlReader = xmlReader;
        this.map = new HashMap();
    }

    @Override
    public Map initializeMap() throws InputException {
        while (this.xmlReader.more() && this.xmlReader.skipPast("<")) {
            XmlInputObject.parse(this.xmlReader, this, null);
        }
        return this.map;
    }

    public Map getMap() throws InputException {
        return this.map;
    }

    private static boolean parse(XmlInputReader reader, XmlInputObject context, String name) throws InputException {
        String string;
        Object token = reader.nextToken();
        if (BANG.equals(token)) {
            char character = reader.next();
            if (character == '-') {
                if (reader.next() == '-') {
                    reader.skipPast("-->");
                    return false;
                }
                reader.back();
            } else if (character == '[') {
                token = reader.nextToken();
                if ("CDATA".equals(token) && reader.next() == '[') {
                    String string2 = reader.nextCDATA();
                    if (string2.length() > 0) {
                        context.put("content", string2);
                    }
                    return false;
                }
                throw reader.error("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = reader.nextMeta()) == null) {
                    throw reader.error("Missing '>' after '<!'.");
                }
                if (LT.equals(token)) {
                    ++i;
                    continue;
                }
                if (!GT.equals(token)) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (QUEST.equals(token)) {
            reader.skipPast("?>");
            return false;
        }
        if (SLASH.equals(token)) {
            token = reader.nextToken();
            if (name == null) {
                throw reader.error("Mismatched close tag " + String.valueOf(token));
            }
            if (!name.equals(token)) {
                throw reader.error("Mismatched " + name + " and " + String.valueOf(token));
            }
            if (!GT.equals(reader.nextToken())) {
                throw reader.error("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw reader.error("Misshaped tag");
        }
        String n = (String)token;
        token = null;
        XmlInputObject subContext = new XmlInputObject(reader);
        while (true) {
            if (token == null) {
                token = reader.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = reader.nextToken();
            if (EQ.equals(token)) {
                token = reader.nextToken();
                if (!(token instanceof String)) {
                    throw reader.error("Missing value");
                }
                subContext.put(string, XmlInputObject.stringToValue((String)token));
                token = null;
                continue;
            }
            subContext.put(string, "");
        }
        if (SLASH.equals(token)) {
            if (!reader.nextToken().equals(GT)) {
                throw reader.error("Misshaped tag");
            }
            context.putMap(n, subContext.getMap());
            return false;
        }
        if (GT.equals(token)) {
            while (true) {
                if ((token = reader.nextContent()) == null) {
                    if (n != null) {
                        throw reader.error("Unclosed tag " + n);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    subContext.put("content", XmlInputObject.stringToValue(string));
                    continue;
                }
                if (LT.equals(token) && XmlInputObject.parse(reader, subContext, n)) break;
            }
            if (subContext.length() == 0) {
                context.put(n, "");
            } else if (subContext.length() == 1 && subContext.get("content") != null) {
                context.put(n, subContext.get("content"));
            } else {
                context.putMap(n, subContext.getMap());
            }
            return false;
        }
        throw reader.error("Misshaped tag");
    }
}

