/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class J2EEKeyManager
extends X509ExtendedKeyManager {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private X509KeyManager x509KeyManager;
    private String alias;
    private Map<String, X509KeyManager> tokenName2MgrMap;
    private boolean supportTokenAlias;
    private static final String CLIENT_JAAS_PASSWORD = "default";

    public J2EEKeyManager(X509KeyManager mgr, String alias) {
        this.x509KeyManager = mgr;
        this.alias = alias;
        if (mgr instanceof UnifiedX509KeyManager) {
            UnifiedX509KeyManager umgr = (UnifiedX509KeyManager)mgr;
            X509KeyManager[] mgrs = umgr.getX509KeyManagers();
            String[] tokenNames = umgr.getTokenNames();
            this.tokenName2MgrMap = new HashMap<String, X509KeyManager>();
            for (int i = 0; i < mgrs.length; ++i) {
                if (tokenNames[i] == null) continue;
                this.tokenName2MgrMap.put(tokenNames[i], mgrs[i]);
            }
            this.supportTokenAlias = this.tokenName2MgrMap.size() > 0;
        }
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.x509KeyManager.chooseClientAlias(keyType, issuers, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String clientAlias = null;
        if (this.alias == null) {
            if (Util.getInstance().isNotServerOrACC()) {
                clientAlias = this.x509KeyManager.chooseClientAlias(keyType, issuers, socket);
            } else if (Util.getInstance().isACC()) {
                ClientSecurityContext ctx = ClientSecurityContext.getCurrent();
                Subject s = ctx.getSubject();
                if (s == null) {
                    J2EEKeyManager.doClientLogin(2, Util.getInstance().getCallbackHandler());
                    s = ctx.getSubject();
                }
                for (Object o : s.getPrivateCredentials()) {
                    if (!(o instanceof X509CertificateCredential)) continue;
                    X509CertificateCredential crt = (X509CertificateCredential)o;
                    clientAlias = crt.getAlias();
                    break;
                }
            }
        } else {
            clientAlias = this.alias;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choose client Alias :{0}", clientAlias);
        }
        return clientAlias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String serverAlias = null;
        serverAlias = this.alias != null ? this.alias : this.x509KeyManager.chooseServerAlias(keyType, issuers, socket);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choosing server alias :{0}", serverAlias);
        }
        return serverAlias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        _logger.log(Level.FINE, "Getting certificate chain");
        X509KeyManager keyMgr = this.getManagerFromToken(alias);
        if (keyMgr != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getCertificateChain(aliasName);
        }
        return this.x509KeyManager.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting client aliases");
        }
        return this.x509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting server aliases");
        }
        return this.x509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        X509KeyManager keyMgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting private key for alias:{0}", alias);
        }
        if ((keyMgr = this.getManagerFromToken(alias)) != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getPrivateKey(aliasName);
        }
        return this.x509KeyManager.getPrivateKey(alias);
    }

    private X509KeyManager getManagerFromToken(String tokenAlias) {
        X509KeyManager keyMgr = null;
        int ind = -1;
        if (this.supportTokenAlias && tokenAlias != null && (ind = tokenAlias.indexOf(58)) != -1) {
            String tokenName = this.alias.substring(0, ind);
            keyMgr = this.tokenName2MgrMap.get(tokenName);
        }
        return keyMgr;
    }

    public static Subject doClientLogin(int type, CallbackHandler jaasHandler) throws com.sun.enterprise.security.auth.login.common.LoginException {
        final CallbackHandler handler = jaasHandler;
        final Subject subject = new Subject();
        if (type == 1) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                        lg.login();
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type == 2) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext("certificate", subject, handler);
                        lg.login();
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type == 3) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lgup = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                        LoginContext lgc = new LoginContext("certificate", subject, handler);
                        lgup.login();
                        J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
                        lgc.login();
                        J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            return subject;
        }
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LoginContext lg = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                    lg.login();
                    J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
                }
                catch (LoginException e) {
                    throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                }
                return null;
            }
        });
        return subject;
    }

    private static void postClientAuth(Subject subject, Class<?> clazz) {
        final Class<?> clas = clazz;
        final Subject fs = subject;
        Set credset = AppservAccessController.doPrivileged(new PrivilegedAction<Set>(){

            @Override
            public Set run() {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "LCD post login subject :{0}", fs);
                }
                return fs.getPrivateCredentials(clas);
            }
        });
        final Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            Object obj = null;
            try {
                obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-SECURITY-05043", e);
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p = obj;
                String user = p.getUser();
                if (_logger.isLoggable(Level.FINEST)) {
                    String realm = p.getRealm();
                    _logger.log(Level.FINEST, "In LCD user-pass login:{0} realm :{1}", new Object[]{user, realm});
                }
                J2EEKeyManager.setClientSecurityContext(user, fs);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            X509CertificateCredential p = obj;
            String user = p.getAlias();
            if (_logger.isLoggable(Level.FINEST)) {
                String realm = p.getRealm();
                _logger.log(Level.FINEST, "In LCD cert-login::{0} realm :{1}", new Object[]{user, realm});
            }
            J2EEKeyManager.setClientSecurityContext(user, fs);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext.setCurrent(new ClientSecurityContext(username, subject));
    }
}

