/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.rm.ResourceManagerImpl;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;

public class LazyEnlistableResourceManagerImpl
extends ResourceManagerImpl {
    private static final Logger LOG = LogDomains.getLogger(LazyEnlistableResourceManagerImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");

    @Override
    protected void enlist(JavaEETransactionManager tm, Transaction transaction, ResourceHandle h) {
    }

    @Override
    public void registerResource(ResourceHandle handle) throws PoolingException {
        handle.setEnlistmentSuspended(true);
        super.registerResource(handle);
    }

    public void lazyEnlist(ManagedConnection managedConnection) throws ResourceException {
        LOG.fine("Entering lazyEnlist");
        JavaEETransactionManager transactionManager = ConnectorRuntime.getRuntime().getTransactionManager();
        Transaction transaction = null;
        try {
            transaction = transactionManager.getTransaction();
            if (transaction == null) {
                LOG.fine(" Transaction null - not enlisting ");
                return;
            }
        }
        catch (SystemException se) {
            throw new ResourceException(se.getMessage(), (Throwable)se);
        }
        List invList = ConnectorRuntime.getRuntime().getInvocationManager().getAllInvocations();
        ResourceHandle resourceHandle = null;
        block4: for (int j = invList.size(); j > 0; --j) {
            ComponentInvocation componentInvocation = (ComponentInvocation)invList.get(j - 1);
            Object comp = componentInvocation.getInstance();
            List l = transactionManager.getResourceList(comp, componentInvocation);
            ListIterator it = l.listIterator();
            while (it.hasNext()) {
                ResourceHandle hand = (ResourceHandle)it.next();
                ManagedConnection toEnlist = (ManagedConnection)hand.getResource();
                if (!managedConnection.equals((Object)toEnlist)) continue;
                resourceHandle = hand;
                continue block4;
            }
        }
        if (resourceHandle != null && resourceHandle.getResourceState().isUnenlisted()) {
            try {
                resourceHandle.setEnlistmentSuspended(false);
                transactionManager.enlistResource(transaction, (TransactionalResource)resourceHandle);
                resourceHandle.setEnlistmentSuspended(true);
            }
            catch (Exception e) {
                ConnectorRuntime.getRuntime().getPoolManager().putbackDirectToPool(resourceHandle, resourceHandle.getResourceSpec().getPoolInfo());
                LOG.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn", resourceHandle.getResourceSpec().getPoolInfo());
                LOG.fine("rm.enlistResource threw Exception. Returning resource to pool");
                throw new ResourceException((Throwable)e);
            }
        }
    }
}

