/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.Map;

public class PageSessionResolver
extends ELResolver {
    public static final String PAGE_SESSION = "pageSession";

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        FacesContext facesContext = (FacesContext)elContext.getContext(FacesContext.class);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map<String, Serializable> pageSession = PageSessionResolver.getPageSession(facesContext, viewRoot);
        Object value = null;
        if (property.equals(PAGE_SESSION)) {
            if (pageSession == null) {
                pageSession = PageSessionResolver.createPageSession(facesContext, viewRoot);
            }
            value = pageSession;
        } else if (pageSession != null) {
            value = pageSession.get(property.toString());
        }
        if (value != null || pageSession != null && pageSession.containsKey(property.toString())) {
            elContext.setPropertyResolved(true);
        }
        return value;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        PageSessionResolver.checkPropertyFound(base, property);
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        UIViewRoot viewRoot;
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        FacesContext facesContext = (FacesContext)elContext.getContext(FacesContext.class);
        Map<String, Serializable> pageSession = PageSessionResolver.getPageSession(facesContext, viewRoot = facesContext.getViewRoot());
        if (pageSession != null) {
            pageSession.put(property.toString(), (Serializable)value);
        }
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        PageSessionResolver.checkPropertyFound(base, property);
        return false;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return base == null ? String.class : null;
    }

    public static Map<String, Serializable> getPageSession(FacesContext facesContext, UIViewRoot viewRoot) {
        if (viewRoot == null) {
            viewRoot = facesContext.getViewRoot();
        }
        return viewRoot.getViewMap(false);
    }

    public static Map<String, Serializable> createPageSession(FacesContext facesContext, UIViewRoot viewRoot) {
        if (viewRoot == null) {
            viewRoot = facesContext.getViewRoot();
        }
        return (Map)Map.class.cast(viewRoot.getViewMap());
    }

    private static void checkPropertyFound(Object base, Object property) {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
    }
}

