/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.monitoring.JdbcRAConstants;
import com.sun.gjc.monitoring.SQLTraceProbeProvider;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.api.naming.SimpleJndiName;

public class SQLTraceDelegator
implements SQLTraceListener {
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected List<SQLTraceListener> sqlTraceListenersList;
    private final SimpleJndiName poolName;
    private final String appName;
    private final String moduleName;
    private SQLTraceProbeProvider probeProvider = null;

    public SQLTraceProbeProvider getProbeProvider() {
        return this.probeProvider;
    }

    public SQLTraceDelegator(SimpleJndiName poolName, String appName, String moduleName) {
        this.poolName = poolName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.probeProvider = new SQLTraceProbeProvider();
    }

    public void registerSQLTraceListener(SQLTraceListener listener) {
        if (this.sqlTraceListenersList == null) {
            this.sqlTraceListenersList = new ArrayList<SQLTraceListener>();
        }
        this.sqlTraceListenersList.add(listener);
    }

    public void sqlTrace(SQLTraceRecord record) {
        if (this.sqlTraceListenersList != null) {
            for (SQLTraceListener listener : this.sqlTraceListenersList) {
                try {
                    listener.sqlTrace(record);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.log(Level.FINEST, "exception from one of the SQL trace listeners [" + listener.getClass().getName() + "]", e);
                }
            }
        }
        if (record != null) {
            Object[] params;
            record.setPoolName(this.poolName.toString());
            String methodName = record.getMethodName();
            if (this.isMethodValidForCaching(methodName) && (params = record.getParams()) != null && params.length > 0) {
                Object param;
                String sqlQuery = null;
                int n = 0;
                Object[] objectArray = params;
                int n2 = objectArray.length;
                if (n < n2 && (param = objectArray[n]) instanceof String) {
                    sqlQuery = param.toString();
                }
                if (sqlQuery != null) {
                    this.probeProvider.traceSQLEvent(this.poolName.toString(), this.appName, this.moduleName, sqlQuery);
                }
            }
        }
    }

    private boolean isMethodValidForCaching(String methodName) {
        return JdbcRAConstants.validSqlTracingMethodNames.contains(methodName);
    }
}

