/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.naming;

import java.io.Serializable;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class SimpleJndiName
implements Serializable,
Comparable<SimpleJndiName> {
    private static final long serialVersionUID = -6969478638009057579L;
    public static final String JNDI_CTX_CORBA = "corbaname:";
    public static final String JNDI_CTX_JAVA = "java:";
    public static final String JNDI_CTX_JAVA_APP_NS_ID = "java:app";
    public static final String JNDI_CTX_JAVA_APP = "java:app/";
    public static final String JNDI_CTX_JAVA_APP_ENV = "java:app/env/";
    public static final String JNDI_CTX_JAVA_COMPONENT_NS_ID = "java:comp";
    public static final String JNDI_CTX_JAVA_COMPONENT = "java:comp/";
    public static final String JNDI_CTX_JAVA_COMPONENT_ENV = "java:comp/env/";
    public static final String JNDI_CTX_JAVA_MODULE_NS_ID = "java:module";
    public static final String JNDI_CTX_JAVA_MODULE = "java:module/";
    public static final String JNDI_CTX_JAVA_MODULE_ENV = "java:module/env/";
    public static final String JNDI_CTX_JAVA_GLOBAL_NS_ID = "java:global";
    public static final String JNDI_CTX_JAVA_GLOBAL = "java:global/";
    private final String jndiName;

    public SimpleJndiName(String jndiName) {
        if (!SimpleJndiName.isValidJndiName(jndiName)) {
            throw new IllegalArgumentException("Invalid JNDI name: '" + jndiName + "'. The JNDI name must not be null.");
        }
        this.jndiName = jndiName;
    }

    public boolean hasJavaPrefix() {
        return this.jndiName.startsWith(JNDI_CTX_JAVA);
    }

    public boolean hasCorbaPrefix() {
        return this.jndiName.startsWith(JNDI_CTX_CORBA);
    }

    public boolean isJavaGlobal() {
        return this.jndiName.startsWith(JNDI_CTX_JAVA_GLOBAL_NS_ID);
    }

    public boolean isJavaApp() {
        return this.jndiName.startsWith(JNDI_CTX_JAVA_APP_NS_ID);
    }

    public boolean isJavaModule() {
        return this.jndiName.startsWith(JNDI_CTX_JAVA_MODULE_NS_ID);
    }

    public boolean isJavaComponent() {
        return this.jndiName.startsWith(JNDI_CTX_JAVA_COMPONENT_NS_ID);
    }

    @Override
    public int compareTo(SimpleJndiName other) {
        return other == null ? -1 : this.jndiName.compareTo(other.jndiName);
    }

    public int hashCode() {
        return this.jndiName.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SimpleJndiName && this.jndiName.equals(((SimpleJndiName)object).jndiName);
    }

    public boolean isEmpty() {
        return this.jndiName.isEmpty();
    }

    public boolean contains(String part) {
        return this.jndiName.contains(part);
    }

    public String getPrefix() {
        if (this.hasCorbaPrefix()) {
            return null;
        }
        int colonIndex = this.jndiName.indexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        int slashIndex = this.jndiName.indexOf(47, colonIndex + 1);
        if (slashIndex == -1) {
            if (this.isKnownNamespaceId()) {
                return this.jndiName;
            }
            return this.jndiName.substring(0, colonIndex + 1);
        }
        if (this.jndiName.charAt(slashIndex + 1) == '/') {
            return this.jndiName.substring(0, slashIndex + 2);
        }
        return this.jndiName.substring(0, slashIndex + 1);
    }

    public boolean hasPrefix(String prefix) {
        return this.jndiName.startsWith(prefix);
    }

    public boolean hasSuffix(String suffix) {
        return this.jndiName.endsWith(suffix);
    }

    public SimpleJndiName removePrefix(String prefix) {
        if (prefix == null) {
            return this;
        }
        if (this.jndiName.startsWith(prefix)) {
            return new SimpleJndiName(this.jndiName.substring(prefix.length()));
        }
        return this;
    }

    public SimpleJndiName removePrefix() {
        if (this.hasCorbaPrefix()) {
            return this;
        }
        int colonIndex = this.jndiName.indexOf(58);
        if (colonIndex == -1) {
            return this;
        }
        int slashIndex = this.jndiName.indexOf(47, colonIndex + 1);
        if (slashIndex == -1) {
            if (this.isKnownNamespaceId()) {
                return new SimpleJndiName("");
            }
            return new SimpleJndiName(this.jndiName.substring(colonIndex + 1));
        }
        if (this.jndiName.charAt(slashIndex + 1) == '/') {
            return new SimpleJndiName(this.jndiName.substring(slashIndex + 2));
        }
        return new SimpleJndiName(this.jndiName.substring(slashIndex + 1));
    }

    public SimpleJndiName changePrefix(String newPrefix) throws IllegalArgumentException {
        if (this.hasCorbaPrefix()) {
            return this;
        }
        char lastChar = newPrefix.charAt(newPrefix.length() - 1);
        if (lastChar != ':' && lastChar != '/') {
            throw new IllegalArgumentException("The new prefix doesn't end with colon nor slash character: " + newPrefix);
        }
        SimpleJndiName noPrefix = this.removePrefix();
        return new SimpleJndiName(newPrefix + noPrefix);
    }

    public SimpleJndiName removeSuffix(String suffix) {
        if (suffix == null) {
            return this;
        }
        int index = this.jndiName.lastIndexOf(suffix);
        if (index >= 0) {
            return new SimpleJndiName(this.jndiName.substring(0, index));
        }
        return this;
    }

    public String toString() {
        return this.jndiName;
    }

    public Name toName() throws InvalidNameException {
        return new CompositeName(this.jndiName);
    }

    private boolean isKnownNamespaceId() {
        return this.jndiName.equals(JNDI_CTX_JAVA_GLOBAL_NS_ID) || this.jndiName.equals(JNDI_CTX_JAVA_APP_NS_ID) || this.jndiName.equals(JNDI_CTX_JAVA_MODULE_NS_ID) || this.jndiName.equals(JNDI_CTX_JAVA_COMPONENT_NS_ID);
    }

    public static boolean isValidJndiName(String jndiName) {
        return jndiName != null;
    }

    public static SimpleJndiName of(Name name) {
        return name == null ? null : new SimpleJndiName(name.toString());
    }

    public static SimpleJndiName of(String name) {
        return name == null ? null : new SimpleJndiName(name);
    }
}

