/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.rotation;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jul.rotation.MeteredStream;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class LogFileManager {
    private static final Logger LOG = Logger.getLogger(LogFileManager.class.getName());
    private static final DateTimeFormatter SUFFIX_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss");
    private static final String GZIP_EXTENSION = ".gz";
    private final File logFile;
    private final long maxFileSize;
    private final boolean compressOldLogFiles;
    private final int maxCountOfOldLogFiles;
    private final HandlerSetStreamMethod streamSetter;
    private final HandlerCloseStreamMethod streamCloser;
    private MeteredStream meter;

    public LogFileManager(File logFile, long maxFileSize, boolean compressOldLogFiles, int maxCountOfOldLogFiles, HandlerSetStreamMethod streamSetter, HandlerCloseStreamMethod streamCloser) {
        this.logFile = logFile;
        this.maxFileSize = maxFileSize;
        this.compressOldLogFiles = compressOldLogFiles;
        this.maxCountOfOldLogFiles = maxCountOfOldLogFiles;
        this.streamSetter = streamSetter;
        this.streamCloser = streamCloser;
    }

    public long getFileSize() {
        return this.meter == null ? this.logFile.length() : this.meter.getBytesWritten();
    }

    public void rollIfFileTooBig() {
        if (this.isRollFileSizeLimitReached()) {
            this.roll();
        }
    }

    public void rollIfFileNotEmpty() {
        if (this.getFileSize() > 0L) {
            this.roll();
        }
    }

    public synchronized void roll() {
        LOG.log(Level.FINE, "roll(); {0}", this.logFile);
        boolean wasOutputEnabled = this.isOutputEnabled();
        this.disableOutput();
        File archivedFile = this.rollToNewFile();
        Runnable cleanup = () -> this.cleanUpHistoryLogFiles(archivedFile);
        new Thread(cleanup, "old-log-files-cleanup-" + this.logFile.getName()).start();
        if (wasOutputEnabled) {
            this.enableOutput();
        }
    }

    public synchronized boolean isOutputEnabled() {
        return this.meter != null;
    }

    public synchronized void enableOutput() {
        if (this.isOutputEnabled()) {
            return;
        }
        File parent = this.logFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Failed to create the parent directory " + parent.getAbsolutePath());
        }
        try {
            FileOutputStream fout = new FileOutputStream(this.logFile, true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            this.meter = new MeteredStream(bout, this.logFile.length());
            if (this.streamSetter != null) {
                this.streamSetter.setStream(this.meter);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not open the log file for writing: " + this.logFile, e);
        }
    }

    public synchronized void disableOutput() {
        if (this.isOutputEnabled()) {
            if (this.streamCloser != null) {
                this.streamCloser.close();
            }
            try {
                this.meter.close();
            }
            catch (IOException e) {
                GlassFishLoggingTracer.error(this.getClass(), "Could not close the output stream.", e);
            }
            this.meter = null;
        }
    }

    private boolean isRollFileSizeLimitReached() {
        if (this.maxFileSize <= 0L) {
            return false;
        }
        long fileSize = this.getFileSize();
        return fileSize >= this.maxFileSize;
    }

    private File rollToNewFile() {
        try {
            if (this.logFile.createNewFile()) {
                LOG.log(Level.FINE, "Created new log file: {0}", this.logFile);
                return null;
            }
            LOG.log(Level.FINE, "Rolling log file: {0}", this.logFile);
            File archivedLogFile = this.prepareAchivedLogFileTarget();
            this.moveFile(this.logFile, archivedLogFile);
            this.forceOSFilesync(this.logFile);
            return archivedLogFile;
        }
        catch (Exception e) {
            this.logError("Error, could not rotate log file", e);
            return null;
        }
    }

    private File prepareAchivedLogFileTarget() {
        String archivedFileNameBase = this.logFile.getName() + "_" + SUFFIX_FORMATTER.format(LocalDateTime.now());
        int counter = 1;
        String archivedFileName = archivedFileNameBase;
        while (true) {
            File archivedLogFile = new File(this.logFile.getParentFile(), archivedFileName);
            File archivedGzLogFile = this.getGzArchiveFile(archivedLogFile);
            if (!archivedLogFile.exists() && !archivedGzLogFile.exists()) {
                return archivedLogFile;
            }
            archivedFileName = archivedFileNameBase + "_" + ++counter;
        }
    }

    private void forceOSFilesync(File file) throws IOException {
        new FileOutputStream(file).close();
    }

    private void moveFile(File logFileToArchive, File target) throws IOException {
        LOG.log(Level.FINE, () -> String.format("moveFile(logFileToArchive=%s, target=%s)", logFileToArchive, target));
        boolean renameSuccess = logFileToArchive.renameTo(target);
        if (!renameSuccess) {
            this.logError(String.format("File %s could not be renamed to %s trying to copy and delete it with NIO.", logFileToArchive, target));
            Files.copy(logFileToArchive.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
    }

    private synchronized void cleanUpHistoryLogFiles(File rotatedFile) {
        if (this.compressOldLogFiles) {
            this.compressFile(rotatedFile);
        }
        this.deleteOldLogFiles();
    }

    private void compressFile(File rotatedFile) {
        long start = System.currentTimeMillis();
        File outFile = this.getGzArchiveFile(rotatedFile);
        boolean compressed = this.gzipFile(rotatedFile, outFile);
        if (compressed) {
            long time = System.currentTimeMillis() - start;
            LOG.log(Level.FINE, "File {0} of size {1} has been archived to file {2} of size {3} in {4} ms", new Object[]{rotatedFile, rotatedFile.length(), outFile, outFile.length(), time});
            boolean deleted = rotatedFile.delete();
            if (!deleted) {
                this.logError("Could not delete uncompressed log file: " + rotatedFile.getAbsolutePath());
            }
        } else {
            this.logError("Could not compress log file: " + rotatedFile.getAbsolutePath());
        }
    }

    private File getGzArchiveFile(File rotatedFile) {
        return new File(rotatedFile.getParentFile(), rotatedFile.getName() + GZIP_EXTENSION);
    }

    private void deleteOldLogFiles() {
        if (this.maxCountOfOldLogFiles == 0) {
            return;
        }
        File dir = this.logFile.getParentFile();
        String logFileName = this.logFile.getName();
        if (dir == null) {
            return;
        }
        FileFilter filter = f -> f.isFile() && !f.getName().equals(logFileName) && f.getName().startsWith(logFileName);
        Arrays.stream(dir.listFiles(filter)).sorted(Comparator.comparing(File::getName).reversed()).skip(this.maxCountOfOldLogFiles).forEach(this::deleteFile);
    }

    private void deleteFile(File file) {
        boolean delFile = file.delete();
        if (!delFile) {
            this.logError("Could not delete the log file: " + file);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean gzipFile(File inputFile, File outputFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logError(String message) {
        GlassFishLoggingTracer.error(this.getClass(), message);
        LOG.log(Level.SEVERE, message);
    }

    private void logError(String message, Throwable t) {
        GlassFishLoggingTracer.error(this.getClass(), message, t);
        LOG.log(Level.SEVERE, message, t);
    }

    @FunctionalInterface
    public static interface HandlerSetStreamMethod {
        public void setStream(OutputStream var1);
    }

    @FunctionalInterface
    public static interface HandlerCloseStreamMethod {
        public void close();
    }
}

